/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractTlsSecret
implements TlsSecret {
    protected byte[] data;

    protected AbstractTlsSecret(byte[] byArray) {
        this.data = byArray;
    }

    protected abstract TlsSecret adoptLocalSecret(byte[] var1);

    protected void checkAlive() {
        if (this.data == null) {
            throw new IllegalStateException("Secret has already been extracted or destroyed");
        }
    }

    protected abstract AbstractTlsCrypto getCrypto();

    @Override
    public TlsCipher createCipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        return this.getCrypto().createCipher(tlsCryptoParameters, n, n2);
    }

    @Override
    public synchronized void destroy() {
        if (this.data != null) {
            Arrays.fill((byte[])this.data, (byte)0);
            this.data = null;
        }
    }

    @Override
    public synchronized byte[] encrypt(TlsCertificate tlsCertificate) throws IOException {
        this.checkAlive();
        return this.getCrypto().createEncryptor(tlsCertificate).encrypt(this.data, 0, this.data.length);
    }

    @Override
    public synchronized byte[] extract() {
        this.checkAlive();
        byte[] byArray = this.data;
        this.data = null;
        return byArray;
    }

    @Override
    public synchronized TlsSecret hkdfExpand(short s, byte[] byArray, int n) {
        int n2;
        this.checkAlive();
        byte[] byArray2 = this.data;
        AbstractTlsCrypto abstractTlsCrypto = this.getCrypto();
        TlsHMAC tlsHMAC = abstractTlsCrypto.createHMAC(s);
        tlsHMAC.setKey(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[n];
        int n3 = tlsHMAC.getMacLength();
        byte[] byArray4 = new byte[n3];
        byte by = 0;
        for (int i = 0; i < n; i += n2) {
            if (by != 0) {
                tlsHMAC.update(byArray4, 0, byArray4.length);
            }
            tlsHMAC.update(byArray, 0, byArray.length);
            tlsHMAC.update(new byte[]{by = (byte)((byte)(by + 1))}, 0, 1);
            tlsHMAC.calculateMAC(byArray4, 0);
            n2 = Math.min(n3, n - i);
            System.arraycopy(byArray4, 0, byArray3, i, n2);
        }
        return this.adoptLocalSecret(byArray3);
    }

    @Override
    public synchronized TlsSecret hkdfExtract(short s, byte[] byArray) {
        this.checkAlive();
        byte[] byArray2 = this.data;
        AbstractTlsCrypto abstractTlsCrypto = this.getCrypto();
        TlsHMAC tlsHMAC = abstractTlsCrypto.createHMAC(s);
        tlsHMAC.setKey(byArray2, 0, byArray2.length);
        tlsHMAC.update(byArray, 0, byArray.length);
        byte[] byArray3 = tlsHMAC.calculateMAC();
        return this.adoptLocalSecret(byArray3);
    }

    synchronized byte[] copyData() {
        return Arrays.clone((byte[])this.data);
    }
}

