/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import com.gitlab.pdftk_java.ErrorCode;
import com.gitlab.pdftk_java.InputPdf;
import com.gitlab.pdftk_java.TK_Session;
import com.gitlab.pdftk_java.pdftk;
import com.gitlab.pdftk_java.report;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.IllegalFormatException;
import pdftk.com.lowagie.text.Document;
import pdftk.com.lowagie.text.DocumentException;
import pdftk.com.lowagie.text.pdf.PdfCopy;
import pdftk.com.lowagie.text.pdf.PdfDictionary;
import pdftk.com.lowagie.text.pdf.PdfImportedPage;
import pdftk.com.lowagie.text.pdf.PdfName;
import pdftk.com.lowagie.text.pdf.PdfObject;
import pdftk.com.lowagie.text.pdf.PdfReader;

class burst {
    TK_Session session;
    String m_output_filename;
    InputPdf m_input_pdf;
    boolean m_output_utf8_b;

    burst(TK_Session session) {
        this.session = session;
        this.m_output_filename = session.m_output_filename;
        this.m_input_pdf = session.m_input_pdf.get(0);
        this.m_output_utf8_b = session.m_output_utf8_b;
    }

    ErrorCode create_output_burst() throws DocumentException, IOException {
        ErrorCode ret_val = ErrorCode.NO_ERROR;
        PdfReader input_reader_p = this.m_input_pdf.m_readers.get((int)0).second;
        int input_num_pages = this.m_input_pdf.m_num_pages;
        if (this.m_output_filename.equals("PROMPT")) {
            this.m_output_filename = pdftk.prompt_for_filename("Please enter a filename pattern for the PDF pages (e.g. pg_%04d.pdf):");
        }
        try {
            String s1 = String.format(this.m_output_filename, 1);
            String s2 = String.format(this.m_output_filename, 2);
            if (s1.equals(s2)) {
                this.m_output_filename = this.m_output_filename + "pg_%04d.pdf";
                String.format(this.m_output_filename, 1);
            }
        }
        catch (IllegalFormatException e) {
            System.err.println("Error: Invalid output pattern:");
            System.err.println("   " + this.m_output_filename);
            return ErrorCode.ERROR;
        }
        PdfDictionary input_info_p = null;
        PdfDictionary input_trailer_p = input_reader_p.getTrailer();
        if (input_trailer_p != null) {
            PdfObject input_info_po = PdfReader.getPdfObject(input_trailer_p.get(PdfName.INFO));
            if (input_info_po != null && input_info_po.isDictionary()) {
                input_info_p = (PdfDictionary)input_info_po;
            }
        }
        for (int ii = 0; ii < input_num_pages; ++ii) {
            byte[] input_reader_xmp_p;
            PdfDictionary info_copy_p;
            PdfDictionary writer_info_p;
            String output_filename_p = String.format(this.m_output_filename, ii + 1);
            OutputStream ofs_p = pdftk.get_output_stream_file(output_filename_p);
            if (ofs_p == null) {
                ret_val = ErrorCode.PARTIAL;
                continue;
            }
            Document output_doc_p = new Document();
            PdfCopy writer_p = new PdfCopy(output_doc_p, ofs_p);
            this.session.prepare_writer(writer_p);
            output_doc_p.addCreator("pdftk-java 3.2.0");
            output_doc_p.open();
            writer_p.setFromReader(input_reader_p);
            if (input_info_p != null && (writer_info_p = writer_p.getInfo()) != null && (info_copy_p = writer_p.copyDictionary(input_info_p)) != null) {
                writer_info_p.putAll(info_copy_p);
            }
            if ((input_reader_xmp_p = input_reader_p.getMetadata()) != null) {
                writer_p.setXmpMetadata(input_reader_xmp_p);
            }
            PdfImportedPage page_p = writer_p.getImportedPage(input_reader_p, ii + 1);
            writer_p.addPage(page_p);
            output_doc_p.close();
            writer_p.close();
        }
        String doc_data_fn = "doc_data.txt";
        int loc = this.m_output_filename.lastIndexOf(File.separatorChar);
        if (loc >= 0) {
            doc_data_fn = this.m_output_filename.substring(0, loc) + File.separatorChar + doc_data_fn;
        }
        try {
            PrintStream ofs = pdftk.get_print_stream(doc_data_fn, this.m_output_utf8_b);
            report.ReportOnPdf(ofs, input_reader_p, this.m_output_utf8_b);
        }
        catch (IOException e) {
            System.err.println("Error: unable to open file for output: doc_data.txt");
            ret_val = ErrorCode.PARTIAL;
        }
        return ret_val;
    }
}

