/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.graph;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.Range;
import org.gephi.filters.plugin.AbstractFilter;
import org.gephi.filters.plugin.graph.RangeUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.RangeFilter;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MutualDegreeRangeBuilder
implements FilterBuilder {
    public Category getCategory() {
        return FilterLibrary.TOPOLOGY;
    }

    public String getName() {
        return NbBundle.getMessage(MutualDegreeRangeBuilder.class, (String)"MutualDegreeRangeBuilder.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(MutualDegreeRangeBuilder.class, (String)"MutualDegreeRangeBuilder.description");
    }

    public MutualDegreeRangeFilter getFilter(Workspace workspace) {
        return new MutualDegreeRangeFilter();
    }

    public JPanel getPanel(Filter filter) {
        RangeUI ui = (RangeUI)Lookup.getDefault().lookup(RangeUI.class);
        if (ui != null) {
            return ui.getPanel((MutualDegreeRangeFilter)filter);
        }
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class MutualDegreeRangeFilter
    extends AbstractFilter
    implements RangeFilter,
    NodeFilter {
        private Range range;

        public MutualDegreeRangeFilter() {
            super(NbBundle.getMessage(MutualDegreeRangeFilter.class, (String)"MutualDegreeRangeBuilder.name"));
            this.addProperty(Range.class, "range");
        }

        public boolean init(Graph graph) {
            return graph.getNodeCount() != 0 && graph.isDirected();
        }

        public boolean evaluate(Graph graph, Node node) {
            DirectedGraph dgraph = (DirectedGraph)graph;
            int degree = 0;
            for (Edge e : dgraph.getOutEdges(node)) {
                if (dgraph.getMutualEdge(e) == null) continue;
                ++degree;
            }
            return this.range.isInRange((Number)degree);
        }

        public void finish() {
        }

        public Number[] getValues(Graph graph) {
            DirectedGraph dgraph = (DirectedGraph)graph;
            ArrayList<Integer> values = new ArrayList<Integer>(dgraph.getNodeCount());
            for (Node n : dgraph.getNodes()) {
                int degree = 0;
                for (Edge e : dgraph.getOutEdges(n)) {
                    if (dgraph.getMutualEdge(e) == null) continue;
                    ++degree;
                }
                values.add(degree);
            }
            return values.toArray(new Number[0]);
        }

        public FilterProperty getRangeProperty() {
            return this.getProperties()[0];
        }

        public Range getRange() {
            return this.range;
        }

        public void setRange(Range range) {
            this.range = range;
        }
    }
}

