/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistory;
import net.sourceforge.plantuml.sequencediagram.teoz.IntegerColored;
import net.sourceforge.plantuml.sequencediagram.teoz.LiveBoxesDrawer;
import net.sourceforge.plantuml.sequencediagram.teoz.Stairs2;
import net.sourceforge.plantuml.sequencediagram.teoz.StairsPosition;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LiveBoxes {
    private final EventsHistory eventsHistory;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final Map<Double, Double> delays = new TreeMap<Double, Double>();

    public LiveBoxes(EventsHistory eventsHistory, Rose skin, ISkinParam skinParam, Participant participant) {
        this.eventsHistory = eventsHistory;
        this.skin = skin;
        this.skinParam = skinParam;
    }

    public double getMaxPosition(StringBounder stringBounder) {
        int max = this.eventsHistory.getMaxValue();
        LiveBoxesDrawer drawer = new LiveBoxesDrawer(new SimpleContext2D(true), this.skin, this.skinParam, this.delays);
        return drawer.getWidth(stringBounder) / 2.0 * (double)max;
    }

    public void drawBoxes(UGraphic ug, Context2D context, double createY, double endY) {
        Stairs2 stairs = this.eventsHistory.getStairs(createY, endY);
        int max = stairs.getMaxValue();
        if (max == 0) {
            this.drawDestroys(ug, stairs, context);
        }
        for (int i = 1; i <= max; ++i) {
            this.drawOneLevel(ug, i, stairs, context);
        }
    }

    private void drawDestroys(UGraphic ug, Stairs2 stairs, Context2D context) {
        LiveBoxesDrawer drawer = new LiveBoxesDrawer(context, this.skin, this.skinParam, this.delays);
        for (StairsPosition yposition : stairs.getYs()) {
            drawer.drawDestroyIfNeeded(ug, yposition);
        }
    }

    private void drawOneLevel(UGraphic ug, int levelToDraw, Stairs2 stairs, Context2D context) {
        LiveBoxesDrawer drawer = new LiveBoxesDrawer(context, this.skin, this.skinParam, this.delays);
        ug = ug.apply(UTranslate.dx((double)(levelToDraw - 1) * drawer.getWidth(ug.getStringBounder()) / 2.0));
        boolean pending = true;
        Iterator<StairsPosition> it = stairs.getYs().iterator();
        while (it.hasNext()) {
            StairsPosition yposition = it.next();
            IntegerColored integerColored = stairs.getValue(yposition.getValue());
            int level = integerColored.getValue();
            if (pending && level == levelToDraw) {
                drawer.addStart(yposition.getValue(), integerColored.getColors());
                pending = false;
                continue;
            }
            if (pending || it.hasNext() && level >= levelToDraw) continue;
            drawer.doDrawing(ug, yposition);
            drawer.drawDestroyIfNeeded(ug, yposition);
            pending = true;
        }
    }

    public void delayOn(double y, double height) {
        this.delays.put(y, height);
    }
}

