/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import org.fibs.geotag.util.ClassLoaderUtil;
import org.xnap.commons.i18n.EmptyResourceBundle;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nCache;
import org.xnap.commons.i18n.I18nManager;

public class I18nFactory {
    private static final String BASENAME_KEY = "basename";
    public static final int DEFAULT = 0;
    public static final int FALLBACK = 1;
    public static final int READ_PROPERTIES = 2;
    public static final int NO_CACHE = 4;
    public static final String DEFAULT_BASE_NAME = "i18n.Messages";
    public static final String PROPS_FILENAME = "i18n.properties";
    private static final I18nCache i18nCache = new I18nCache();

    private I18nFactory() {
    }

    static void clearCache() {
        i18nCache.visit(new I18nCache.Visitor(){

            @Override
            public void visit(I18n i18n) {
                I18nManager.getInstance().remove(i18n);
            }
        });
        i18nCache.clear();
    }

    public static I18n getI18n(Class clazz) {
        return I18nFactory.getI18n(clazz, Locale.getDefault());
    }

    public static I18n getI18n(Class clazz, Locale locale) {
        return I18nFactory.getI18n(clazz, locale, 3);
    }

    public static I18n getI18n(Class clazz, Locale locale, int flags) {
        ClassLoader classLoader = I18nFactory.getClassLoader(clazz.getClassLoader());
        String bundleName = null;
        if (I18nFactory.isReadPropertiesSet(flags)) {
            int index;
            String path = clazz.getName();
            while ((bundleName = I18nFactory.readFromPropertiesFile(path = (index = path.lastIndexOf(46)) != -1 ? path.substring(0, index) : "", locale, classLoader)) == null && index != -1) {
            }
        }
        if (bundleName == null) {
            bundleName = DEFAULT_BASE_NAME;
        }
        return I18nFactory.getI18n("", bundleName, classLoader, locale, flags);
    }

    public static I18n getI18n(Class clazz, String bundleName) {
        return I18nFactory.getI18n(clazz, bundleName, Locale.getDefault());
    }

    public static I18n getI18n(Class clazz, String bundleName, Locale locale) {
        return I18nFactory.getI18n(clazz, bundleName, locale, 0);
    }

    public static I18n getI18n(Class clazz, String bundleName, Locale locale, int flags) {
        return I18nFactory.getI18n(clazz.getName(), bundleName, clazz.getClassLoader(), locale, flags);
    }

    public static I18n getI18n(String path, String bundleName, ClassLoader classLoader, Locale locale, int flags) {
        int index;
        String prefix = path;
        do {
            String name;
            I18n i18n;
            if ((i18n = i18nCache.get(name = (prefix = (index = prefix.lastIndexOf(46)) != -1 ? prefix.substring(0, index) : "").length() == 0 ? bundleName : String.valueOf(prefix) + "." + bundleName, locale)) != null) {
                return i18n;
            }
            i18n = I18nFactory.findByBaseName(name, locale, I18nFactory.getClassLoader(classLoader), flags);
            if (i18n == null) continue;
            if ((flags & 4) == 0) {
                i18nCache.put(name, i18n);
            }
            return i18n;
        } while (index != -1);
        if (I18nFactory.isFallbackSet(flags)) {
            I18n i18n = i18nCache.get("", locale);
            if (i18n == null) {
                i18n = new I18n(new EmptyResourceBundle(locale));
                i18nCache.put("", i18n);
            }
            return i18n;
        }
        throw new MissingResourceException("Resource bundle not found", path, bundleName);
    }

    static ClassLoader getClassLoader(ClassLoader classLoader) {
        return classLoader != null ? classLoader : ClassLoaderUtil.getClassLoader();
    }

    static String readFromPropertiesFile(String path, Locale locale, ClassLoader loader) {
        Properties props = new Properties();
        String filename = path.length() == 0 ? PROPS_FILENAME : String.valueOf(path.replace('.', '/')) + "/" + PROPS_FILENAME;
        InputStream in = loader.getResourceAsStream(filename);
        if (in != null) {
            block12: {
                try {
                    try {
                        props.load(in);
                    }
                    catch (IOException iOException) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return props.getProperty(BASENAME_KEY);
        }
        return null;
    }

    static I18n findByBaseName(String baseName, Locale locale, ClassLoader loader, int flags) {
        try {
            return I18nFactory.createI18n(baseName, locale, loader, flags);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static I18n createI18n(String baseName, Locale locale, ClassLoader loader, int flags) {
        I18n i18n = new I18n(baseName, locale, loader);
        if (!I18nFactory.isNoCacheSet(flags)) {
            I18nManager.getInstance().add(i18n);
        }
        return i18n;
    }

    private static boolean isFallbackSet(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean isReadPropertiesSet(int flags) {
        return (flags & 2) != 0;
    }

    private static boolean isNoCacheSet(int flags) {
        return (flags & 4) != 0;
    }
}

