/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.preview;

import javax.swing.JPanel;
import org.gephi.io.exporter.preview.PNGExporter;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.preview.UIExporterPDF;
import org.gephi.ui.exporter.preview.UIExporterPNGPanel;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;

public class UIExporterPNG
implements ExporterUI {
    private UIExporterPNGPanel panel;
    private PNGExporter exporter;
    private ExporterPNGSettings settings = new ExporterPNGSettings();
    private ValidationPanel validationPanel;

    public JPanel getPanel() {
        this.panel = new UIExporterPNGPanel();
        this.validationPanel = UIExporterPNGPanel.createValidationPanel(this.panel);
        return this.validationPanel;
    }

    public void setup(Exporter exporter) {
        this.exporter = (PNGExporter)exporter;
        this.settings.load(this.exporter);
        this.panel.setup(this.exporter);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporter);
            this.settings.save(this.exporter);
        }
        this.panel = null;
        this.exporter = null;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof PNGExporter;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterPDF.class, (String)"UIExporterPNG.name");
    }

    private static class ExporterPNGSettings {
        private int width = 1024;
        private int height = 1024;
        private int margin = 4;
        private boolean transparentBackground;

        private ExporterPNGSettings() {
        }

        void load(PNGExporter exporter) {
            exporter.setHeight(this.height);
            exporter.setWidth(this.width);
            exporter.setMargin(this.margin);
            exporter.setTransparentBackground(this.transparentBackground);
        }

        void save(PNGExporter exporter) {
            this.height = exporter.getHeight();
            this.width = exporter.getWidth();
            this.margin = exporter.getMargin();
            this.transparentBackground = exporter.isTransparentBackground();
        }
    }
}

