/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class NbResourceStreamHandler
extends URLStreamHandler {
    public static final String PROTOCOL_SYSTEM_RESOURCE = "nbres";
    public static final String PROTOCOL_LOCALIZED_SYSTEM_RESOURCE = "nbresloc";

    @Override
    public URLConnection openConnection(URL u) throws IOException {
        if (u.getProtocol().equals(PROTOCOL_SYSTEM_RESOURCE)) {
            return new Connection(u, false);
        }
        if (u.getProtocol().equals(PROTOCOL_LOCALIZED_SYSTEM_RESOURCE)) {
            return new Connection(u, true);
        }
        throw new IOException("Bad protocol: " + u.getProtocol());
    }

    private static class Connection
    extends URLConnection {
        private final boolean localized;
        private URLConnection real;
        private IOException exception = null;

        public Connection(URL u, boolean localized) {
            super(u);
            this.localized = localized;
        }

        @Override
        public synchronized void connect() throws IOException {
            if (this.exception != null) {
                IOException e = this.exception;
                this.exception = null;
                throw e;
            }
            if (!this.connected) {
                URL target;
                String resource = this.url.getPath();
                if (resource.length() > 0 && resource.charAt(0) == '/') {
                    resource = resource.substring(1);
                } else {
                    Logger.getLogger(NbResourceStreamHandler.class.getName()).log(Level.WARNING, "URL path should begin with a slash: " + this.url);
                }
                ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                URL t1 = loader.getResource(resource);
                if (this.localized) {
                    String suffix;
                    String ext;
                    String base;
                    int dotIndex = resource.lastIndexOf(46);
                    if (dotIndex < resource.lastIndexOf(47)) {
                        dotIndex = -1;
                    }
                    if (dotIndex != -1) {
                        base = resource.substring(0, dotIndex);
                        ext = resource.substring(dotIndex);
                    } else {
                        base = resource;
                        ext = "";
                    }
                    target = null;
                    Iterator suffixes = NbBundle.getLocalizingSuffixes();
                    while (suffixes.hasNext() && (target = "".equals(suffix = (String)suffixes.next()) ? t1 : loader.getResource(base + suffix + ext)) == null) {
                    }
                } else {
                    target = t1;
                }
                if (target == null) {
                    throw new IOException(NbBundle.getMessage(NbResourceStreamHandler.class, (String)"EXC_nbres_cannot_connect", (Object)this.url));
                }
                this.real = target.openConnection();
                this.real.connect();
                this.connected = true;
            }
        }

        private void tryToConnect() {
            if (this.connected || this.exception != null) {
                return;
            }
            try {
                this.connect();
            }
            catch (IOException ioe) {
                this.exception = ioe;
            }
        }

        @Override
        public String getHeaderField(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(n);
            }
            return null;
        }

        @Override
        public String getHeaderFieldKey(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderFieldKey(n);
            }
            return null;
        }

        @Override
        public String getHeaderField(String key) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(key);
            }
            return null;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.real.getInputStream();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            this.connect();
            return this.real.getOutputStream();
        }

        @Override
        public String getContentType() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentType();
            }
            return "application/octet-stream";
        }

        @Override
        public int getContentLength() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentLength();
            }
            return 0;
        }

        @Override
        public long getLastModified() {
            if (this.connected && !this.real.getURL().toExternalForm().contains("http:")) {
                return this.real.getLastModified();
            }
            return 0L;
        }
    }
}

