/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

public class ModeSettingsPane
extends AbstractOptionPane {
    private ModeProperties global;
    private ModeProperties[] modeProps;
    private ModeProperties current;
    private Box captionBox;
    private JComboBox<String> mode;
    private JCheckBox useDefaults;
    private JTextField filenameGlob;
    private JTextField firstlineGlob;
    private JTextField noWordSep;
    private JCheckBox camelCasedWords;
    private JComboBox<String> folding;
    private JTextField collapseFolds;
    private JComboBox<String> wrap;
    private JComboBox<String> maxLineLen;
    private JComboBox<String> tabSize;
    private JComboBox<String> indentSize;
    private JCheckBox noTabs;
    private JCheckBox elasticTabstops;
    private JComboBox<String> autoIndent;
    private JCheckBox deepIndent;
    private String[] modeNames;

    public ModeSettingsPane() {
        super("modesettings");
    }

    @Override
    protected void _init() {
        Mode[] modeArray = this.reloadModes();
        this.mode = new JComboBox<String>(this.modeNames);
        this.mode.addActionListener(new ActionHandler());
        this.captionBox = new Box(0);
        this.addComponent(this.captionBox);
        this.addComponent(jEdit.getProperty("options.editing.mode"), this.mode);
        this.useDefaults = new JCheckBox(jEdit.getProperty("options.editing.useDefaults"));
        this.useDefaults.addActionListener(new ActionHandler());
        this.addComponent(this.useDefaults);
        this.noWordSep = new JTextField();
        this.addComponent(jEdit.getProperty("options.editing.noWordSep"), (Component)this.noWordSep);
        this.camelCasedWords = new JCheckBox(jEdit.getProperty("options.editing.camelCasedWords"));
        this.addComponent(this.camelCasedWords);
        String[] stringArray = FoldHandler.getFoldModes();
        this.folding = new JComboBox<String>(stringArray);
        this.addComponent(jEdit.getProperty("options.editing.folding"), this.folding);
        this.collapseFolds = new JTextField();
        this.addComponent(jEdit.getProperty("options.editing.collapseFolds"), (Component)this.collapseFolds);
        String[] stringArray2 = new String[]{"none", "soft", "hard"};
        this.wrap = new JComboBox<String>(stringArray2);
        this.addComponent(jEdit.getProperty("options.editing.wrap"), this.wrap);
        String[] stringArray3 = new String[]{"0", "72", "76", "80"};
        this.maxLineLen = new JComboBox<String>(stringArray3);
        this.maxLineLen.setToolTipText(jEdit.getProperty("options.editing.maxLineLen.tooltip"));
        this.addComponent(jEdit.getProperty("options.editing.maxLineLen"), this.maxLineLen);
        this.maxLineLen.setEditable(true);
        String[] stringArray4 = new String[]{"none", "simple", "full"};
        this.autoIndent = new JComboBox<String>(stringArray4);
        this.addComponent(jEdit.getProperty("options.editing.autoIndent"), this.autoIndent);
        String[] stringArray5 = new String[]{"2", "4", "8"};
        this.tabSize = new JComboBox<String>(stringArray5);
        this.addComponent(jEdit.getProperty("options.editing.tabSize"), this.tabSize);
        this.tabSize.setEditable(true);
        this.indentSize = new JComboBox<String>(stringArray5);
        this.addComponent(jEdit.getProperty("options.editing.indentSize"), this.indentSize);
        this.indentSize.setEditable(true);
        this.noTabs = new JCheckBox(jEdit.getProperty("options.editing.noTabs"));
        this.addComponent(this.noTabs);
        this.elasticTabstops = new JCheckBox(jEdit.getProperty("options.editing.elasticTabstops"));
        this.addComponent(this.elasticTabstops);
        this.elasticTabstops.setToolTipText(jEdit.getProperty("options.editing.elasticTabstops.tooltip"));
        this.deepIndent = new JCheckBox(jEdit.getProperty("options.editing.deepIndent"));
        this.addComponent(this.deepIndent);
        this.filenameGlob = new JTextField();
        this.filenameGlob.setToolTipText(jEdit.getProperty("glob.tooltip"));
        this.addComponent(jEdit.getProperty("options.editing.filenameGlob"), (Component)this.filenameGlob);
        this.firstlineGlob = new JTextField();
        this.addComponent(jEdit.getProperty("options.editing.firstlineGlob"), (Component)this.firstlineGlob);
        this.selectMode();
    }

    private Mode[] reloadModes() {
        Mode[] modeArray = jEdit.getModes();
        Arrays.sort(modeArray, new StandardUtilities.StringCompare(true));
        this.global = new ModeProperties();
        this.modeProps = new ModeProperties[modeArray.length];
        this.modeNames = new String[modeArray.length + 1];
        this.modeNames[0] = jEdit.getProperty("options.editing.global");
        for (int i = 0; i < modeArray.length; ++i) {
            this.modeProps[i] = new ModeProperties(modeArray[i]);
            this.modeNames[i + 1] = modeArray[i].getName();
        }
        return modeArray;
    }

    @Override
    protected void _save() {
        this.saveMode();
        this.global.save();
        for (ModeProperties modeProperties : this.modeProps) {
            modeProperties.save();
        }
    }

    private void saveMode() {
        this.current.useDefaults = this.useDefaults.isSelected();
        this.current.filenameGlob = this.filenameGlob.getText();
        this.current.firstlineGlob = this.firstlineGlob.getText();
        this.current.noWordSep = this.noWordSep.getText();
        this.current.camelCasedWords = this.camelCasedWords.isSelected();
        this.current.folding = (String)this.folding.getSelectedItem();
        this.current.collapseFolds = this.collapseFolds.getText();
        this.current.wrap = (String)this.wrap.getSelectedItem();
        this.current.maxLineLen = (String)this.maxLineLen.getSelectedItem();
        this.current.tabSize = (String)this.tabSize.getSelectedItem();
        this.current.indentSize = (String)this.indentSize.getSelectedItem();
        this.current.noTabs = this.noTabs.isSelected();
        this.current.elasticTabstops = this.elasticTabstops.isSelected();
        this.current.autoIndent = (String)this.autoIndent.getSelectedItem();
        this.current.deepIndent = this.deepIndent.isSelected();
    }

    private void selectMode() {
        int n = this.mode.getSelectedIndex() < 0 ? 0 : this.mode.getSelectedIndex();
        this.current = n == 0 ? this.global : this.modeProps[n - 1];
        this.current.edited = true;
        this.current.load();
        this.captionBox.removeAll();
        this.captionBox.add(GUIUtilities.createMultilineLabel(jEdit.getProperty("options.editing.caption-" + (n == 0 ? "0" : "1"))));
        this.useDefaults.setSelected(this.current.useDefaults);
        this.filenameGlob.setText(this.current.filenameGlob);
        this.firstlineGlob.setText(this.current.firstlineGlob);
        this.noWordSep.setText(this.current.noWordSep);
        this.camelCasedWords.setSelected(this.current.camelCasedWords);
        this.folding.setSelectedItem(this.current.folding);
        this.collapseFolds.setText(this.current.collapseFolds);
        this.wrap.setSelectedItem(this.current.wrap);
        this.maxLineLen.setSelectedItem(this.current.maxLineLen);
        this.tabSize.setSelectedItem(this.current.tabSize);
        this.indentSize.setSelectedItem(this.current.indentSize);
        this.noTabs.setSelected(this.current.noTabs);
        this.elasticTabstops.setSelected(this.current.elasticTabstops);
        this.autoIndent.setSelectedItem(this.current.autoIndent);
        this.deepIndent.setSelected(this.current.deepIndent);
        this.updateEnabled();
        this.revalidate();
    }

    private void updateEnabled() {
        boolean bl;
        if (this.current == this.global) {
            bl = true;
            this.useDefaults.setEnabled(false);
            this.filenameGlob.setEnabled(false);
            this.firstlineGlob.setEnabled(false);
        } else {
            bl = !this.modeProps[this.mode.getSelectedIndex() - 1].useDefaults;
            this.useDefaults.setEnabled(true);
            this.filenameGlob.setEnabled(bl);
            this.firstlineGlob.setEnabled(bl);
        }
        this.noWordSep.setEnabled(bl);
        this.camelCasedWords.setEnabled(bl);
        this.folding.setEnabled(bl);
        this.collapseFolds.setEnabled(bl);
        this.wrap.setEnabled(bl);
        this.maxLineLen.setEnabled(bl);
        this.tabSize.setEnabled(bl);
        this.indentSize.setEnabled(bl);
        this.noTabs.setEnabled(bl);
        this.elasticTabstops.setEnabled(bl);
        this.autoIndent.setEnabled(bl);
        this.deepIndent.setEnabled(bl);
    }

    private static class ModeProperties {
        Mode mode;
        boolean edited;
        boolean loaded;
        boolean useDefaults;
        String filenameGlob;
        String firstlineGlob;
        String noWordSep;
        boolean camelCasedWords;
        String folding;
        String collapseFolds;
        String wrap;
        String maxLineLen;
        String tabSize;
        String indentSize;
        boolean noTabs;
        boolean elasticTabstops;
        String autoIndent;
        boolean deepIndent;
        boolean isUserMode;

        ModeProperties() {
        }

        ModeProperties(Mode mode) {
            this.mode = mode;
        }

        void load() {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            if (this.mode != null) {
                this.mode.loadIfNecessary();
                this.useDefaults = !jEdit.getBooleanProperty("mode." + this.mode.getName() + ".customSettings");
                this.filenameGlob = (String)this.mode.getProperty("filenameGlob");
                this.firstlineGlob = (String)this.mode.getProperty("firstlineGlob");
                this.noWordSep = (String)this.mode.getProperty("noWordSep");
                this.camelCasedWords = this.mode.getBooleanProperty("camelCasedWords");
                this.folding = this.mode.getProperty("folding").toString();
                this.collapseFolds = this.mode.getProperty("collapseFolds").toString();
                this.wrap = this.mode.getProperty("wrap").toString();
                this.maxLineLen = this.mode.getProperty("maxLineLen").toString();
                this.tabSize = this.mode.getProperty("tabSize").toString();
                this.indentSize = this.mode.getProperty("indentSize").toString();
                this.noTabs = this.mode.getBooleanProperty("noTabs");
                this.elasticTabstops = this.mode.getBooleanProperty("elasticTabstops");
                this.autoIndent = this.mode.getProperty("autoIndent").toString();
                this.deepIndent = this.mode.getBooleanProperty("deepIndent");
                this.isUserMode = this.mode.isUserMode();
            } else {
                this.noWordSep = jEdit.getProperty("buffer.noWordSep");
                this.camelCasedWords = jEdit.getBooleanProperty("buffer.camelCasedWords");
                this.folding = jEdit.getProperty("buffer.folding");
                this.collapseFolds = jEdit.getProperty("buffer.collapseFolds");
                this.wrap = jEdit.getProperty("buffer.wrap");
                this.maxLineLen = jEdit.getProperty("buffer.maxLineLen");
                this.tabSize = jEdit.getProperty("buffer.tabSize");
                this.indentSize = jEdit.getProperty("buffer.indentSize");
                this.noTabs = jEdit.getBooleanProperty("buffer.noTabs");
                this.elasticTabstops = jEdit.getBooleanProperty("buffer.elasticTabstops");
                this.autoIndent = jEdit.getProperty("buffer.autoIndent");
                this.deepIndent = jEdit.getBooleanProperty("buffer.deepIndent");
            }
        }

        void save() {
            Object object;
            if (!this.edited) {
                return;
            }
            if (this.mode != null) {
                object = "mode." + this.mode.getName() + ".";
                jEdit.setBooleanProperty((String)object + "customSettings", !this.useDefaults);
                String string = (String)this.mode.getProperty("filenameGlob");
                String string2 = (String)this.mode.getProperty("firstlineGlob");
                if (this.useDefaults) {
                    jEdit.resetProperty((String)object + "filenameGlob");
                    jEdit.resetProperty((String)object + "firstlineGlob");
                    jEdit.resetProperty((String)object + "noWordSep");
                    jEdit.resetProperty((String)object + "camelCasedWords");
                    jEdit.resetProperty((String)object + "folding");
                    jEdit.resetProperty((String)object + "collapseFolds");
                    jEdit.resetProperty((String)object + "wrap");
                    jEdit.resetProperty((String)object + "maxLineLen");
                    jEdit.resetProperty((String)object + "tabSize");
                    jEdit.resetProperty((String)object + "indentSize");
                    jEdit.resetProperty((String)object + "noTabs");
                    jEdit.resetProperty((String)object + "elasticTabstops");
                    jEdit.resetProperty((String)object + "autoIndent");
                    jEdit.resetProperty((String)object + "deepIndent");
                    if (!Objects.equals(string, this.mode.getProperty("filenameGlob")) || !Objects.equals(string2, this.mode.getProperty("firstlineGlob"))) {
                        this.mode.init();
                    }
                    return;
                }
                jEdit.setProperty((String)object + "filenameGlob", this.filenameGlob);
                jEdit.setProperty((String)object + "firstlineGlob", this.firstlineGlob);
                if (!Objects.equals(string, this.filenameGlob) || !Objects.equals(string2, this.firstlineGlob)) {
                    this.mode.init();
                }
            } else {
                object = "buffer.";
            }
            jEdit.setProperty((String)object + "noWordSep", this.noWordSep);
            jEdit.setBooleanProperty((String)object + "camelCasedWords", this.camelCasedWords);
            jEdit.setProperty((String)object + "folding", this.folding);
            jEdit.setProperty((String)object + "collapseFolds", this.collapseFolds);
            jEdit.setProperty((String)object + "wrap", this.wrap);
            jEdit.setProperty((String)object + "maxLineLen", this.maxLineLen);
            jEdit.setProperty((String)object + "tabSize", this.tabSize);
            jEdit.setProperty((String)object + "indentSize", this.indentSize);
            jEdit.setProperty((String)object + "autoIndent", this.autoIndent);
            jEdit.setBooleanProperty((String)object + "noTabs", this.noTabs);
            jEdit.setBooleanProperty((String)object + "elasticTabstops", this.elasticTabstops);
            jEdit.setBooleanProperty((String)object + "deepIndent", this.deepIndent);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ModeSettingsPane.this.mode) {
                ModeSettingsPane.this.saveMode();
                ModeSettingsPane.this.selectMode();
            } else if (object == ModeSettingsPane.this.useDefaults) {
                ModeSettingsPane.this.modeProps[ModeSettingsPane.this.mode.getSelectedIndex() - 1].useDefaults = ModeSettingsPane.this.useDefaults.isSelected();
                ModeSettingsPane.this.updateEnabled();
            }
        }
    }
}

