/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.languagetool.tools.BuilderOptions;
import org.languagetool.tools.DictionaryBuilder;

final class SpellDictionaryBuilder
extends DictionaryBuilder {
    SpellDictionaryBuilder(File infoFile) throws IOException {
        super(infoFile);
    }

    public static void main(String[] args) throws Exception {
        BuilderOptions builderOptions = new BuilderOptions();
        builderOptions.addOption("i", true, "plain text dictionary file, e.g. created from a Hunspell dictionary by 'unmunch'", true);
        builderOptions.addOption("info", true, "*.info properties file, see http://wiki.languagetool.org/developing-a-tagger-dictionary", true);
        builderOptions.addOption("freq", true, "optional .xml file with a frequency wordlist, see http://wiki.languagetool.org/developing-a-tagger-dictionary", false);
        CommandLine cmdLine = builderOptions.parseArguments(args, SpellDictionaryBuilder.class);
        String plainTextFile = cmdLine.getOptionValue("i");
        String infoFile = cmdLine.getOptionValue("info");
        SpellDictionaryBuilder builder = new SpellDictionaryBuilder(new File(infoFile));
        builder.setOutputFilename(cmdLine.getOptionValue("o"));
        File inputFile = new File(plainTextFile);
        if (cmdLine.hasOption("freq")) {
            builder.readFreqList(new File(cmdLine.getOptionValue("freq")));
            inputFile = builder.addFreqData(inputFile, true);
        }
        builder.build(inputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File build(File plainTextDictFile) throws Exception {
        File tempFile = null;
        try {
            tempFile = this.tokenizeInput(plainTextDictFile);
            File file = this.buildFSA(tempFile);
            return file;
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    private File tokenizeInput(File plainTextDictFile) throws IOException {
        String encoding = this.getOption("fsa.dict.encoding");
        String separatorChar = this.hasOption("fsa.dict.separator") ? this.getOption("fsa.dict.separator") : "";
        File tempFile = File.createTempFile(SpellDictionaryBuilder.class.getSimpleName(), ".txt");
        tempFile.deleteOnExit();
        try (Scanner scanner = new Scanner(plainTextDictFile, encoding);
             BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), encoding));){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                int sepPos = separatorChar.isEmpty() ? -1 : line.indexOf(separatorChar);
                String occurrences = sepPos != -1 ? line.substring(sepPos + separatorChar.length()) : "";
                String lineWithoutOcc = sepPos != -1 ? line.substring(0, sepPos) : line;
                List<String> tokens = Arrays.asList(lineWithoutOcc);
                for (String token : tokens) {
                    if (token.length() <= 0) continue;
                    out.write(token);
                    if (sepPos != -1) {
                        out.write(separatorChar);
                        if (tokens.size() == 1) {
                            out.write(occurrences);
                        } else {
                            ((Writer)out).write(65);
                        }
                    }
                    ((Writer)out).write(10);
                }
            }
        }
        return tempFile;
    }
}

