/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.AbstractUnitConversionRule;

public class UnitConversionRuleTestHelper {
    private boolean verbose = false;

    public UnitConversionRuleTestHelper() {
    }

    public UnitConversionRuleTestHelper(boolean verbose) {
        this.verbose = verbose;
    }

    public void assertMatches(String input, int expectedMatches, String converted, AbstractUnitConversionRule rule, JLanguageTool lt) throws IOException {
        Object[] matches = rule.match(lt.getAnalyzedSentence(input));
        if (this.verbose) {
            System.out.println("----------------------------------------");
            System.out.println(input);
            for (Object match : matches) {
                System.out.println(match);
                System.out.println(match.getSuggestedReplacements());
            }
        }
        Assert.assertThat((String)("Got matches: " + Arrays.toString(matches)), (Object)matches.length, (Matcher)CoreMatchers.is((Object)expectedMatches));
        if (expectedMatches > 0 && converted != null) {
            Object match = matches[0];
            boolean suggestionCorrect = false;
            String suggestion = null;
            for (String s : match.getSuggestedReplacements()) {
                if (!s.contains(converted)) continue;
                suggestionCorrect = true;
                suggestion = s;
                break;
            }
            Assert.assertTrue((String)("Suggestion is correct: " + suggestion + " / expected: " + converted), (boolean)suggestionCorrect);
        }
    }
}

