/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.cache.decorators;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheException;

public class BlockingCache
implements Cache {
    private long timeout;
    private final Cache delegate;
    private final ConcurrentHashMap<Object, ReentrantLock> locks;

    public BlockingCache(Cache delegate) {
        this.delegate = delegate;
        this.locks = new ConcurrentHashMap();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }

    @Override
    public void putObject(Object key, Object value) {
        try {
            this.delegate.putObject(key, value);
        }
        finally {
            this.releaseLock(key);
        }
    }

    @Override
    public Object getObject(Object key) {
        this.acquireLock(key);
        Object value = this.delegate.getObject(key);
        if (value != null) {
            this.releaseLock(key);
        }
        return value;
    }

    @Override
    public Object removeObject(Object key) {
        this.releaseLock(key);
        return null;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    private ReentrantLock getLockForKey(Object key) {
        return this.locks.computeIfAbsent(key, k -> new ReentrantLock());
    }

    private void acquireLock(Object key) {
        block4: {
            ReentrantLock lock = this.getLockForKey(key);
            if (this.timeout > 0L) {
                try {
                    boolean acquired = lock.tryLock(this.timeout, TimeUnit.MILLISECONDS);
                    if (!acquired) {
                        throw new CacheException("Couldn't get a lock in " + this.timeout + " for the key " + key + " at the cache " + this.delegate.getId());
                    }
                    break block4;
                }
                catch (InterruptedException e) {
                    throw new CacheException("Got interrupted while trying to acquire lock for key " + key, e);
                }
            }
            lock.lock();
        }
    }

    private void releaseLock(Object key) {
        ReentrantLock lock = this.locks.get(key);
        if (lock.isHeldByCurrentThread()) {
            lock.unlock();
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

