/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.control.Control;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.ValidationResult;

public interface Validator<T>
extends BiFunction<Control, T, ValidationResult> {
    @SafeVarargs
    public static <T> Validator<T> combine(Validator<T> ... validators) {
        return (control, value) -> Stream.of(validators).map(validator -> (ValidationResult)validator.apply(control, value)).collect(Collectors.reducing(new ValidationResult(), ValidationResult::combine));
    }

    public static <T> Validator<T> createEmptyValidator(String message, Severity severity) {
        return (c, value) -> {
            boolean condition = value instanceof String ? value.toString().trim().isEmpty() : value == null;
            return ValidationResult.fromMessageIf(c, message, severity, condition);
        };
    }

    public static <T> Validator<T> createEmptyValidator(String message) {
        return Validator.createEmptyValidator(message, Severity.ERROR);
    }

    public static <T> Validator<T> createEqualsValidator(String message, Severity severity, Collection<T> values2) {
        return (c, value) -> ValidationResult.fromMessageIf(c, message, severity, !values2.contains(value));
    }

    public static <T> Validator<T> createEqualsValidator(String message, Collection<T> values2) {
        return Validator.createEqualsValidator(message, Severity.ERROR, values2);
    }

    public static <T> Validator<T> createPredicateValidator(Predicate<T> predicate, String message) {
        return Validator.createPredicateValidator(predicate, message, Severity.ERROR);
    }

    public static <T> Validator<T> createPredicateValidator(Predicate<T> predicate, String message, Severity severity) {
        return (control, value) -> ValidationResult.fromMessageIf(control, message, severity, !predicate.test(value));
    }

    public static Validator<String> createRegexValidator(String message, String regex, Severity severity) {
        return (c, value) -> {
            boolean condition = value == null ? true : !Pattern.matches(regex, value);
            return ValidationResult.fromMessageIf(c, message, severity, condition);
        };
    }

    public static Validator<String> createRegexValidator(String message, Pattern regex, Severity severity) {
        return (c, value) -> {
            boolean condition = value == null ? true : !regex.matcher((CharSequence)value).matches();
            return ValidationResult.fromMessageIf(c, message, severity, condition);
        };
    }
}

