/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class OWLEntityRemover
implements OWLEntityVisitor {
    private final List<RemoveAxiom> changes = new ArrayList<RemoveAxiom>();
    @Nonnull
    private final Collection<OWLOntology> ontologies;

    public OWLEntityRemover(@Nonnull Set<OWLOntology> ontologies) {
        this.ontologies = new ArrayList<OWLOntology>((Collection)OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null"));
    }

    @Nonnull
    public List<RemoveAxiom> getChanges() {
        return new ArrayList<RemoveAxiom>(this.changes);
    }

    public void reset() {
        this.changes.clear();
    }

    private void generateChanges(@Nonnull OWLEntity entity) {
        OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null");
        for (OWLOntology ont : this.ontologies) {
            assert (ont != null);
            for (OWLAxiom oWLAxiom : ont.getReferencingAxioms((OWLPrimitive)entity, Imports.EXCLUDED)) {
                assert (oWLAxiom != null);
                this.changes.add(new RemoveAxiom(ont, oWLAxiom));
            }
            for (OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom : ont.getAnnotationAssertionAxioms(entity.getIRI())) {
                assert (oWLAnnotationAssertionAxiom != null);
                this.changes.add(new RemoveAxiom(ont, oWLAnnotationAssertionAxiom));
            }
        }
    }

    @Override
    public void visit(OWLClass cls) {
        this.generateChanges(cls);
    }

    @Override
    public void visit(OWLDatatype datatype) {
        this.generateChanges(datatype);
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.generateChanges(individual);
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.generateChanges(property);
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.generateChanges(property);
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.generateChanges(property);
    }
}

