/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.user;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.protege.editor.core.prefs.Preferences;

public class UserNamePreferencesManager {
    public static final String PREFERENCES_KEY = "user.name";
    private static final String USE_GIT_USER_NAME = "use.git.user.name";
    private final Preferences preferences;

    public UserNamePreferencesManager(Preferences preferences) {
        this.preferences = (Preferences)Preconditions.checkNotNull((Object)preferences);
    }

    public boolean isUseGitUserNameIfAvailable() {
        return this.preferences.getBoolean(USE_GIT_USER_NAME, false);
    }

    public void setUseGitUserNameIfAvailable(boolean b) {
        this.preferences.putBoolean(USE_GIT_USER_NAME, b);
    }

    public Optional<String> getUserName() {
        return Optional.ofNullable(this.preferences.getString(PREFERENCES_KEY, null));
    }

    public void setUserName(String userName) {
        this.preferences.putString(PREFERENCES_KEY, (String)Preconditions.checkNotNull((Object)userName));
    }

    public void clearUserName() {
        this.preferences.putString(PREFERENCES_KEY, null);
    }
}

