/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor.apple;

import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.editor.apple.AppInstaller;
import net.sf.sdedit.ui.impl.UserInterfaceImpl;
import net.sf.sdedit.util.Proxy;
import net.sf.sdedit.util.Utilities;

public class ApplicationListenerImpl
extends AppInstaller {
    private Editor editor;
    private UserInterfaceImpl ui;
    private File fileToLoad;

    ApplicationListenerImpl() {
    }

    @Override
    void install(Editor editor) {
        this.editor = editor;
        this.ui = (UserInterfaceImpl)editor.getUI();
        Object app = Utilities.invoke("getApplication", "com.apple.eawt.Application", new Object[0]);
        if (app != null) {
            try {
                Utilities.invoke("setEnabledPreferencesMenu", app, true);
                Class<?> applicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
                Proxy proxy = new Proxy(this, applicationListenerClass);
                Utilities.invoke("addApplicationListener", app, proxy.instantiate());
                URL iconURL = Utilities.getResource("dock-icon.png");
                ImageIcon imageIcon = new ImageIcon(iconURL);
                Utilities.invoke("setDockIconImage", app, imageIcon.getImage());
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
        }
    }

    @Override
    public File fileToLoad() {
        return this.fileToLoad;
    }

    public void handleAbout(Object event) {
        this.ui.showAboutDialog(Utilities.getResource("about.html"));
        Utilities.invoke("setHandled", event, true);
    }

    public void handlePreferences(Object event) {
        this.ui.toFront();
        this.ui.configure(null);
        Utilities.invoke("setHandled", event, true);
    }

    public void handleQuit(Object event) {
        this.ui.toFront();
        this.editor.quit();
        Utilities.invoke("setHandled", event, false);
    }

    public void handlePrintFile(Object event) {
        Utilities.invoke("setHandled", event, true);
    }

    public void handleReOpenApplication(Object event) {
        this.ui.toFront();
        Utilities.invoke("setHandled", event, true);
    }

    public void handleOpenFile(Object event) {
        String fileName = (String)Utilities.invoke("getFilename", event, new Object[0]);
        File file = new File(fileName);
        if (!this.editor.isSetup()) {
            this.fileToLoad = file;
        } else {
            try {
                this.editor.load(file.toURI().toURL());
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception ex) {
                this.ui.errorMessage(ex, null, null);
            }
        }
        Utilities.invoke("setHandled", event, true);
    }

    public void handleOpenApplication(Object event) {
        String fileName = (String)Utilities.invoke("getFilename", event, new Object[0]);
        if (fileName != null) {
            this.handleOpenFile(event);
        }
    }
}

