/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.CdcrUpdateLog;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.PeerSyncWithLeader;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryStrategy
implements Runnable,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private int waitForUpdatesWithStaleStatePauseMilliSeconds = Integer.getInteger("solr.cloud.wait-for-updates-with-stale-state-pause", 2500);
    private int maxRetries = 500;
    private int startingRecoveryDelayMilliSeconds = 2000;
    private volatile boolean close = false;
    private RecoveryListener recoveryListener;
    private ZkController zkController;
    private String baseUrl;
    private String coreZkNodeName;
    private ZkStateReader zkStateReader;
    private volatile String coreName;
    private int retries;
    private boolean recoveringAfterStartup;
    private CoreContainer cc;
    private volatile HttpUriRequest prevSendPreRecoveryHttpUriRequest;
    private final Replica.Type replicaType;
    private CoreDescriptor coreDescriptor;
    public static Runnable testing_beforeReplayBufferingUpdates;

    protected RecoveryStrategy(CoreContainer cc, CoreDescriptor cd, RecoveryListener recoveryListener) {
        this.cc = cc;
        this.coreName = cd.getName();
        this.recoveryListener = recoveryListener;
        this.zkController = cc.getZkController();
        this.zkStateReader = this.zkController.getZkStateReader();
        this.baseUrl = this.zkController.getBaseUrl();
        this.coreZkNodeName = cd.getCloudDescriptor().getCoreNodeName();
        this.replicaType = cd.getCloudDescriptor().getReplicaType();
    }

    public final int getWaitForUpdatesWithStaleStatePauseMilliSeconds() {
        return this.waitForUpdatesWithStaleStatePauseMilliSeconds;
    }

    public final void setWaitForUpdatesWithStaleStatePauseMilliSeconds(int waitForUpdatesWithStaleStatePauseMilliSeconds) {
        this.waitForUpdatesWithStaleStatePauseMilliSeconds = waitForUpdatesWithStaleStatePauseMilliSeconds;
    }

    public final int getMaxRetries() {
        return this.maxRetries;
    }

    public final void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public final int getStartingRecoveryDelayMilliSeconds() {
        return this.startingRecoveryDelayMilliSeconds;
    }

    public final void setStartingRecoveryDelayMilliSeconds(int startingRecoveryDelayMilliSeconds) {
        this.startingRecoveryDelayMilliSeconds = startingRecoveryDelayMilliSeconds;
    }

    public final boolean getRecoveringAfterStartup() {
        return this.recoveringAfterStartup;
    }

    public final void setRecoveringAfterStartup(boolean recoveringAfterStartup) {
        this.recoveringAfterStartup = recoveringAfterStartup;
    }

    private final HttpSolrClient buildRecoverySolrClient(String leaderUrl) {
        UpdateShardHandlerConfig cfg = this.cc.getConfig().getUpdateShardHandlerConfig();
        return ((HttpSolrClient.Builder)((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(leaderUrl).withConnectionTimeout(cfg.getDistributedConnectionTimeout())).withSocketTimeout(cfg.getDistributedSocketTimeout())).withHttpClient(this.cc.getUpdateShardHandler().getRecoveryOnlyHttpClient())).build();
    }

    @Override
    public final void close() {
        this.close = true;
        if (this.prevSendPreRecoveryHttpUriRequest != null) {
            this.prevSendPreRecoveryHttpUriRequest.abort();
        }
        log.warn("Stopping recovery for core=[{}] coreNodeName=[{}]", (Object)this.coreName, (Object)this.coreZkNodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void recoveryFailed(SolrCore core, ZkController zkController, String baseUrl, String shardZkNodeName, CoreDescriptor cd) throws Exception {
        SolrException.log((Logger)log, (String)"Recovery failed - I give up.");
        try {
            zkController.publish(cd, Replica.State.RECOVERY_FAILED);
        }
        finally {
            this.close();
            this.recoveryListener.failed();
        }
    }

    protected String getReplicateLeaderUrl(ZkNodeProps leaderprops) {
        return new ZkCoreNodeProps(leaderprops).getCoreUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void replicate(String nodeName, SolrCore core, ZkNodeProps leaderprops) throws SolrServerException, IOException {
        String leaderUrl = this.getReplicateLeaderUrl(leaderprops);
        log.info("Attempting to replicate from [{}].", (Object)leaderUrl);
        this.commitOnLeader(leaderUrl);
        SolrRequestHandler handler = core.getRequestHandler("/replication");
        ReplicationHandler replicationHandler = (ReplicationHandler)handler;
        if (replicationHandler == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Skipping recovery, no /replication handler found");
        }
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.set("masterUrl", new String[]{leaderUrl});
        solrParams.set("skipCommitOnMasterVersionZero", this.replicaType == Replica.Type.TLOG);
        if (core.getUpdateHandler().getUpdateLog() != null && core.getUpdateHandler().getUpdateLog() instanceof CdcrUpdateLog) {
            solrParams.set("tlogFiles", true);
        }
        if (this.isClosed()) {
            return;
        }
        boolean success = replicationHandler.doFetch((SolrParams)solrParams, false).getSuccessful();
        if (!success) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replication for recovery failed.");
        }
        if (log.isDebugEnabled()) {
            try {
                RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
                SolrIndexSearcher searcher = searchHolder.get();
                Directory dir = core.getDirectoryFactory().get(core.getIndexDir(), DirectoryFactory.DirContext.META_DATA, null);
                try {
                    IndexCommit commit = core.getDeletionPolicy().getLatestCommit();
                    if (log.isDebugEnabled()) {
                        log.debug("{} replicated {} from {} gen: {} data: {} index: {} newIndex: {} files: {}", new Object[]{core.getCoreContainer().getZkController().getNodeName(), searcher.count((Query)new MatchAllDocsQuery()), leaderUrl, null == commit ? "null" : Long.valueOf(commit.getGeneration()), core.getDataDir(), core.getIndexDir(), core.getNewIndexDir(), Arrays.asList(dir.listAll())});
                    }
                }
                finally {
                    core.getDirectoryFactory().release(dir);
                    searchHolder.decref();
                }
            }
            catch (Exception e) {
                log.debug("Error in solrcloud_debug block", (Throwable)e);
            }
        }
    }

    private final void commitOnLeader(String leaderUrl) throws SolrServerException, IOException {
        try (HttpSolrClient client = this.buildRecoverySolrClient(leaderUrl);){
            UpdateRequest ureq = new UpdateRequest();
            ureq.setParams(new ModifiableSolrParams());
            ureq.getParams().set("openSearcher", false);
            ureq.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, true).process((SolrClient)client);
        }
    }

    @Override
    public final void run() {
        try (SolrCore core = this.cc.getCore(this.coreName);){
            if (core == null) {
                SolrException.log((Logger)log, (String)("SolrCore not found - cannot recover:" + this.coreName));
                return;
            }
            log.info("Starting recovery process. recoveringAfterStartup={}", (Object)this.recoveringAfterStartup);
            try {
                this.doRecovery(core);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                SolrException.log((Logger)log, (String)"", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
    }

    public final void doRecovery(SolrCore core) throws Exception {
        this.coreDescriptor = core.getCoreDescriptor();
        if (this.coreDescriptor.getCloudDescriptor().requiresTransactionLog()) {
            this.doSyncOrReplicateRecovery(core);
        } else {
            this.doReplicateOnlyRecovery(core);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doReplicateOnlyRecovery(SolrCore core) throws InterruptedException {
        boolean successfulRecovery = false;
        block29: while (!(successfulRecovery || Thread.currentThread().isInterrupted() || this.isClosed())) {
            try {
                block42: {
                    CloudDescriptor cloudDesc = this.coreDescriptor.getCloudDescriptor();
                    Replica leaderprops = this.zkStateReader.getLeaderRetry(cloudDesc.getCollectionName(), cloudDesc.getShardId());
                    String leaderBaseUrl = leaderprops.getStr("base_url");
                    String leaderCoreName = leaderprops.getStr("core");
                    String leaderUrl = ZkCoreNodeProps.getCoreUrl((String)leaderBaseUrl, (String)leaderCoreName);
                    String ourUrl = ZkCoreNodeProps.getCoreUrl((String)this.baseUrl, (String)this.coreName);
                    boolean isLeader = leaderUrl.equals(ourUrl);
                    if (isLeader && !cloudDesc.isLeader()) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cloud state still says we are leader.");
                    }
                    if (cloudDesc.isLeader()) {
                        assert (cloudDesc.getReplicaType() != Replica.Type.PULL);
                        log.warn("We have not yet recovered - but we are now the leader!");
                        log.info("Finished recovery process.");
                        this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                        return;
                    }
                    if (log.isInfoEnabled()) {
                        log.info("Publishing state of core [{}] as recovering, leader is [{}] and I am [{}]", new Object[]{core.getName(), leaderUrl, ourUrl});
                    }
                    this.zkController.publish(this.coreDescriptor, Replica.State.RECOVERING);
                    if (this.isClosed()) {
                        if (!log.isInfoEnabled()) break;
                        log.info("Recovery for core {} has been closed", (Object)core.getName());
                        break;
                    }
                    log.info("Starting Replication Recovery.");
                    log.info("Stopping background replicate from leader process");
                    this.zkController.stopReplicationFromLeader(this.coreName);
                    this.replicate(this.zkController.getNodeName(), core, (ZkNodeProps)leaderprops);
                    if (!this.isClosed()) break block42;
                    if (!log.isInfoEnabled()) break;
                    log.info("Recovery for core {} has been closed", (Object)core.getName());
                    break;
                }
                try {
                    log.info("Replication Recovery was successful.");
                    successfulRecovery = true;
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)"Error while trying to recover", (Throwable)e);
                }
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)("Error while trying to recover. core=" + this.coreName), (Throwable)e);
            }
            finally {
                if (successfulRecovery) {
                    log.info("Restarting background replicate from leader process");
                    this.zkController.startReplicationFromLeader(this.coreName, false);
                    log.info("Registering as Active after recovery.");
                    try {
                        this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                    }
                    catch (Exception e) {
                        log.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                        successfulRecovery = false;
                    }
                    if (successfulRecovery) {
                        this.close = true;
                        this.recoveryListener.recovered();
                    }
                }
            }
            if (successfulRecovery) continue;
            try {
                if (this.isClosed()) {
                    if (!log.isInfoEnabled()) break;
                    log.info("Recovery for core {} has been closed", (Object)core.getName());
                    break;
                }
                log.error("Recovery failed - trying again... ({})", (Object)this.retries);
                ++this.retries;
                if (this.retries >= this.maxRetries) {
                    SolrException.log((Logger)log, (String)("Recovery failed - max retries exceeded (" + this.retries + ")."));
                    try {
                        this.recoveryFailed(core, this.zkController, this.baseUrl, this.coreZkNodeName, this.coreDescriptor);
                    }
                    catch (Exception e) {
                        SolrException.log((Logger)log, (String)"Could not publish that recovery failed", (Throwable)e);
                    }
                    break;
                }
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)"An error has occurred during recovery", (Throwable)e);
            }
            try {
                int loopCount;
                int n = loopCount = this.retries < 4 ? (int)Math.min(Math.pow(2.0, this.retries), 12.0) : 12;
                if (log.isInfoEnabled()) {
                    log.info("Wait [{}] seconds before trying to recover again (attempt={})", (Object)TimeUnit.MILLISECONDS.toSeconds(loopCount * this.startingRecoveryDelayMilliSeconds), (Object)this.retries);
                }
                for (int i = 0; i < loopCount; ++i) {
                    if (this.isClosed()) {
                        if (!log.isInfoEnabled()) continue block29;
                        log.info("Recovery for core {} has been closed", (Object)core.getName());
                        continue block29;
                    }
                    Thread.sleep(this.startingRecoveryDelayMilliSeconds);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Recovery was interrupted.", (Throwable)e);
                this.close = true;
            }
        }
        log.info("Finished recovery process, successful=[{}]", (Object)successfulRecovery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void doSyncOrReplicateRecovery(SolrCore core) throws Exception {
        successfulRecovery = false;
        ulog = core.getUpdateHandler().getUpdateLog();
        if (ulog == null) {
            SolrException.log((Logger)RecoveryStrategy.log, (String)"No UpdateLog found - cannot recover.");
            this.recoveryFailed(core, this.zkController, this.baseUrl, this.coreZkNodeName, this.coreDescriptor);
            return;
        }
        firstTime = this.replicaType != Replica.Type.TLOG;
        try {
            recentUpdates = ulog.getRecentUpdates();
            try {
                recentVersions = recentUpdates.getVersions(ulog.getNumRecordsToKeep());
            }
            finally {
                if (recentUpdates != null) {
                    recentUpdates.close();
                }
            }
        }
        catch (Exception e) {
            SolrException.log((Logger)RecoveryStrategy.log, (String)"Corrupt tlog - ignoring.", (Throwable)e);
            recentVersions = new ArrayList<Long>(0);
        }
        startingVersions = ulog.getStartingVersions();
        if (startingVersions != null && this.recoveringAfterStartup) {
            try {
                v0 = firstStartingVersion = startingVersions.size() > 0 ? startingVersions.get(0) : 0L;
                for (oldIdx = 0; oldIdx < recentVersions.size() && recentVersions.get(oldIdx) != firstStartingVersion; ++oldIdx) {
                }
                if (oldIdx > 0) {
                    RecoveryStrategy.log.info("Found new versions added after startup: num=[{}]", (Object)oldIdx);
                    if (RecoveryStrategy.log.isInfoEnabled()) {
                        RecoveryStrategy.log.info("currentVersions size={} range=[{} to {}]", new Object[]{recentVersions.size(), recentVersions.get(0), recentVersions.get(recentVersions.size() - 1)});
                    }
                }
                if (startingVersions.isEmpty()) {
                    RecoveryStrategy.log.info("startupVersions is empty");
                } else if (RecoveryStrategy.log.isInfoEnabled()) {
                    RecoveryStrategy.log.info("startupVersions size={} range=[{} to {}]", new Object[]{startingVersions.size(), startingVersions.get(0), startingVersions.get(startingVersions.size() - 1)});
                }
            }
            catch (Exception e) {
                SolrException.log((Logger)RecoveryStrategy.log, (String)"Error getting recent versions.", (Throwable)e);
                recentVersions = new ArrayList<Long>(0);
            }
        }
        if (this.recoveringAfterStartup) {
            recentVersions = startingVersions;
            try {
                if (ulog.existOldBufferLog()) {
                    RecoveryStrategy.log.info("Looks like a previous replication recovery did not complete - skipping peer sync.");
                    firstTime = false;
                }
            }
            catch (Exception e) {
                SolrException.log((Logger)RecoveryStrategy.log, (String)"Error trying to get ulog starting operation.", (Throwable)e);
                firstTime = false;
            }
        }
        if (this.replicaType == Replica.Type.TLOG) {
            this.zkController.stopReplicationFromLeader(this.coreName);
        }
        ourUrl = ZkCoreNodeProps.getCoreUrl((String)this.baseUrl, (String)this.coreName);
        replayFuture = null;
        block66: while (!(successfulRecovery || Thread.currentThread().isInterrupted() || this.isClosed())) {
            block108: {
                block107: {
                    block106: {
                        block105: {
                            block103: {
                                block102: {
                                    block100: {
                                        block101: {
                                            block99: {
                                                cloudDesc = this.coreDescriptor.getCloudDescriptor();
                                                leader = this.pingLeader(ourUrl, this.coreDescriptor, true);
                                                if (!this.isClosed()) break block99;
                                                RecoveryStrategy.log.info("RecoveryStrategy has been closed");
                                                if (!successfulRecovery) break;
                                                RecoveryStrategy.log.info("Registering as Active after recovery.");
                                                try {
                                                    if (this.replicaType == Replica.Type.TLOG) {
                                                        this.zkController.startReplicationFromLeader(this.coreName, true);
                                                    }
                                                    this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                                                }
                                                catch (Exception e) {
                                                    RecoveryStrategy.log.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                                                    successfulRecovery = false;
                                                }
                                                if (!successfulRecovery) break;
                                                this.close = true;
                                                this.recoveryListener.recovered();
                                                break;
                                            }
                                            isLeader = leader.getCoreUrl().equals(ourUrl);
                                            if (isLeader && !cloudDesc.isLeader()) {
                                                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cloud state still says we are leader.");
                                            }
                                            if (!cloudDesc.isLeader()) break block100;
                                            RecoveryStrategy.log.warn("We have not yet recovered - but we are now the leader!");
                                            RecoveryStrategy.log.info("Finished recovery process.");
                                            this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                                            if (!successfulRecovery) break block101;
                                            RecoveryStrategy.log.info("Registering as Active after recovery.");
                                            try {
                                                if (this.replicaType == Replica.Type.TLOG) {
                                                    this.zkController.startReplicationFromLeader(this.coreName, true);
                                                }
                                                this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                                            }
                                            catch (Exception e) {
                                                RecoveryStrategy.log.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                                                successfulRecovery = false;
                                            }
                                            if (successfulRecovery) {
                                                this.close = true;
                                                this.recoveryListener.recovered();
                                            }
                                        }
                                        return;
                                    }
                                    RecoveryStrategy.log.info("Begin buffering updates. core=[{}]", (Object)this.coreName);
                                    ulog.bufferUpdates();
                                    if (RecoveryStrategy.log.isInfoEnabled()) {
                                        RecoveryStrategy.log.info("Publishing state of core [{}] as recovering, leader is [{}] and I am [{}]", new Object[]{core.getName(), leader.getCoreUrl(), ourUrl});
                                    }
                                    this.zkController.publish(this.coreDescriptor, Replica.State.RECOVERING);
                                    slice = this.zkStateReader.getClusterState().getCollection(cloudDesc.getCollectionName()).getSlice(cloudDesc.getShardId());
                                    try {
                                        this.prevSendPreRecoveryHttpUriRequest.abort();
                                    }
                                    catch (NullPointerException var13_29) {
                                        // empty catch block
                                    }
                                    if (!this.isClosed()) break block102;
                                    RecoveryStrategy.log.info("RecoveryStrategy has been closed");
                                    if (!successfulRecovery) break;
                                    RecoveryStrategy.log.info("Registering as Active after recovery.");
                                    try {
                                        if (this.replicaType == Replica.Type.TLOG) {
                                            this.zkController.startReplicationFromLeader(this.coreName, true);
                                        }
                                        this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                                    }
                                    catch (Exception e) {
                                        RecoveryStrategy.log.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                                        successfulRecovery = false;
                                    }
                                    if (!successfulRecovery) break;
                                    this.close = true;
                                    this.recoveryListener.recovered();
                                    break;
                                }
                                this.sendPrepRecoveryCmd(leader.getBaseUrl(), leader.getCoreName(), slice);
                                if (!this.isClosed()) break block103;
                                RecoveryStrategy.log.info("RecoveryStrategy has been closed");
                                if (!successfulRecovery) break;
                                RecoveryStrategy.log.info("Registering as Active after recovery.");
                                try {
                                    if (this.replicaType == Replica.Type.TLOG) {
                                        this.zkController.startReplicationFromLeader(this.coreName, true);
                                    }
                                    this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                                }
                                catch (Exception e) {
                                    RecoveryStrategy.log.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                                    successfulRecovery = false;
                                }
                                if (!successfulRecovery) break;
                                this.close = true;
                                this.recoveryListener.recovered();
                                break;
                            }
                            try {
                                Thread.sleep(this.waitForUpdatesWithStaleStatePauseMilliSeconds);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            if (!firstTime) ** GOTO lbl191
                            firstTime = false;
                            if (RecoveryStrategy.log.isInfoEnabled()) {
                                RecoveryStrategy.log.info("Attempting to PeerSync from [{}] - recoveringAfterStartup=[{}]", (Object)leader.getCoreUrl(), (Object)this.recoveringAfterStartup);
                            }
                            peerSyncWithLeader = new PeerSyncWithLeader(core, leader.getCoreUrl(), ulog.getNumRecordsToKeep());
                            try {
                                syncSuccess = peerSyncWithLeader.sync(recentVersions).isSuccess();
                            }
                            finally {
                                peerSyncWithLeader.close();
                            }
                            if (!syncSuccess) break block105;
                            req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
                            core.getUpdateHandler().commit(new CommitUpdateCommand(req, false));
                            req.close();
                            RecoveryStrategy.log.info("PeerSync stage of recovery was successful.");
                            this.cloudDebugLog(core, "synced");
                            RecoveryStrategy.log.info("Replaying updates buffered during PeerSync.");
                            replayFuture = this.replay(core);
                            successfulRecovery = true;
                            if (!successfulRecovery) break;
                            RecoveryStrategy.log.info("Registering as Active after recovery.");
                            try {
                                if (this.replicaType == Replica.Type.TLOG) {
                                    this.zkController.startReplicationFromLeader(this.coreName, true);
                                }
                                this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                            }
                            catch (Exception e) {
                                RecoveryStrategy.log.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                                successfulRecovery = false;
                            }
                            if (!successfulRecovery) break;
                            this.close = true;
                            this.recoveryListener.recovered();
                            break;
                        }
                        RecoveryStrategy.log.info("PeerSync Recovery was not successful - trying replication.");
lbl191:
                        // 2 sources

                        if (!this.isClosed()) break block106;
                        RecoveryStrategy.log.info("RecoveryStrategy has been closed");
                        if (!successfulRecovery) break;
                        RecoveryStrategy.log.info("Registering as Active after recovery.");
                        try {
                            if (this.replicaType == Replica.Type.TLOG) {
                                this.zkController.startReplicationFromLeader(this.coreName, true);
                            }
                            this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                        }
                        catch (Exception e) {
                            RecoveryStrategy.log.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                            successfulRecovery = false;
                        }
                        if (!successfulRecovery) break;
                        this.close = true;
                        this.recoveryListener.recovered();
                        break;
                    }
                    RecoveryStrategy.log.info("Starting Replication Recovery.");
                    this.replicate(this.zkController.getNodeName(), core, (ZkNodeProps)leader);
                    if (!this.isClosed()) break block107;
                    RecoveryStrategy.log.info("RecoveryStrategy has been closed");
                    if (!successfulRecovery) break;
                    RecoveryStrategy.log.info("Registering as Active after recovery.");
                    try {
                        if (this.replicaType == Replica.Type.TLOG) {
                            this.zkController.startReplicationFromLeader(this.coreName, true);
                        }
                        this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                    }
                    catch (Exception e) {
                        RecoveryStrategy.log.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                        successfulRecovery = false;
                    }
                    if (!successfulRecovery) break;
                    this.close = true;
                    this.recoveryListener.recovered();
                    break;
                }
                replayFuture = this.replay(core);
                if (!this.isClosed()) break block108;
                RecoveryStrategy.log.info("RecoveryStrategy has been closed");
                if (!successfulRecovery) break;
                RecoveryStrategy.log.info("Registering as Active after recovery.");
                try {
                    if (this.replicaType == Replica.Type.TLOG) {
                        this.zkController.startReplicationFromLeader(this.coreName, true);
                    }
                    this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                }
                catch (Exception e) {
                    RecoveryStrategy.log.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                    successfulRecovery = false;
                }
                if (!successfulRecovery) break;
                this.close = true;
                this.recoveryListener.recovered();
                break;
            }
            try {
                RecoveryStrategy.log.info("Replication Recovery was successful.");
                successfulRecovery = true;
                {
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        RecoveryStrategy.log.warn("Recovery was interrupted", (Throwable)e);
                        this.close = true;
                    }
                    catch (Exception e) {
                        SolrException.log((Logger)RecoveryStrategy.log, (String)"Error while trying to recover", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                SolrException.log((Logger)RecoveryStrategy.log, (String)("Error while trying to recover. core=" + this.coreName), (Throwable)e);
            }
            catch (Throwable var17_43) {
                throw var17_43;
            }
            finally {
                if (successfulRecovery) {
                    RecoveryStrategy.log.info("Registering as Active after recovery.");
                    try {
                        if (this.replicaType == Replica.Type.TLOG) {
                            this.zkController.startReplicationFromLeader(this.coreName, true);
                        }
                        this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                    }
                    catch (Exception e) {
                        RecoveryStrategy.log.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                        successfulRecovery = false;
                    }
                    if (successfulRecovery) {
                        this.close = true;
                        this.recoveryListener.recovered();
                    }
                }
            }
            if (successfulRecovery) continue;
            try {
                if (this.isClosed()) {
                    RecoveryStrategy.log.info("RecoveryStrategy has been closed");
                    break;
                }
                RecoveryStrategy.log.error("Recovery failed - trying again... ({})", (Object)this.retries);
                ++this.retries;
                if (this.retries >= this.maxRetries) {
                    SolrException.log((Logger)RecoveryStrategy.log, (String)("Recovery failed - max retries exceeded (" + this.retries + ")."));
                    try {
                        this.recoveryFailed(core, this.zkController, this.baseUrl, this.coreZkNodeName, this.coreDescriptor);
                    }
                    catch (Exception e) {
                        SolrException.log((Logger)RecoveryStrategy.log, (String)"Could not publish that recovery failed", (Throwable)e);
                    }
                    break;
                }
            }
            catch (Exception e) {
                SolrException.log((Logger)RecoveryStrategy.log, (String)"An error has occurred during recovery", (Throwable)e);
            }
            try {
                loopCount = Math.min(Math.pow(2.0, this.retries - 1), 30.0);
                RecoveryStrategy.log.info("Wait [{}] seconds before trying to recover again (attempt={})", (Object)(loopCount * (double)this.startingRecoveryDelayMilliSeconds), (Object)this.retries);
                i = 0;
                while ((double)i < loopCount) {
                    if (this.isClosed()) {
                        RecoveryStrategy.log.info("RecoveryStrategy has been closed");
                        continue block66;
                    }
                    Thread.sleep(this.startingRecoveryDelayMilliSeconds);
                    ++i;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                RecoveryStrategy.log.warn("Recovery was interrupted.", (Throwable)e);
                this.close = true;
            }
        }
        if (successfulRecovery && replayFuture == null) {
            RecoveryStrategy.log.info("Updating version bucket highest from index after successful recovery.");
            core.seedVersionBuckets();
        }
        RecoveryStrategy.log.info("Finished recovery process, successful=[{}]", (Object)successfulRecovery);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Replica pingLeader(String ourUrl, CoreDescriptor coreDesc, boolean mayPutReplicaAsDown) throws Exception {
        int numTried = 0;
        while (true) {
            Replica replica;
            CloudDescriptor cloudDesc = coreDesc.getCloudDescriptor();
            DocCollection docCollection = this.zkStateReader.getClusterState().getCollection(cloudDesc.getCollectionName());
            if (!this.isClosed() && mayPutReplicaAsDown && numTried == 1 && docCollection.getReplica(coreDesc.getCloudDescriptor().getCoreNodeName()).getState() == Replica.State.ACTIVE) {
                this.zkController.publish(coreDesc, Replica.State.DOWN);
            }
            ++numTried;
            Replica leaderReplica = null;
            if (this.isClosed()) {
                return leaderReplica;
            }
            try {
                leaderReplica = this.zkStateReader.getLeaderRetry(cloudDesc.getCollectionName(), cloudDesc.getShardId());
            }
            catch (SolrException e) {
                Thread.sleep(500L);
                continue;
            }
            if (leaderReplica.getCoreUrl().equals(ourUrl)) {
                return leaderReplica;
            }
            HttpSolrClient httpSolrClient = this.buildRecoverySolrClient(leaderReplica.getCoreUrl());
            try {
                SolrPingResponse resp = httpSolrClient.ping();
                replica = leaderReplica;
                if (httpSolrClient == null) return replica;
            }
            catch (Throwable throwable) {
                try {
                    if (httpSolrClient == null) throw throwable;
                    try {
                        httpSolrClient.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Failed to connect leader {} on recovery, try again", (Object)leaderReplica.getBaseUrl());
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    if (!(e.getCause() instanceof IOException)) return leaderReplica;
                    log.error("Failed to connect leader {} on recovery, try again", (Object)leaderReplica.getBaseUrl());
                    Thread.sleep(500L);
                }
            }
            httpSolrClient.close();
            return replica;
        }
    }

    private final Future<UpdateLog.RecoveryInfo> replay(SolrCore core) throws InterruptedException, ExecutionException {
        if (testing_beforeReplayBufferingUpdates != null) {
            testing_beforeReplayBufferingUpdates.run();
        }
        if (this.replicaType == Replica.Type.TLOG) {
            LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
            core.getUpdateHandler().getUpdateLog().copyOverBufferingUpdates(new CommitUpdateCommand(req, false));
            req.close();
            return null;
        }
        Future<UpdateLog.RecoveryInfo> future = core.getUpdateHandler().getUpdateLog().applyBufferedUpdates();
        if (future == null) {
            log.info("No replay needed.");
        } else {
            log.info("Replaying buffered documents.");
            UpdateLog.RecoveryInfo report = future.get();
            if (report.failed) {
                SolrException.log((Logger)log, (String)"Replay failed");
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replay failed");
            }
        }
        core.getUpdateHandler().getUpdateLog().openRealtimeSearcher();
        this.cloudDebugLog(core, "replayed");
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cloudDebugLog(SolrCore core, String op) {
        if (!log.isDebugEnabled()) {
            return;
        }
        try {
            RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
            SolrIndexSearcher searcher = searchHolder.get();
            try {
                int totalHits = searcher.count((Query)new MatchAllDocsQuery());
                String nodeName = core.getCoreContainer().getZkController().getNodeName();
                log.debug("[{}] {} [{} total hits]", new Object[]{nodeName, op, totalHits});
            }
            finally {
                searchHolder.decref();
            }
        }
        catch (Exception e) {
            log.debug("Error in solrcloud_debug block", (Throwable)e);
        }
    }

    public final boolean isClosed() {
        return this.close || this.cc.isShutDown();
    }

    private final void sendPrepRecoveryCmd(String leaderBaseUrl, String leaderCoreName, Slice slice) throws SolrServerException, IOException, InterruptedException, ExecutionException {
        CoreAdminRequest.WaitForState prepCmd = new CoreAdminRequest.WaitForState();
        prepCmd.setCoreName(leaderCoreName);
        prepCmd.setNodeName(this.zkController.getNodeName());
        prepCmd.setCoreNodeName(this.coreZkNodeName);
        prepCmd.setState(Replica.State.RECOVERING);
        prepCmd.setCheckLive(Boolean.valueOf(true));
        prepCmd.setOnlyIfLeader(true);
        Slice.State state = slice.getState();
        if (state != Slice.State.CONSTRUCTION && state != Slice.State.RECOVERY && state != Slice.State.RECOVERY_FAILED) {
            prepCmd.setOnlyIfLeaderActive(true);
        }
        int conflictWaitMs = this.zkController.getLeaderConflictResolveWait();
        int readTimeout = conflictWaitMs + Integer.parseInt(System.getProperty("prepRecoveryReadTimeoutExtraWait", "8000"));
        try (HttpSolrClient client = this.buildRecoverySolrClient(leaderBaseUrl);){
            client.setSoTimeout(readTimeout);
            HttpSolrClient.HttpUriRequestResponse mrr = client.httpUriRequest((SolrRequest)prepCmd);
            this.prevSendPreRecoveryHttpUriRequest = mrr.httpUriRequest;
            log.info("Sending prep recovery command to [{}]; [{}]", (Object)leaderBaseUrl, (Object)prepCmd);
            mrr.future.get();
        }
    }

    public static interface RecoveryListener {
        public void recovered();

        public void failed();
    }

    public static class Builder
    implements NamedListInitializedPlugin {
        private NamedList args;

        @Override
        public void init(NamedList args) {
            this.args = args;
        }

        public RecoveryStrategy create(CoreContainer cc, CoreDescriptor cd, RecoveryListener recoveryListener) {
            RecoveryStrategy recoveryStrategy = this.newRecoveryStrategy(cc, cd, recoveryListener);
            SolrPluginUtils.invokeSetters(recoveryStrategy, (Iterable<Map.Entry<String, Object>>)this.args);
            return recoveryStrategy;
        }

        protected RecoveryStrategy newRecoveryStrategy(CoreContainer cc, CoreDescriptor cd, RecoveryListener recoveryListener) {
            return new RecoveryStrategy(cc, cd, recoveryListener);
        }
    }
}

