/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class CustomComboRenderer
implements ListCellRenderer {
    private final JComboBox combo;
    private final ListCellRenderer renderer;
    private final JLabel rendererL;

    private CustomComboRenderer(JComboBox jComboBox) {
        this.combo = jComboBox;
        this.renderer = jComboBox.getRenderer();
        this.rendererL = this.renderer instanceof JLabel ? (JLabel)((Object)this.renderer) : null;
        this.combo.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                this.repaint();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                this.repaint();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                this.repaint();
            }

            private void repaint() {
                CustomComboRenderer.this.combo.repaint();
            }
        });
    }

    protected void setupRenderer(ListCellRenderer listCellRenderer, boolean bl) {
    }

    protected void setupRenderer(JLabel jLabel, boolean bl) {
    }

    public abstract java.lang.String value(Object var1);

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (this.rendererL != null) {
            this.setupRenderer(this.rendererL, this.combo.isPopupVisible());
        } else {
            this.setupRenderer(this.renderer, this.combo.isPopupVisible());
        }
        return this.renderer.getListCellRendererComponent(jList, this.value(object), n, bl, bl2);
    }

    public static final class Number
    extends CustomComboRenderer {
        private final java.lang.String units;
        private final boolean lAlign;

        public Number(JComboBox jComboBox, java.lang.String string, boolean bl) {
            super(jComboBox);
            this.units = string;
            this.lAlign = bl;
        }

        @Override
        protected void setupRenderer(JLabel jLabel, boolean bl) {
            if (bl || !this.lAlign) {
                jLabel.setHorizontalAlignment(11);
            } else {
                jLabel.setHorizontalAlignment(10);
            }
        }

        @Override
        public java.lang.String value(Object object) {
            java.lang.String string = this.units == null ? "" : " " + this.units;
            return Integer.valueOf(-1).equals(object) ? "default" : NumberFormat.getInstance().format(object) + string;
        }
    }

    public static final class Boolean
    extends CustomComboRenderer {
        public Boolean(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        public java.lang.String value(Object object) {
            if (java.lang.Boolean.TRUE.equals(object)) {
                return "enabled";
            }
            if (java.lang.Boolean.FALSE.equals(object)) {
                return "disabled";
            }
            return "default";
        }
    }

    public static final class String
    extends CustomComboRenderer {
        public String(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        public java.lang.String value(Object object) {
            return object == null ? "null" : object.toString();
        }
    }
}

