/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentEnumeratorDelegate<Data>
implements DataEnumeratorEx<Data>,
Closeable {
    @NotNull
    protected final PersistentEnumeratorBase<Data> myEnumerator;

    public PersistentEnumeratorDelegate(@NotNull File file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize) throws IOException {
        if (file2 == null) {
            PersistentEnumeratorDelegate.$$$reportNull$$$0(0);
        }
        if (dataDescriptor == null) {
            PersistentEnumeratorDelegate.$$$reportNull$$$0(1);
        }
        this(file2, dataDescriptor, initialSize, null);
    }

    public PersistentEnumeratorDelegate(@NotNull File file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext) throws IOException {
        if (file2 == null) {
            PersistentEnumeratorDelegate.$$$reportNull$$$0(2);
        }
        if (dataDescriptor == null) {
            PersistentEnumeratorDelegate.$$$reportNull$$$0(3);
        }
        this.myEnumerator = PersistentEnumeratorDelegate.useBtree() ? new PersistentBTreeEnumerator<Data>(file2, dataDescriptor, initialSize, lockContext) : new PersistentEnumerator<Data>(file2, dataDescriptor, initialSize);
    }

    public PersistentEnumeratorDelegate(@NotNull File file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext, int version) throws IOException {
        if (file2 == null) {
            PersistentEnumeratorDelegate.$$$reportNull$$$0(4);
        }
        if (dataDescriptor == null) {
            PersistentEnumeratorDelegate.$$$reportNull$$$0(5);
        }
        this.myEnumerator = PersistentEnumeratorDelegate.useBtree() ? new PersistentBTreeEnumerator<Data>(file2, dataDescriptor, initialSize, lockContext, version) : new PersistentEnumerator<Data>(file2, dataDescriptor, initialSize, null, version);
    }

    static boolean useBtree() {
        String property2 = System.getProperty("idea.use.btree");
        return !"false".equals(property2);
    }

    @Override
    public void close() throws IOException {
        PersistentEnumeratorBase<Data> enumerator = this.myEnumerator;
        if (enumerator != null) {
            enumerator.close();
        }
    }

    public boolean isClosed() {
        return this.myEnumerator.isClosed();
    }

    public boolean isDirty() {
        return this.myEnumerator.isDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markDirty() throws IOException {
        PersistentEnumeratorBase<Data> persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.myEnumerator.markDirty(true);
        }
    }

    public boolean isCorrupted() {
        return this.myEnumerator.isCorrupted();
    }

    public void markCorrupted() {
        this.myEnumerator.markCorrupted();
    }

    public void force() {
        this.myEnumerator.force();
    }

    @Override
    public Data valueOf(int id) throws IOException {
        return this.myEnumerator.valueOf(id);
    }

    @Override
    public int enumerate(Data name) throws IOException {
        return this.myEnumerator.enumerate(name);
    }

    public int tryEnumerate(Data name) throws IOException {
        return this.myEnumerator.tryEnumerate(name);
    }

    public boolean traverseAllRecords(PersistentEnumeratorBase.RecordsProcessor recordsProcessor) throws IOException {
        return this.myEnumerator.traverseAllRecords(recordsProcessor);
    }

    public Collection<Data> getAllDataObjects(@Nullable PersistentEnumeratorBase.DataFilter filter2) throws IOException {
        return this.myEnumerator.getAllDataObjects(filter2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "dataDescriptor";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/io/PersistentEnumeratorDelegate";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

