/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.Collection;
import java.util.List;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0002H\u0001\u001a\f\u0010\u0014\u001a\u00020\u0013*\u00020\u0002H\u0000\u001a\u0014\u0010\u0015\u001a\u00020\t*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\"\u0018\u0010\b\u001a\u00020\t*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0018\u0010\f\u001a\u00020\t*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\"\u0018\u0010\u000e\u001a\u00020\t*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\"\u0018\u0010\u0010\u001a\u00020\t*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0018"}, d2={"allSignedLiteralTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getAllSignedLiteralTypes", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Ljava/util/Collection;", "allUnsignedLiteralTypes", "getAllUnsignedLiteralTypes", "uByteType", "Lorg/jetbrains/kotlin/types/SimpleType;", "getUByteType", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/types/SimpleType;", "uIntType", "getUIntType", "uLongType", "getULongType", "uShortType", "getUShortType", "maxValue", "", "minValue", "unsignedType", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "descriptors"})
public final class PrimitiveTypeUtilKt {
    public static final long minValue(@NotNull KotlinType $this$minValue) {
        long l;
        Intrinsics.checkNotNullParameter($this$minValue, "$this$minValue");
        if (UnsignedTypes.isUnsignedType($this$minValue)) {
            return 0L;
        }
        if (KotlinBuiltIns.isByte($this$minValue)) {
            l = -128;
        } else if (KotlinBuiltIns.isShort($this$minValue)) {
            l = Short.MIN_VALUE;
        } else if (KotlinBuiltIns.isInt($this$minValue)) {
            l = Integer.MIN_VALUE;
        } else {
            String string2 = "Can't get min value for type: " + $this$minValue;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return l;
    }

    @ExperimentalUnsignedTypes
    public static final long maxValue(@NotNull KotlinType $this$maxValue) {
        long l;
        Intrinsics.checkNotNullParameter($this$maxValue, "$this$maxValue");
        if (KotlinBuiltIns.isByte($this$maxValue)) {
            l = 127;
        } else if (KotlinBuiltIns.isShort($this$maxValue)) {
            l = Short.MAX_VALUE;
        } else if (KotlinBuiltIns.isInt($this$maxValue)) {
            l = Integer.MAX_VALUE;
        } else if (KotlinBuiltIns.isUByte($this$maxValue)) {
            int n = -1;
            boolean bl = false;
            l = (long)n & 0xFFL;
        } else if (KotlinBuiltIns.isUShort($this$maxValue)) {
            int n = -1;
            boolean bl = false;
            l = (long)n & 0xFFFFL;
        } else if (KotlinBuiltIns.isUInt($this$maxValue)) {
            int n = -1;
            boolean bl = false;
            l = (long)n & 0xFFFFFFFFL;
        } else {
            String string2 = "Can't get max value for type: " + $this$maxValue;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return l;
    }

    @NotNull
    public static final SimpleType unsignedType(@NotNull ModuleDescriptor $this$unsignedType, @NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter($this$unsignedType, "$this$unsignedType");
        Intrinsics.checkNotNullParameter(classId, "classId");
        ClassDescriptor classDescriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies($this$unsignedType, classId);
        Intrinsics.checkNotNull(classDescriptor2);
        SimpleType simpleType2 = classDescriptor2.getDefaultType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "findClassAcrossModuleDep\u2026es(classId)!!.defaultType");
        return simpleType2;
    }

    @NotNull
    public static final SimpleType getUIntType(@NotNull ModuleDescriptor $this$uIntType) {
        Intrinsics.checkNotNullParameter($this$uIntType, "$this$uIntType");
        ClassId classId = KotlinBuiltIns.FQ_NAMES.uInt;
        Intrinsics.checkNotNullExpressionValue(classId, "KotlinBuiltIns.FQ_NAMES.uInt");
        return PrimitiveTypeUtilKt.unsignedType($this$uIntType, classId);
    }

    @NotNull
    public static final SimpleType getULongType(@NotNull ModuleDescriptor $this$uLongType) {
        Intrinsics.checkNotNullParameter($this$uLongType, "$this$uLongType");
        ClassId classId = KotlinBuiltIns.FQ_NAMES.uLong;
        Intrinsics.checkNotNullExpressionValue(classId, "KotlinBuiltIns.FQ_NAMES.uLong");
        return PrimitiveTypeUtilKt.unsignedType($this$uLongType, classId);
    }

    @NotNull
    public static final SimpleType getUByteType(@NotNull ModuleDescriptor $this$uByteType) {
        Intrinsics.checkNotNullParameter($this$uByteType, "$this$uByteType");
        ClassId classId = KotlinBuiltIns.FQ_NAMES.uByte;
        Intrinsics.checkNotNullExpressionValue(classId, "KotlinBuiltIns.FQ_NAMES.uByte");
        return PrimitiveTypeUtilKt.unsignedType($this$uByteType, classId);
    }

    @NotNull
    public static final SimpleType getUShortType(@NotNull ModuleDescriptor $this$uShortType) {
        Intrinsics.checkNotNullParameter($this$uShortType, "$this$uShortType");
        ClassId classId = KotlinBuiltIns.FQ_NAMES.uShort;
        Intrinsics.checkNotNullExpressionValue(classId, "KotlinBuiltIns.FQ_NAMES.uShort");
        return PrimitiveTypeUtilKt.unsignedType($this$uShortType, classId);
    }

    @NotNull
    public static final Collection<KotlinType> getAllSignedLiteralTypes(@NotNull ModuleDescriptor $this$allSignedLiteralTypes) {
        Intrinsics.checkNotNullParameter($this$allSignedLiteralTypes, "$this$allSignedLiteralTypes");
        return CollectionsKt.listOf($this$allSignedLiteralTypes.getBuiltIns().getIntType(), $this$allSignedLiteralTypes.getBuiltIns().getLongType(), $this$allSignedLiteralTypes.getBuiltIns().getByteType(), $this$allSignedLiteralTypes.getBuiltIns().getShortType());
    }

    @NotNull
    public static final Collection<KotlinType> getAllUnsignedLiteralTypes(@NotNull ModuleDescriptor $this$allUnsignedLiteralTypes) {
        List<Object> list2;
        Intrinsics.checkNotNullParameter($this$allUnsignedLiteralTypes, "$this$allUnsignedLiteralTypes");
        if (CompileTimeConstantKt.hasUnsignedTypesInModuleDependencies($this$allUnsignedLiteralTypes)) {
            SimpleType[] simpleTypeArray = new SimpleType[4];
            ClassId classId = KotlinBuiltIns.FQ_NAMES.uInt;
            Intrinsics.checkNotNullExpressionValue(classId, "KotlinBuiltIns.FQ_NAMES.uInt");
            simpleTypeArray[0] = PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, classId);
            ClassId classId2 = KotlinBuiltIns.FQ_NAMES.uLong;
            Intrinsics.checkNotNullExpressionValue(classId2, "KotlinBuiltIns.FQ_NAMES.uLong");
            simpleTypeArray[1] = PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, classId2);
            ClassId classId3 = KotlinBuiltIns.FQ_NAMES.uByte;
            Intrinsics.checkNotNullExpressionValue(classId3, "KotlinBuiltIns.FQ_NAMES.uByte");
            simpleTypeArray[2] = PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, classId3);
            ClassId classId4 = KotlinBuiltIns.FQ_NAMES.uShort;
            Intrinsics.checkNotNullExpressionValue(classId4, "KotlinBuiltIns.FQ_NAMES.uShort");
            simpleTypeArray[3] = PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, classId4);
            list2 = CollectionsKt.listOf(simpleTypeArray);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }
}

