# -*- coding: utf-8 -*-
info = {
    "name": "th",
    "date_order": "DMY",
    "january": [
        "มกราคม",
        "มค",
        "เดือนมกราคม",
        "มกรา"
    ],
    "february": [
        "กุมภาพันธ์",
        "กพ",
        "เดือนกุมภาพันธ์",
        "กุมภา"
    ],
    "march": [
        "มีนาคม",
        "มีค",
        "เดือนมีนาคม",
        "มีนา"
    ],
    "april": [
        "เมษายน",
        "เมย",
        "เมษา",
        "เดือนเมษายน"
    ],
    "may": [
        "พฤษภาคม",
        "พค",
        "เดือนพฤษภาคม",
        "พฤษภา"
    ],
    "june": [
        "มิถุนายน",
        "มิย",
        "เดือนมิถุนายน",
        "มิถุนา"
    ],
    "july": [
        "กรกฎาคม",
        "กค",
        "เดือนกรกฏาคม",
        "กรกฎา"
    ],
    "august": [
        "สิงหาคม",
        "สค",
        "สิงหา",
        "เดือนสิงหาคม"
    ],
    "september": [
        "กันยายน",
        "กย",
        "กันยา",
        "เดือนกันยายน"
    ],
    "october": [
        "ตุลาคม",
        "ตค",
        "เดือนตุลาคม",
        "ตุลา"
    ],
    "november": [
        "พฤศจิกายน",
        "พย",
        "เดือนพฤศจิกายน",
        "พฤศจิ"
    ],
    "december": [
        "ธันวาคม",
        "ธค",
        "เดือนธันวาคม",
        "ธันวา"
    ],
    "monday": [
        "วันจันทร์",
        "จ",
        "จันทร์",
        "วันจันทร์ที่"
    ],
    "tuesday": [
        "วันอังคาร",
        "อ",
        "อังคาร",
        "วันอังคารที่"
    ],
    "wednesday": [
        "วันพุธ",
        "พ",
        "พุธ",
        "วันพุธที่"
    ],
    "thursday": [
        "วันพฤหัสบดี",
        "พฤ",
        "พฤหัสบดี",
        "พฤหัส",
        "วันพฤหัสบดีที่"
    ],
    "friday": [
        "วันศุกร์",
        "ศ",
        "ศุกร์",
        "วันศุกร์ที่"
    ],
    "saturday": [
        "วันเสาร์",
        "ส",
        "เสาร์",
        "วันเสาร์ที่"
    ],
    "sunday": [
        "วันอาทิตย์",
        "อา",
        "อาทิตย์",
        "วันอาทิตย์ที่"
    ],
    "am": [
        "ก่อนเที่ยง"
    ],
    "pm": [
        "หลังเที่ยง"
    ],
    "year": [
        "ปี"
    ],
    "month": [
        "เดือน"
    ],
    "week": [
        "สัปดาห์"
    ],
    "day": [
        "วัน"
    ],
    "hour": [
        "ชั่วโมง",
        "ชม"
    ],
    "minute": [
        "นาที",
        "น"
    ],
    "second": [
        "วินาที",
        "วิ"
    ],
    "relative-type": {
        "1 year ago": [
            "ปีที่แล้ว"
        ],
        "0 year ago": [
            "ปีนี้"
        ],
        "in 1 year": [
            "ปีหน้า"
        ],
        "1 month ago": [
            "เดือนที่แล้ว"
        ],
        "0 month ago": [
            "เดือนนี้"
        ],
        "in 1 month": [
            "เดือนหน้า"
        ],
        "1 week ago": [
            "สัปดาห์ที่แล้ว"
        ],
        "0 week ago": [
            "สัปดาห์นี้"
        ],
        "in 1 week": [
            "สัปดาห์หน้า"
        ],
        "1 day ago": [
            "เมื่อวาน"
        ],
        "0 day ago": [
            "วันนี้"
        ],
        "in 1 day": [
            "พรุ่งนี้"
        ],
        "0 hour ago": [
            "ชั่วโมงนี้"
        ],
        "0 minute ago": [
            "นาทีนี้"
        ],
        "0 second ago": [
            "ขณะนี้"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "ในอีก (\\d+) ปี",
            "ใน (\\d+) ปี"
        ],
        "\\1 year ago": [
            "(\\d+) ปีที่แล้ว"
        ],
        "in \\1 month": [
            "ในอีก (\\d+) เดือน",
            "ใน (\\d+) เดือน"
        ],
        "\\1 month ago": [
            "(\\d+) เดือนที่ผ่านมา",
            "(\\d+) เดือนที่แล้ว"
        ],
        "in \\1 week": [
            "ในอีก (\\d+) สัปดาห์",
            "ใน (\\d+) สัปดาห์"
        ],
        "\\1 week ago": [
            "(\\d+) สัปดาห์ที่ผ่านมา",
            "(\\d+) สัปดาห์ที่แล้ว"
        ],
        "in \\1 day": [
            "ในอีก (\\d+) วัน",
            "ใน (\\d+) วัน"
        ],
        "\\1 day ago": [
            "(\\d+) วันที่ผ่านมา",
            "(\\d+) วันที่แล้ว"
        ],
        "in \\1 hour": [
            "ในอีก (\\d+) ชั่วโมง",
            "ใน (\\d+) ชม"
        ],
        "\\1 hour ago": [
            "(\\d+) ชั่วโมงที่ผ่านมา",
            "(\\d+) ชม ที่แล้ว"
        ],
        "in \\1 minute": [
            "ในอีก (\\d+) นาที",
            "ใน (\\d+) นาที"
        ],
        "\\1 minute ago": [
            "(\\d+) นาทีที่ผ่านมา",
            "(\\d+) นาทีที่แล้ว"
        ],
        "in \\1 second": [
            "ในอีก (\\d+) วินาที",
            "ใน (\\d+) วินาที"
        ],
        "\\1 second ago": [
            "(\\d+) วินาทีที่ผ่านมา",
            "(\\d+) วินาทีที่แล้ว"
        ]
    },
    "locale_specific": {},
    "sentence_splitter_group": 5,
    "skip": [
        "เวลา",
        "น.",
        "เมื่อ ",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "ago": [
        "แต่ก่อน",
        "มาแล้ว",
        "ก่อน"
    ],
    "in": [
        "ใน"
    ],
    "simplifications": [
        {
            "วันนี้": "0 วัน"
        },
        {
            "เมื่อวานนี้": "1 วัน"
        },
        {
            "1 วันที่แล้ว": "1 วัน"
        },
        {
            "เมื่อวานซืน": "2 วัน"
        },
        {
            "2 วันที่แล้ว": "2 วัน"
        },
        {
            "เมื่อสักครู่นี้": "0 วินาที"
        }
    ]
}
