/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.InboundSemiGraph;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CachingSemiGraph<Node>
implements InboundSemiGraph<Node> {
    private final Set<Node> myNodes;
    private final Map<Node, List<Node>> myIn;

    public static <T> InboundSemiGraph<T> cache(InboundSemiGraph<T> original) {
        return new CachingSemiGraph<T>(original);
    }

    private CachingSemiGraph(InboundSemiGraph<Node> original) {
        this.myNodes = new LinkedHashSet<Node>(original.getNodes());
        this.myIn = new THashMap();
        for (Node node : this.myNodes) {
            Iterator<Node> inIterator = original.getIn(node);
            if (!inIterator.hasNext()) continue;
            ArrayList value2 = new ArrayList();
            ContainerUtil.addAll(value2, inIterator);
            this.myIn.put(node, value2);
        }
    }

    @Override
    @NotNull
    public Collection<Node> getNodes() {
        Set<Node> set = this.myNodes;
        if (set == null) {
            CachingSemiGraph.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    public Iterator<Node> getIn(Node n) {
        List<Node> inNodes = this.myIn.get(n);
        Iterator<Object> iterator2 = inNodes != null ? inNodes.iterator() : Collections.emptyIterator();
        if (iterator2 == null) {
            CachingSemiGraph.$$$reportNull$$$0(1);
        }
        return iterator2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/graph/CachingSemiGraph";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIn";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

