/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/codegen/intrinsics/UnsignedIntrinsic;", "Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethod;", "targetDescriptor", "", "(Ljava/lang/String;)V", "isApplicableToOverload", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "backend"})
public abstract class UnsignedIntrinsic
extends IntrinsicMethod {
    private final String targetDescriptor;

    @Override
    public boolean isApplicableToOverload(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor) {
            return true;
        }
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "descriptor.valueParameters");
        ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.singleOrNull(list2);
        if (valueParameterDescriptor == null) {
            return true;
        }
        ValueParameterDescriptor valueParameter = valueParameterDescriptor;
        ClassifierDescriptor classifierDescriptor = valueParameter.getType().getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected descriptor for unsigned intrinsic: " + descriptor2)));
        }
        Intrinsics.checkNotNullExpressionValue(classifierDescriptor, "valueParameter.type.cons\u2026 intrinsic: $descriptor\")");
        ClassifierDescriptor singleValueParameterTypeDescriptor = classifierDescriptor;
        return Intrinsics.areEqual(singleValueParameterTypeDescriptor.getName().asString(), this.targetDescriptor);
    }

    public UnsignedIntrinsic(@NotNull String targetDescriptor) {
        Intrinsics.checkNotNullParameter(targetDescriptor, "targetDescriptor");
        this.targetDescriptor = targetDescriptor;
    }
}

