"""
Internal datagram codes used in ICC level 2. unit format
see https://www.chessclub.com/user/resources/formats/formats.txt

This is somewhat similar to fics block mode. The main difference is fics
block mode works 'all or nothing' meaning when you switch to use it
all commands you send and resposes you get have to (or will) use it.
ICC datagram format are used for responses only and is more forgiving.
You can set it for individual responses one by one or for all at once
at login time.
"""

MY_ICC_PREFIX = "#"

UNIT_START = chr(25) + '['
UNIT_END = chr(25) + ']'
B_UNIT_END = b'\x19]'

DTGR_START = chr(25) + '('
DTGR_END = chr(25) + ')'
B_DTGR_END = b'\x19)'

DG_WHO_AM_I = 0
DG_PLAYER_ARRIVED = 1
DG_PLAYER_LEFT = 2
DG_BULLET = 3
DG_BLITZ = 4
DG_STANDARD = 5
DG_WILD = 6
DG_BUGHOUSE = 7
DG_TIMESTAMP = 8
DG_TITLES = 9
DG_OPEN = 10
DG_STATE = 11
DG_GAME_STARTED = 12
DG_GAME_RESULT = 13
DG_EXAMINED_GAME_IS_GONE = 14
DG_MY_GAME_STARTED = 15
DG_MY_GAME_RESULT = 16
DG_MY_GAME_ENDED = 17
DG_STARTED_OBSERVING = 18
DG_STOP_OBSERVING = 19
DG_PLAYERS_IN_MY_GAME = 20
DG_OFFERS_IN_MY_GAME = 21
DG_TAKEBACK = 22
DG_BACKWARD = 23
DG_SEND_MOVES = 24
DG_MOVE_LIST = 25
DG_KIBITZ = 26
DG_PEOPLE_IN_MY_CHANNEL = 27
DG_CHANNEL_TELL = 28
DG_MATCH = 29
DG_MATCH_REMOVED = 30
DG_PERSONAL_TELL = 31
DG_SHOUT = 32
DG_MOVE_ALGEBRAIC = 33
DG_MOVE_SMITH = 34
DG_MOVE_TIME = 35
DG_MOVE_CLOCK = 36
DG_BUGHOUSE_HOLDINGS = 37
DG_SET_CLOCK = 38
DG_FLIP = 39
DG_ISOLATED_BOARD = 40
DG_REFRESH = 41
DG_ILLEGAL_MOVE = 42
DG_MY_RELATION_TO_GAME = 43
DG_PARTNERSHIP = 44
DG_SEES_SHOUTS = 45
DG_CHANNELS_SHARED = 46
DG_MY_VARIABLE = 47
DG_MY_STRING_VARIABLE = 48
DG_JBOARD = 49
DG_SEEK = 50
DG_SEEK_REMOVED = 51
DG_MY_RATING = 52
DG_SOUND = 53
DG_PLAYER_ARRIVED_SIMPLE = 55
DG_MSEC = 56
DG_BUGHOUSE_PASS = 57
DG_IP = 58
DG_CIRCLE = 59
DG_ARROW = 60
DG_MORETIME = 61
DG_PERSONAL_TELL_ECHO = 62
DG_SUGGESTION = 63
DG_NOTIFY_ARRIVED = 64
DG_NOTIFY_LEFT = 65
DG_NOTIFY_OPEN = 66
DG_NOTIFY_STATE = 67
DG_MY_NOTIFY_LIST = 68
DG_LOGIN_FAILED = 69
DG_FEN = 70
DG_TOURNEY_MATCH = 71
DG_GAMELIST_BEGIN = 72
DG_GAMELIST_ITEM = 73
DG_IDLE = 74
DG_ACK_PING = 75
DG_RATING_TYPE_KEY = 76
DG_GAME_MESSAGE = 77
DG_UNACCENTED = 78
DG_STRINGLIST_BEGIN = 79
DG_STRINGLIST_ITEM = 80
DG_DUMMY_RESPONSE = 81
DG_CHANNEL_QTELL = 82
DG_PERSONAL_QTELL = 83
DG_SET_BOARD = 84
DG_MATCH_ASSESSMENT = 85
DG_LOG_PGN = 86
DG_NEW_MY_RATING = 87
DG_LOSERS = 88
DG_UNCIRCLE = 89
DG_UNARROW = 90
DG_WSUGGEST = 91
DG_TEMPORARY_PASSWORD = 93
DG_MESSAGELIST_BEGIN = 94
DG_MESSAGELIST_ITEM = 95
DG_LIST = 96
DG_SJI_AD = 97
DG_RETRACT = 99
DG_MY_GAME_CHANGE = 100
DG_POSITION_BEGIN = 101
DG_TOURNEY = 103
DG_REMOVE_TOURNEY = 104
DG_DIALOG_START = 105
DG_DIALOG_DATA = 106
DG_DIALOG_DEFAULT = 107
DG_DIALOG_END = 108
DG_DIALOG_RELEASE = 109
DG_POSITION_BEGIN2 = 110
DG_PAST_MOVE = 111
DG_PGN_TAG = 112
DG_IS_VARIATION = 113
DG_PASSWORD = 114
DG_WILD_KEY = 116
DG_SWITCH_SERVERS = 120
DG_CRAZYHOUSE = 121
DG_SET2 = 124
DG_FIVEMINUTE = 125
DG_ONEMINUTE = 126
DG_TRANSLATIONOKAY = 129
DG_UID = 131
DG_KNOWS_FISCHER_RANDOM = 132
DG_COMMAND = 136
DG_TOURNEY_GAME_STARTED = 137
DG_TOURNEY_GAME_ENDED = 138
DG_MY_TURN = 139
DG_CORRESPONDENCE_RATING = 140
DG_DISABLE_PREMOVE = 141
DG_PSTAT = 142
DG_BOARDINFO = 143
DG_MOVE_LAG = 144
DG_FIFTEENMINUTE = 145
DG_PHRASELIST_UPDATE = 146
DG_PHRASELIST_ITEM = 147
DG_MENU_SPEAK = 148
DG_THREEMINUTE = 149
DG_FORTYFIVEMINUTE = 150
DG_CHESS960 = 151

SCN_UNKNOWN = 0
SCN_ILLEGAL_MOVE = 1
SCN_MOVE = 2
SCN_EDIT_EXAMINED = 3
SCN_PING_RESPONSE = 10
SCN_WEIRD = 11
SCN_REALLY_LOG_IN = 12
SCN_MOED = 13
SCN_EVENTS = 14
SCN_NEWS = 15
SCN_LOGOUT = 16
SCN_TIMEOUT = 17
SCN_CONNECT = 18
SCN_REALLY_QUIT = 19
SCN_LOGIN = 20
SCN_PASSWORD = 21
SCN_REGISTRATION = 22
SCN_EXTENSION = 23
SCN_AUTHENTICATION = 24
SCN_BAD = 25
SCN_AUTOMATIC = 26
SCN_CONFIRM = 27
SCN_MULTI_DISCARD = 28
SCN_IDLE = 29
SCN_ACK_PING = 30
SCN_MISCELLANEOUS = 31

CN_TELL = 101
CN_I = 102
CN_SHOUT = 103
CN_SHOUT0 = 104
CN_SLASH = 105
CN_WHO = 106
CN_SET = 107
CN_FLAG = 108
CN_SAY = 109
CN_CHANNELTELL = 110
CN_SSHOUT = 111
CN_BAD = 112
CN_KIBITZ = 113
CN_WHISPER = 114
CN_EXAMINE = 115
CN_MEXAMINE = 116
CN_COPYGAME0 = 117
CN_COPYGAME = 118
CN_FORWARD = 119
CN_BACK = 120
CN_MATCH = 121
CN_MATCH0 = 122
CN_ACCEPT = 123
CN_HELP0 = 124
CN_HELP = 125
CN_MORE = 126
CN_NEWS = 127
CN_NEWS0 = 128
CN_HISTORY = 129
CN_FINGER = 130
CN_VARS = 131
CN_UPSTATISTICS = 132
CN_UNEXAMINE = 133
CN_ADJOURN = 134
CN_ASSESS = 135
CN_OBSERVE0 = 136
CN_OBSERVE = 137
CN_FOLLOW0 = 138
CN_FOLLOW = 139
CN_ECO = 140
CN_STYLE = 141
CN_BELL = 142
CN_OPEN = 143
CN_DECLINE = 144
CN_REFRESH = 145
CN_RESIGNADJ = 146
CN_REVERT = 147
CN_RATED = 148
CN_RANK = 149
CN_MOVES = 150
CN_MAILOLDMOVES = 151
CN_MAILSTORED = 152
CN_MAILHELP = 153
CN_PENDING = 154
CN_GAMES = 155
CN_ABORT = 156
CN_ALLOBSERVERS = 157
CN_INCHANNEL = 158
CN_INFO = 159
CN_MORETIME = 160
CN_BEST = 161
CN_QUIT = 162
CN_QUOTA = 163
CN_LLOGONS = 164
CN_LHISTORY = 165
CN_LOGONS = 166
CN_TIME = 167
CN_TAKEBACK = 168
CN_SEARCH = 169
CN_SEARCH0 = 170
CN_SMOVES = 171
CN_SPOSITION = 172
CN_PASSWORD = 173
CN_MESSAGE = 174
CN_MESSAGE0 = 175
CN_CLEARMESSAGES = 176
CN_DATE = 177
CN_LIST = 178
CN_PLUS = 179
CN_MINUS = 180
CN_ZNOTL = 181
CN_FLIP = 182
CN_PROMOTE = 183
CN_EXPUNGE = 184
CN_IWCMATCH = 185
CN_LIMITS = 186
CN_PING = 187
CN_EXTEND = 188
CN_QTELL = 189
CN_GETPI = 190
CN_STARTSIMUL = 191
CN_GOTO = 192
CN_SETCLOCK = 193
CN_LIBLIST = 194
CN_LIBSAVE = 195
CN_LIBDELETE = 196
CN_LIBANNOTATE = 197
CN_LIBKEEPEXAM = 198
CN_PARTNER = 199
CN_PARTNER0 = 200
CN_PTELL = 201
CN_BUGWHO = 202
CN_WILDRANK = 204
CN_XOBSERVE = 205
CN_PRIMARY = 206
CN_DRAW = 207
CN_RESIGN = 208
CN_STATISTICS = 209
CN_STORED = 210
CN_CHANNELQTELL = 211
CN_XPARTNER = 212
CN_YFINGER = 213
CN_SEEKING = 214
CN_SOUGHT = 215
CN_SET2 = 216
CN_PLAY = 217
CN_UNSEEKING = 218
CN_AWAY = 219
CN_LAGSTATS = 220
CN_COMMANDS = 221
CN_REMATCH = 222
CN_REGISTER = 223
CN_RESUME = 224
CN_CIRCLE = 225
CN_ARROW = 226
CN_BLANKING = 227
CN_RELAY = 228
CN_LOADGAME = 229
CN_DRAWADJ = 230
CN_ABORTADJ = 231
CN_MAILNEWS = 232
CN_QSET = 233
CN_CC_START = 234
CN_CC_LIST = 235
CN_CC_MOVE = 236
CN_CC_DELETE = 237
CN_CC_QSTART = 238
CN_CC_QLIST = 239
CN_CC_QLABEL = 240
CN_CC_QDELETE = 241
CN_CC_QADJUDICATE = 242
CN_CC_ASK_DIRECTOR = 243
CN_LOADFEN = 244
CN_GETPX = 245
CN_UNRELAYED = 246
CN_NORELAY = 247
CN_REFER = 248
CN_PGN = 249
CN_SPGN = 250
CN_QFOLLOW = 251
CN_QUNFOLLOW = 252
CN_QMATCH = 253
CN_QPARTNER = 254
CN_ISREGNAME = 255
CN_REQUIRETICKET = 256
CN_ANNOTATE = 257
CN_CLEARBOARD = 258
CN_REQUEST_WIN = 259
CN_REQUEST_DRAW = 260
CN_REQUEST_ABORT = 261
CN_LOGPGN = 262
CN_RESULT = 263
CN_FEN = 264
CN_SFEN = 265
CN_SETGAMEPARAM = 266
CN_TAG = 267
CN_TOMOVE = 268
CN_REGENTRY = 269
CN_PERSONALINFO = 270
CN_EVENTS = 271
CN_QADDEVENT = 272
CN_GLISTGROUPS = 273
CN_GLISTMEMBERS = 274
CN_GINVITE = 275
CN_GJOIN = 276
CN_GLISTINVITED = 277
CN_GLISTJOINING = 278
CN_GDESCRIBE = 279
CN_GKICK = 280
CN_GBEST = 281
CN_SIMULIZE = 282
CN_GAMEID = 283
CN_THREEMIN = 92
CN_FIVEMINUTE = 284
CN_QIMPART = 285
CN_GMESSAGE = 286
CN_COMPLAIN = 287
CN_LASTTELLS = 288
CN_VIEW = 289
CN_SHOWADMIN = 290
CN_PSTAT = 291
CN_BOARDINFO = 292
