/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.nio.channels.SelectionKey;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ErrorState;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalNioInputBuffer;
import org.apache.coyote.http11.InternalNioOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.net.SendfileKeepAliveState;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11NioProcessor
extends AbstractHttp11Processor<NioChannel> {
    private static final Log log = LogFactory.getLog(Http11NioProcessor.class);
    protected SSLSupport sslSupport;
    protected InternalNioInputBuffer inputBuffer = null;
    protected InternalNioOutputBuffer outputBuffer = null;
    protected NioEndpoint.SendfileData sendfileData = null;

    @Override
    protected Log getLog() {
        return log;
    }

    public Http11NioProcessor(int n, boolean bl, NioEndpoint nioEndpoint, int n2, Set<String> set, int n3, int n4, String string, String string2) {
        super(nioEndpoint);
        this.httpParser = new HttpParser(string, string2);
        this.inputBuffer = new InternalNioInputBuffer(this.request, n, bl, this.httpParser);
        this.request.setInputBuffer(this.inputBuffer);
        this.outputBuffer = new InternalNioOutputBuffer(this.response, n);
        this.response.setOutputBuffer(this.outputBuffer);
        this.initializeFilters(n2, set, n3, n4);
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus socketStatus) throws IOException {
        long l = this.endpoint.getSoTimeout();
        RequestInfo requestInfo = this.request.getRequestProcessor();
        NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)((NioChannel)this.socketWrapper.getSocket()).getAttachment();
        try {
            requestInfo.setStage(3);
            if (!this.getAdapter().event(this.request, this.response, socketStatus)) {
                this.setErrorState(ErrorState.CLOSE_NOW, null);
            }
            if (!this.getErrorState().isError() && keyAttachment != null) {
                keyAttachment.setComet(this.comet);
                if (this.comet) {
                    Integer n = (Integer)this.request.getAttribute("org.apache.tomcat.comet.timeout");
                    if (n != null) {
                        keyAttachment.setTimeout(n.longValue());
                    }
                } else if (this.keepAlive) {
                    keyAttachment.setTimeout(this.keepAliveTimeout);
                } else {
                    keyAttachment.setTimeout(l);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            this.setErrorState(ErrorState.CLOSE_NOW, interruptedIOException);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            this.response.setStatus(500);
            this.setErrorState(ErrorState.CLOSE_NOW, throwable);
            log.error((Object)sm.getString("http11processor.request.process"), throwable);
            this.getAdapter().log(this.request, this.response, 0L);
        }
        requestInfo.setStage(7);
        if (this.getErrorState().isError() || socketStatus == SocketStatus.STOP) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (!this.comet) {
            if (this.keepAlive) {
                this.inputBuffer.nextRequest();
                this.outputBuffer.nextRequest();
                return AbstractEndpoint.Handler.SocketState.OPEN;
            }
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.LONG;
    }

    @Override
    protected void resetTimeouts() {
        NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)((NioChannel)this.socketWrapper.getSocket()).getAttachment();
        if (!this.getErrorState().isError() && keyAttachment != null && this.asyncStateMachine.isAsyncDispatching()) {
            long l = this.endpoint.getSoTimeout();
            if (this.keepAlive) {
                keyAttachment.setTimeout(this.keepAliveTimeout);
            } else {
                keyAttachment.setTimeout(l);
            }
        }
    }

    @Override
    protected boolean disableKeepAlive() {
        return false;
    }

    @Override
    protected void setRequestLineReadTimeout() throws IOException {
    }

    @Override
    protected boolean handleIncompleteRequestLineRead() {
        this.openSocket = true;
        if (this.inputBuffer.getParsingRequestLinePhase() < 2) {
            if (this.socketWrapper.getLastAccess() > -1L || this.keptAlive) {
                this.socketWrapper.setTimeout(this.endpoint.getKeepAliveTimeout());
            }
        } else {
            if (this.endpoint.isPaused()) {
                this.response.setStatus(503);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                this.getAdapter().log(this.request, this.response, 0L);
                return false;
            }
            this.readComplete = false;
            this.socketWrapper.setTimeout(this.endpoint.getSoTimeout());
        }
        return true;
    }

    @Override
    protected void setSocketTimeout(int n) throws IOException {
        ((NioChannel)this.socketWrapper.getSocket()).getIOChannel().socket().setSoTimeout(n);
    }

    @Override
    protected void setCometTimeouts(SocketWrapper<NioChannel> socketWrapper) {
        NioEndpoint.KeyAttachment keyAttachment;
        SelectionKey selectionKey = socketWrapper.getSocket().getIOChannel().keyFor(socketWrapper.getSocket().getPoller().getSelector());
        if (selectionKey != null && (keyAttachment = (NioEndpoint.KeyAttachment)selectionKey.attachment()) != null) {
            Integer n;
            keyAttachment.setComet(this.comet);
            if (this.comet && (n = (Integer)this.request.getAttribute("org.apache.tomcat.comet.timeout")) != null) {
                keyAttachment.setTimeout(n.longValue());
            }
        }
    }

    @Override
    protected boolean breakKeepAliveLoop(SocketWrapper<NioChannel> socketWrapper) {
        this.openSocket = this.keepAlive;
        if (this.sendfileData != null && !this.getErrorState().isError()) {
            ((NioEndpoint.KeyAttachment)socketWrapper).setSendfileData(this.sendfileData);
            this.sendfileData.keepAliveState = this.keepAlive ? (this.getInputBuffer().available() == 0 ? SendfileKeepAliveState.OPEN : SendfileKeepAliveState.PIPELINED) : SendfileKeepAliveState.NONE;
            SelectionKey selectionKey = socketWrapper.getSocket().getIOChannel().keyFor(socketWrapper.getSocket().getPoller().getSelector());
            switch (socketWrapper.getSocket().getPoller().processSendfile(selectionKey, (NioEndpoint.KeyAttachment)socketWrapper, true)) {
                case DONE: {
                    this.sendfileData = null;
                    return false;
                }
                case PENDING: {
                    this.sendfileInProgress = true;
                    return true;
                }
                case ERROR: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("http11processor.sendfile.error"));
                    }
                    this.setErrorState(ErrorState.CLOSE_NOW, null);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void recycleInternal() {
        this.socketWrapper = null;
        this.sendfileData = null;
    }

    @Override
    public void actionInternal(ActionCode actionCode, Object object) {
        switch (actionCode) {
            case REQ_HOST_ADDR_ATTRIBUTE: {
                InetAddress inetAddress;
                if (this.remoteAddr == null && this.socketWrapper != null && (inetAddress = ((NioChannel)this.socketWrapper.getSocket()).getIOChannel().socket().getInetAddress()) != null) {
                    this.remoteAddr = inetAddress.getHostAddress();
                }
                this.request.remoteAddr().setString(this.remoteAddr);
                break;
            }
            case REQ_LOCAL_NAME_ATTRIBUTE: {
                InetAddress inetAddress;
                if (this.localName == null && this.socketWrapper != null && (inetAddress = ((NioChannel)this.socketWrapper.getSocket()).getIOChannel().socket().getLocalAddress()) != null) {
                    this.localName = inetAddress.getHostName();
                }
                this.request.localName().setString(this.localName);
                break;
            }
            case REQ_HOST_ATTRIBUTE: {
                if (this.remoteHost == null && this.socketWrapper != null) {
                    InetAddress inetAddress = ((NioChannel)this.socketWrapper.getSocket()).getIOChannel().socket().getInetAddress();
                    if (inetAddress != null) {
                        this.remoteHost = inetAddress.getHostName();
                    }
                    if (this.remoteHost == null) {
                        if (this.remoteAddr != null) {
                            this.remoteHost = this.remoteAddr;
                        } else {
                            this.request.remoteHost().recycle();
                        }
                    }
                }
                this.request.remoteHost().setString(this.remoteHost);
                break;
            }
            case REQ_LOCAL_ADDR_ATTRIBUTE: {
                if (this.localAddr == null) {
                    this.localAddr = ((NioChannel)this.socketWrapper.getSocket()).getIOChannel().socket().getLocalAddress().getHostAddress();
                }
                this.request.localAddr().setString(this.localAddr);
                break;
            }
            case REQ_REMOTEPORT_ATTRIBUTE: {
                if (this.remotePort == -1 && this.socketWrapper != null) {
                    this.remotePort = ((NioChannel)this.socketWrapper.getSocket()).getIOChannel().socket().getPort();
                }
                this.request.setRemotePort(this.remotePort);
                break;
            }
            case REQ_LOCALPORT_ATTRIBUTE: {
                if (this.localPort == -1 && this.socketWrapper != null) {
                    this.localPort = ((NioChannel)this.socketWrapper.getSocket()).getIOChannel().socket().getLocalPort();
                }
                this.request.setLocalPort(this.localPort);
                break;
            }
            case REQ_SSL_ATTRIBUTE: {
                try {
                    if (this.sslSupport == null) break;
                    Object object2 = this.sslSupport.getCipherSuite();
                    if (object2 != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", object2);
                    }
                    if ((object2 = this.sslSupport.getPeerCertificateChain(false)) != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", object2);
                    }
                    if ((object2 = this.sslSupport.getKeySize()) != null) {
                        this.request.setAttribute("javax.servlet.request.key_size", object2);
                    }
                    if ((object2 = this.sslSupport.getSessionId()) != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session_id", object2);
                    }
                    if ((object2 = this.sslSupport.getProtocol()) != null) {
                        this.request.setAttribute("org.apache.tomcat.util.net.secure_protocol_version", object2);
                    }
                    this.request.setAttribute("javax.servlet.request.ssl_session_mgr", this.sslSupport);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)exception);
                }
                break;
            }
            case REQ_SSL_CERTIFICATE: {
                if (this.sslSupport == null) break;
                InputFilter[] inputFilterArray = this.inputBuffer.getFilters();
                ((BufferedInputFilter)inputFilterArray[3]).setLimit(this.maxSavePostSize);
                this.inputBuffer.addActiveFilter(inputFilterArray[3]);
                SecureNioChannel secureNioChannel = (SecureNioChannel)this.socketWrapper.getSocket();
                SSLEngine sSLEngine = secureNioChannel.getSslEngine();
                if (!sSLEngine.getNeedClientAuth()) {
                    sSLEngine.setNeedClientAuth(true);
                    try {
                        secureNioChannel.rehandshake(this.endpoint.getSoTimeout());
                        this.sslSupport = ((NioEndpoint)this.endpoint).getHandler().getSslImplementation().getSSLSupport(sSLEngine.getSession());
                    }
                    catch (IOException iOException) {
                        log.warn((Object)sm.getString("http11processor.socket.sslreneg", new Object[]{iOException}));
                    }
                }
                try {
                    Object[] objectArray = this.sslSupport.getPeerCertificateChain(false);
                    if (objectArray == null) break;
                    this.request.setAttribute("javax.servlet.request.X509Certificate", objectArray);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)exception);
                }
                break;
            }
            case AVAILABLE: {
                this.request.setAvailable(this.inputBuffer.available());
                break;
            }
            case COMET_BEGIN: {
                this.comet = true;
                break;
            }
            case COMET_END: {
                this.comet = false;
                break;
            }
            case COMET_CLOSE: {
                if (this.socketWrapper == null || ((NioChannel)this.socketWrapper.getSocket()).getAttachment() == null) {
                    return;
                }
                NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)((NioChannel)this.socketWrapper.getSocket()).getAttachment();
                keyAttachment.setCometOps(512);
                RequestInfo requestInfo = this.request.getRequestProcessor();
                if (requestInfo.getStage() == 3) break;
                ((NioChannel)this.socketWrapper.getSocket()).getPoller().add((NioChannel)this.socketWrapper.getSocket());
                break;
            }
            case COMET_SETTIMEOUT: {
                if (object == null) {
                    return;
                }
                if (this.socketWrapper == null || ((NioChannel)this.socketWrapper.getSocket()).getAttachment() == null) {
                    return;
                }
                NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)((NioChannel)this.socketWrapper.getSocket()).getAttachment();
                long l = (Long)object;
                RequestInfo requestInfo = this.request.getRequestProcessor();
                if (requestInfo.getStage() == 3) break;
                keyAttachment.setTimeout(l);
                break;
            }
            case ASYNC_COMPLETE: {
                if (!this.asyncStateMachine.asyncComplete()) break;
                ((NioEndpoint)this.endpoint).processSocket((NioChannel)this.socketWrapper.getSocket(), SocketStatus.OPEN_READ, true);
                break;
            }
            case ASYNC_SETTIMEOUT: {
                if (object == null) {
                    return;
                }
                if (this.socketWrapper == null || ((NioChannel)this.socketWrapper.getSocket()).getAttachment() == null) {
                    return;
                }
                NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)((NioChannel)this.socketWrapper.getSocket()).getAttachment();
                long l = (Long)object;
                keyAttachment.setTimeout(l);
                break;
            }
            case ASYNC_DISPATCH: {
                if (!this.asyncStateMachine.asyncDispatch()) break;
                ((NioEndpoint)this.endpoint).processSocket((NioChannel)this.socketWrapper.getSocket(), SocketStatus.OPEN_READ, true);
            }
        }
    }

    @Override
    protected void prepareRequestInternal() {
        this.sendfileData = null;
    }

    @Override
    protected boolean prepareSendfile(OutputFilter[] outputFilterArray) {
        String string = (String)this.request.getAttribute("org.apache.tomcat.sendfile.filename");
        if (string != null) {
            this.outputBuffer.addActiveFilter(outputFilterArray[2]);
            this.contentDelimitation = true;
            this.sendfileData = new NioEndpoint.SendfileData();
            this.sendfileData.fileName = string;
            this.sendfileData.pos = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.start");
            this.sendfileData.length = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.end") - this.sendfileData.pos;
            return true;
        }
        return false;
    }

    @Override
    protected AbstractInputBuffer<NioChannel> getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    protected AbstractOutputBuffer<NioChannel> getOutputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public void setSslSupport(SSLSupport sSLSupport) {
        this.sslSupport = sSLSupport;
    }
}

