/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.LookupRef;
import org.apache.naming.StringManager;

public class LookupFactory
implements ObjectFactory {
    private static final Log log = LogFactory.getLog(LookupFactory.class);
    private static final StringManager sm = StringManager.getManager(LookupFactory.class);
    private static final ThreadLocal<Set<String>> names = new ThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return new HashSet<String>();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        Object object2;
        block22: {
            String string = null;
            object2 = null;
            if (object instanceof LookupRef) {
                Reference reference = (Reference)object;
                ObjectFactory objectFactory = null;
                RefAddr refAddr = reference.get("lookup-name");
                if (refAddr != null) {
                    string = refAddr.getContent().toString();
                }
                try {
                    Serializable serializable;
                    Object object3;
                    Object object4;
                    if (string != null && !names.get().add(string)) {
                        String string2 = sm.getString("lookupFactory.circularReference", string);
                        NamingException namingException = new NamingException(string2);
                        log.warn((Object)string2, (Throwable)namingException);
                        throw namingException;
                    }
                    RefAddr refAddr2 = reference.get("factory");
                    if (refAddr2 != null) {
                        object4 = refAddr2.getContent().toString();
                        object3 = Thread.currentThread().getContextClassLoader();
                        serializable = null;
                        if (object3 != null) {
                            try {
                                serializable = ((ClassLoader)object3).loadClass((String)object4);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                NamingException namingException = new NamingException(sm.getString("lookupFactory.loadFailed"));
                                namingException.initCause(classNotFoundException);
                                throw namingException;
                            }
                        }
                        try {
                            serializable = Class.forName((String)object4);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            NamingException namingException = new NamingException(sm.getString("lookupFactory.loadFailed"));
                            namingException.initCause(classNotFoundException);
                            throw namingException;
                        }
                        if (serializable != null) {
                            try {
                                objectFactory = (ObjectFactory)serializable.getConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (Throwable throwable) {
                                if (throwable instanceof NamingException) {
                                    throw (NamingException)throwable;
                                }
                                NamingException namingException = new NamingException(sm.getString("lookupFactory.createFailed"));
                                namingException.initCause(throwable);
                                throw namingException;
                            }
                        }
                    }
                    if (objectFactory != null) {
                        object2 = objectFactory.getObjectInstance(object, name, context, hashtable);
                    } else {
                        if (string == null) {
                            throw new NamingException(sm.getString("lookupFactory.createFailed"));
                        }
                        object2 = new InitialContext().lookup(string);
                    }
                    object4 = Class.forName(reference.getClassName());
                    if (object2 == null || ((Class)object4).isAssignableFrom(object2.getClass())) break block22;
                    object3 = sm.getString("lookupFactory.typeMismatch", name, reference.getClassName(), string, object2.getClass().getName());
                    serializable = new NamingException((String)object3);
                    log.warn(object3, serializable);
                    if (LookupFactory.isInstance(object2.getClass(), "java.lang.AutoCloseable")) {
                        try {
                            Method method = object2.getClass().getMethod("close", new Class[0]);
                            method.invoke(object2, new Object[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw serializable;
                }
                finally {
                    names.get().remove(string);
                }
            }
        }
        return object2;
    }

    private static boolean isInstance(Class<?> clazz, String string) {
        Class<?>[] classArray;
        if (string.equals(clazz.getName())) {
            return true;
        }
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            if (!LookupFactory.isInstance(clazz2, string)) continue;
            return true;
        }
        Class<?> clazz3 = clazz.getSuperclass();
        if (clazz3 == null) {
            return false;
        }
        return LookupFactory.isInstance(clazz3, string);
    }
}

