/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.SmapGenerator;
import org.apache.jasper.compiler.SmapStratum;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class SmapUtil {
    private static final String SMAP_ENCODING = "UTF-8";

    public static String[] generateSmap(JspCompilationContext jspCompilationContext, Node.Nodes nodes) throws IOException {
        Object object;
        PreScanVisitor preScanVisitor = new PreScanVisitor();
        try {
            nodes.visit(preScanVisitor);
        }
        catch (JasperException jasperException) {
            // empty catch block
        }
        HashMap<String, SmapStratum> hashMap = preScanVisitor.getMap();
        SmapGenerator smapGenerator = new SmapGenerator();
        SmapStratum smapStratum = new SmapStratum();
        smapGenerator.setOutputFileName(SmapUtil.unqualify(jspCompilationContext.getServletJavaFileName()));
        SmapUtil.evaluateNodes(nodes, smapStratum, hashMap, jspCompilationContext.getOptions().getMappedFile());
        smapStratum.optimizeLineSection();
        smapGenerator.setStratum(smapStratum);
        if (jspCompilationContext.getOptions().isSmapDumped()) {
            object = new File(jspCompilationContext.getClassFileName() + ".smap");
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), SMAP_ENCODING));
            printWriter.print(smapGenerator.getString());
            printWriter.close();
        }
        object = jspCompilationContext.getClassFileName();
        int n = hashMap.size();
        String[] stringArray = new String[2 + n * 2];
        stringArray[0] = object;
        stringArray[1] = smapGenerator.getString();
        int n2 = 2;
        for (Map.Entry<String, SmapStratum> entry : hashMap.entrySet()) {
            String string = entry.getKey();
            smapStratum = entry.getValue();
            smapStratum.optimizeLineSection();
            smapGenerator = new SmapGenerator();
            smapGenerator.setOutputFileName(SmapUtil.unqualify(jspCompilationContext.getServletJavaFileName()));
            smapGenerator.setStratum(smapStratum);
            String string2 = ((String)object).substring(0, ((String)object).indexOf(".class")) + '$' + string + ".class";
            if (jspCompilationContext.getOptions().isSmapDumped()) {
                File file = new File(string2 + ".smap");
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), SMAP_ENCODING));
                printWriter.print(smapGenerator.getString());
                printWriter.close();
            }
            stringArray[n2] = string2;
            stringArray[n2 + 1] = smapGenerator.getString();
            n2 += 2;
        }
        return stringArray;
    }

    public static void installSmap(String[] stringArray) throws IOException {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            File file = new File(stringArray[i]);
            SDEInstaller.install(file, stringArray[i + 1].getBytes(StandardCharsets.ISO_8859_1));
        }
    }

    private static String unqualify(String string) {
        string = string.replace('\\', '/');
        return string.substring(string.lastIndexOf(47) + 1);
    }

    public static void evaluateNodes(Node.Nodes nodes, SmapStratum smapStratum, HashMap<String, SmapStratum> hashMap, boolean bl) {
        try {
            nodes.visit(new SmapGenVisitor(smapStratum, bl, hashMap));
        }
        catch (JasperException jasperException) {
            // empty catch block
        }
    }

    private static class PreScanVisitor
    extends Node.Visitor {
        HashMap<String, SmapStratum> map = new HashMap();

        private PreScanVisitor() {
        }

        @Override
        public void doVisit(Node node) {
            String string = node.getInnerClassName();
            if (string != null && !this.map.containsKey(string)) {
                this.map.put(string, new SmapStratum());
            }
        }

        HashMap<String, SmapStratum> getMap() {
            return this.map;
        }
    }

    private static class SDEInstaller {
        private final Log log = LogFactory.getLog(SDEInstaller.class);
        static final String nameSDE = "SourceDebugExtension";
        byte[] orig;
        byte[] sdeAttr;
        byte[] gen;
        int origPos = 0;
        int genPos = 0;
        int sdeIndex;

        static void install(File file, byte[] byArray) throws IOException {
            File file2 = new File(file.getPath() + "tmp");
            SDEInstaller sDEInstaller = new SDEInstaller(file, byArray);
            sDEInstaller.install(file2);
            if (!file.delete()) {
                throw new IOException(Localizer.getMessage("jsp.error.unable.deleteClassFile", file.getAbsolutePath()));
            }
            if (!file2.renameTo(file)) {
                throw new IOException(Localizer.getMessage("jsp.error.unable.renameClassFile", file2.getAbsolutePath(), file.getAbsolutePath()));
            }
        }

        SDEInstaller(File file, byte[] byArray) throws IOException {
            if (!file.exists()) {
                throw new FileNotFoundException("no such file: " + file);
            }
            this.sdeAttr = byArray;
            this.orig = SDEInstaller.readWhole(file);
            this.gen = new byte[this.orig.length + byArray.length + 100];
        }

        void install(File file) throws IOException {
            this.addSDE();
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(this.gen, 0, this.genPos);
            }
        }

        static byte[] readWhole(File file) throws IOException {
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                if (fileInputStream.read(byArray, 0, n) != n) {
                    throw new IOException("expected size: " + n);
                }
            }
            return byArray;
        }

        void addSDE() throws UnsupportedEncodingException, IOException {
            this.copy(8);
            int n = this.genPos;
            int n2 = this.readU2();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("constant pool count: " + n2));
            }
            this.writeU2(n2);
            this.sdeIndex = this.copyConstantPool(n2);
            if (this.sdeIndex < 0) {
                this.writeUtf8ForSDE();
                this.sdeIndex = n2++;
                this.randomAccessWriteU2(n, n2);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("SourceDebugExtension not found, installed at: " + this.sdeIndex));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("SourceDebugExtension found at: " + this.sdeIndex));
            }
            this.copy(6);
            int n3 = this.readU2();
            this.writeU2(n3);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("interfaceCount: " + n3));
            }
            this.copy(n3 * 2);
            this.copyMembers();
            this.copyMembers();
            int n4 = this.genPos;
            int n5 = this.readU2();
            this.writeU2(n5);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("class attrCount: " + n5));
            }
            if (!this.copyAttrs(n5)) {
                this.randomAccessWriteU2(n4, ++n5);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"class attrCount incremented");
                }
            }
            this.writeAttrForSDE(this.sdeIndex);
        }

        void copyMembers() {
            int n = this.readU2();
            this.writeU2(n);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("members count: " + n));
            }
            for (int i = 0; i < n; ++i) {
                this.copy(6);
                int n2 = this.readU2();
                this.writeU2(n2);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("member attr count: " + n2));
                }
                this.copyAttrs(n2);
            }
        }

        boolean copyAttrs(int n) {
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                int n2 = this.readU2();
                if (n2 == this.sdeIndex) {
                    bl = true;
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)"SDE attr found");
                    continue;
                }
                this.writeU2(n2);
                int n3 = this.readU4();
                this.writeU4(n3);
                this.copy(n3);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("attr len: " + n3));
            }
            return bl;
        }

        void writeAttrForSDE(int n) {
            this.writeU2(n);
            this.writeU4(this.sdeAttr.length);
            for (byte by : this.sdeAttr) {
                this.writeU1(by);
            }
        }

        void randomAccessWriteU2(int n, int n2) {
            int n3 = this.genPos;
            this.genPos = n;
            this.writeU2(n2);
            this.genPos = n3;
        }

        int readU1() {
            return this.orig[this.origPos++] & 0xFF;
        }

        int readU2() {
            int n = this.readU1();
            return (n << 8) + this.readU1();
        }

        int readU4() {
            int n = this.readU2();
            return (n << 16) + this.readU2();
        }

        void writeU1(int n) {
            this.gen[this.genPos++] = (byte)n;
        }

        void writeU2(int n) {
            this.writeU1(n >> 8);
            this.writeU1(n & 0xFF);
        }

        void writeU4(int n) {
            this.writeU2(n >> 16);
            this.writeU2(n & 0xFFFF);
        }

        void copy(int n) {
            for (int i = 0; i < n; ++i) {
                this.gen[this.genPos++] = this.orig[this.origPos++];
            }
        }

        byte[] readBytes(int n) {
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.orig[this.origPos++];
            }
            return byArray;
        }

        void writeBytes(byte[] byArray) {
            for (byte by : byArray) {
                this.gen[this.genPos++] = by;
            }
        }

        int copyConstantPool(int n) throws UnsupportedEncodingException, IOException {
            int n2 = -1;
            block7: for (int i = 1; i < n; ++i) {
                int n3 = this.readU1();
                this.writeU1(n3);
                switch (n3) {
                    case 7: 
                    case 8: 
                    case 16: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)(i + " copying 2 bytes"));
                        }
                        this.copy(2);
                        continue block7;
                    }
                    case 15: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)(i + " copying 3 bytes"));
                        }
                        this.copy(3);
                        continue block7;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 18: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)(i + " copying 4 bytes"));
                        }
                        this.copy(4);
                        continue block7;
                    }
                    case 5: 
                    case 6: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)(i + " copying 8 bytes"));
                        }
                        this.copy(8);
                        ++i;
                        continue block7;
                    }
                    case 1: {
                        int n4 = this.readU2();
                        this.writeU2(n4);
                        byte[] byArray = this.readBytes(n4);
                        String string = new String(byArray, SmapUtil.SMAP_ENCODING);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)(i + " read class attr -- '" + string + "'"));
                        }
                        if (string.equals(nameSDE)) {
                            n2 = i;
                        }
                        this.writeBytes(byArray);
                        continue block7;
                    }
                    default: {
                        throw new IOException("unexpected tag: " + n3);
                    }
                }
            }
            return n2;
        }

        void writeUtf8ForSDE() {
            int n = nameSDE.length();
            this.writeU1(1);
            this.writeU2(n);
            for (int i = 0; i < n; ++i) {
                this.writeU1(nameSDE.charAt(i));
            }
        }
    }

    private static class SmapGenVisitor
    extends Node.Visitor {
        private SmapStratum smap;
        private final boolean breakAtLF;
        private final HashMap<String, SmapStratum> innerClassMap;

        SmapGenVisitor(SmapStratum smapStratum, boolean bl, HashMap<String, SmapStratum> hashMap) {
            this.smap = smapStratum;
            this.breakAtLF = bl;
            this.innerClassMap = hashMap;
        }

        @Override
        public void visitBody(Node node) throws JasperException {
            SmapStratum smapStratum = this.smap;
            String string = node.getInnerClassName();
            if (string != null) {
                this.smap = this.innerClassMap.get(string);
            }
            super.visitBody(node);
            this.smap = smapStratum;
        }

        @Override
        public void visit(Node.Declaration declaration) throws JasperException {
            this.doSmapText(declaration);
        }

        @Override
        public void visit(Node.Expression expression) throws JasperException {
            this.doSmapText(expression);
        }

        @Override
        public void visit(Node.Scriptlet scriptlet) throws JasperException {
            this.doSmapText(scriptlet);
        }

        @Override
        public void visit(Node.IncludeAction includeAction) throws JasperException {
            this.doSmap(includeAction);
            this.visitBody(includeAction);
        }

        @Override
        public void visit(Node.ForwardAction forwardAction) throws JasperException {
            this.doSmap(forwardAction);
            this.visitBody(forwardAction);
        }

        @Override
        public void visit(Node.GetProperty getProperty) throws JasperException {
            this.doSmap(getProperty);
            this.visitBody(getProperty);
        }

        @Override
        public void visit(Node.SetProperty setProperty) throws JasperException {
            this.doSmap(setProperty);
            this.visitBody(setProperty);
        }

        @Override
        public void visit(Node.UseBean useBean) throws JasperException {
            this.doSmap(useBean);
            this.visitBody(useBean);
        }

        @Override
        public void visit(Node.PlugIn plugIn) throws JasperException {
            this.doSmap(plugIn);
            this.visitBody(plugIn);
        }

        @Override
        public void visit(Node.CustomTag customTag) throws JasperException {
            this.doSmap(customTag);
            this.visitBody(customTag);
        }

        @Override
        public void visit(Node.UninterpretedTag uninterpretedTag) throws JasperException {
            this.doSmap(uninterpretedTag);
            this.visitBody(uninterpretedTag);
        }

        @Override
        public void visit(Node.JspElement jspElement) throws JasperException {
            this.doSmap(jspElement);
            this.visitBody(jspElement);
        }

        @Override
        public void visit(Node.JspText jspText) throws JasperException {
            this.doSmap(jspText);
            this.visitBody(jspText);
        }

        @Override
        public void visit(Node.NamedAttribute namedAttribute) throws JasperException {
            this.visitBody(namedAttribute);
        }

        @Override
        public void visit(Node.JspBody jspBody) throws JasperException {
            this.doSmap(jspBody);
            this.visitBody(jspBody);
        }

        @Override
        public void visit(Node.InvokeAction invokeAction) throws JasperException {
            this.doSmap(invokeAction);
            this.visitBody(invokeAction);
        }

        @Override
        public void visit(Node.DoBodyAction doBodyAction) throws JasperException {
            this.doSmap(doBodyAction);
            this.visitBody(doBodyAction);
        }

        @Override
        public void visit(Node.ELExpression eLExpression) throws JasperException {
            this.doSmap(eLExpression);
        }

        @Override
        public void visit(Node.TemplateText templateText) throws JasperException {
            Mark mark = templateText.getStart();
            if (mark == null) {
                return;
            }
            String string = mark.getFile();
            this.smap.addFile(SmapUtil.unqualify(string), string);
            int n = mark.getLineNumber();
            int n2 = templateText.getBeginJavaLine();
            int n3 = this.breakAtLF ? 1 : 0;
            this.smap.addLineData(n, string, 1, n2, n3);
            ArrayList<Integer> arrayList = templateText.getExtraSmap();
            if (arrayList != null) {
                for (Integer n4 : arrayList) {
                    this.smap.addLineData(n + n4, string, 1, n2 += n3, n3);
                }
            }
        }

        private void doSmap(Node node, int n, int n2, int n3) {
            Mark mark = node.getStart();
            if (mark == null) {
                return;
            }
            String string = SmapUtil.unqualify(mark.getFile());
            this.smap.addFile(string, mark.getFile());
            this.smap.addLineData(mark.getLineNumber() + n3, mark.getFile(), n - n3, node.getBeginJavaLine() + n3, n2);
        }

        private void doSmap(Node node) {
            this.doSmap(node, 1, node.getEndJavaLine() - node.getBeginJavaLine(), 0);
        }

        private void doSmapText(Node node) {
            String string = node.getText();
            int n = 0;
            int n2 = 0;
            int n3 = 1;
            int n4 = 0;
            boolean bl = false;
            boolean bl2 = true;
            while ((n2 = string.indexOf(10, n)) > -1) {
                if (bl2) {
                    String string2 = string.substring(n, n2).trim();
                    if (!bl && string2.startsWith("/*")) {
                        bl = true;
                    }
                    if (bl) {
                        ++n4;
                        int n5 = string2.indexOf("*/");
                        if (n5 >= 0) {
                            bl = false;
                            if (n5 < string2.length() - 2) {
                                --n4;
                                bl2 = false;
                            }
                        }
                    } else if (string2.length() == 0 || string2.startsWith("//")) {
                        ++n4;
                    } else {
                        bl2 = false;
                    }
                }
                ++n3;
                n = n2 + 1;
            }
            this.doSmap(node, n3, 1, n4);
        }
    }
}

