/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.catalina.tribes.Member;

public class Membership
implements Cloneable {
    protected static final Member[] EMPTY_MEMBERS = new Member[0];
    private Object membersLock = new Object();
    protected final Member local;
    protected HashMap<Member, MbrEntry> map = new HashMap();
    protected volatile Member[] members = EMPTY_MEMBERS;
    protected final Comparator<Member> memberComparator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership clone() {
        Object object = this.membersLock;
        synchronized (object) {
            HashMap hashMap;
            Membership membership;
            try {
                membership = (Membership)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
            membership.map = hashMap = (HashMap)this.map.clone();
            membership.members = (Member[])this.members.clone();
            membership.membersLock = new Object();
            return membership;
        }
    }

    public Membership(Member member, boolean bl) {
        this(member, new MemberComparator(), bl);
    }

    public Membership(Member member) {
        this(member, false);
    }

    public Membership(Member member, Comparator<Member> comparator) {
        this(member, comparator, false);
    }

    public Membership(Member member, Comparator<Member> comparator, boolean bl) {
        this.local = member;
        this.memberComparator = comparator;
        if (bl) {
            this.addMember(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.membersLock;
        synchronized (object) {
            this.map.clear();
            this.members = EMPTY_MEMBERS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean memberAlive(Member member) {
        if (member.equals(this.local)) {
            return false;
        }
        boolean bl = false;
        Object object = this.membersLock;
        synchronized (object) {
            MbrEntry mbrEntry = this.map.get(member);
            if (mbrEntry == null) {
                mbrEntry = this.addMember(member);
                bl = true;
            } else {
                Member member2 = mbrEntry.getMember();
                if (member2.getMemberAliveTime() != member.getMemberAliveTime()) {
                    member2.setMemberAliveTime(member.getMemberAliveTime());
                    member2.setPayload(member.getPayload());
                    member2.setCommand(member.getCommand());
                    Member[] memberArray = (Member[])this.members.clone();
                    Arrays.sort(memberArray, this.memberComparator);
                    this.members = memberArray;
                }
            }
            mbrEntry.accessed();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MbrEntry addMember(Member member) {
        MbrEntry mbrEntry = new MbrEntry(member);
        Object object = this.membersLock;
        synchronized (object) {
            if (!this.map.containsKey(member)) {
                this.map.put(member, mbrEntry);
                Member[] memberArray = new Member[this.members.length + 1];
                System.arraycopy(this.members, 0, memberArray, 0, this.members.length);
                memberArray[this.members.length] = member;
                Arrays.sort(memberArray, this.memberComparator);
                this.members = memberArray;
            }
        }
        return mbrEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(Member member) {
        Object object = this.membersLock;
        synchronized (object) {
            this.map.remove(member);
            int n = -1;
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i] != member && !this.members[i].equals(member)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            Member[] memberArray = new Member[this.members.length - 1];
            int n2 = 0;
            for (int i = 0; i < this.members.length; ++i) {
                if (i == n) continue;
                memberArray[n2++] = this.members[i];
            }
            this.members = memberArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Member[] expire(long l) {
        Object object = this.membersLock;
        synchronized (object) {
            if (!this.hasMembers()) {
                return EMPTY_MEMBERS;
            }
            ArrayList<Member> arrayList = null;
            for (MbrEntry memberArray : this.map.values()) {
                if (!memberArray.hasExpired(l)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Member>();
                }
                arrayList.add(memberArray.getMember());
            }
            if (arrayList != null) {
                Member[] memberArray = new Member[arrayList.size()];
                arrayList.toArray(memberArray);
                for (Member member : memberArray) {
                    this.removeMember(member);
                }
                return memberArray;
            }
            return EMPTY_MEMBERS;
        }
    }

    public boolean hasMembers() {
        return this.members.length > 0;
    }

    public Member getMember(Member member) {
        Member[] memberArray = this.members;
        if (memberArray.length > 0) {
            for (Member member2 : memberArray) {
                if (!member2.equals(member)) continue;
                return member2;
            }
        }
        return null;
    }

    public boolean contains(Member member) {
        return this.getMember(member) != null;
    }

    public Member[] getMembers() {
        return this.members;
    }

    private static class MemberComparator
    implements Comparator<Member>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private MemberComparator() {
        }

        @Override
        public int compare(Member member, Member member2) {
            long l = member2.getMemberAliveTime() - member.getMemberAliveTime();
            if (l < 0L) {
                return -1;
            }
            if (l == 0L) {
                return 0;
            }
            return 1;
        }
    }

    protected static class MbrEntry {
        protected final Member mbr;
        protected long lastHeardFrom;

        public MbrEntry(Member member) {
            this.mbr = member;
        }

        public void accessed() {
            this.lastHeardFrom = System.currentTimeMillis();
        }

        public Member getMember() {
            return this.mbr;
        }

        public boolean hasExpired(long l) {
            long l2 = System.currentTimeMillis() - this.lastHeardFrom;
            return l2 > l;
        }
    }
}

