/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.context;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.tribes.tipis.AbstractReplicatedMap;
import org.apache.catalina.tribes.tipis.ReplicatedMap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class ReplicatedContext
extends StandardContext
implements AbstractReplicatedMap.MapOwner {
    private int mapSendOptions = 2;
    private static final Log log = LogFactory.getLog(ReplicatedContext.class);
    protected static final long DEFAULT_REPL_TIMEOUT = 15000L;
    private static final StringManager sm = StringManager.getManager(ReplicatedContext.class);

    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        try {
            CatalinaCluster catalinaCluster = (CatalinaCluster)this.getCluster();
            if (catalinaCluster != null) {
                ReplicatedMap replicatedMap = new ReplicatedMap((AbstractReplicatedMap.MapOwner)this, catalinaCluster.getChannel(), 15000L, this.getName(), this.getClassLoaders());
                replicatedMap.setChannelSendOptions(this.mapSendOptions);
                ((ReplApplContext)this.context).setAttributeMap((Map<String, Object>)replicatedMap);
            }
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("replicatedContext.startUnable", new Object[]{this.getName()}), (Throwable)exception);
            throw new LifecycleException(sm.getString("replicatedContext.startFailed", new Object[]{this.getName()}), (Throwable)exception);
        }
    }

    protected synchronized void stopInternal() throws LifecycleException {
        Map<String, Object> map = ((ReplApplContext)this.context).getAttributeMap();
        super.stopInternal();
        if (map instanceof ReplicatedMap) {
            ((ReplicatedMap)map).breakdown();
        }
    }

    public void setMapSendOptions(int n) {
        this.mapSendOptions = n;
    }

    public int getMapSendOptions() {
        return this.mapSendOptions;
    }

    public ClassLoader[] getClassLoaders() {
        Loader loader = null;
        ClassLoader classLoader = null;
        loader = this.getLoader();
        if (loader != null) {
            classLoader = loader.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == Thread.currentThread().getContextClassLoader()) {
            return new ClassLoader[]{classLoader};
        }
        return new ClassLoader[]{classLoader, Thread.currentThread().getContextClassLoader()};
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ReplApplContext(this);
            if (this.getAltDDName() != null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", (Object)this.getAltDDName());
            }
        }
        return ((ReplApplContext)this.context).getFacade();
    }

    public void objectMadePrimary(Object object, Object object2) {
    }

    protected static class ReplApplContext
    extends ApplicationContext {
        protected final Map<String, Object> tomcatAttributes = new ConcurrentHashMap<String, Object>();

        public ReplApplContext(ReplicatedContext replicatedContext) {
            super((StandardContext)replicatedContext);
        }

        protected ReplicatedContext getParent() {
            return (ReplicatedContext)this.getContext();
        }

        protected ServletContext getFacade() {
            return super.getFacade();
        }

        public Map<String, Object> getAttributeMap() {
            return this.attributes;
        }

        public void setAttributeMap(Map<String, Object> map) {
            this.attributes = map;
        }

        public void removeAttribute(String string) {
            this.tomcatAttributes.remove(string);
            super.removeAttribute(string);
        }

        public void setAttribute(String string, Object object) {
            if (string == null) {
                throw new IllegalArgumentException(sm.getString("applicationContext.setAttribute.namenull"));
            }
            if (object == null) {
                this.removeAttribute(string);
                return;
            }
            if (!this.getParent().getState().isAvailable() || "org.apache.jasper.runtime.JspApplicationContextImpl".equals(string)) {
                this.tomcatAttributes.put(string, object);
            } else {
                super.setAttribute(string, object);
            }
        }

        public Object getAttribute(String string) {
            Object object = this.tomcatAttributes.get(string);
            if (object == null) {
                return super.getAttribute(string);
            }
            return object;
        }

        public Enumeration<String> getAttributeNames() {
            HashSet hashSet = new HashSet(this.attributes.keySet());
            return new MultiEnumeration<String>(new Enumeration[]{super.getAttributeNames(), Collections.enumeration(hashSet)});
        }
    }

    protected static class MultiEnumeration<T>
    implements Enumeration<T> {
        private final Enumeration<T>[] enumerations;

        public MultiEnumeration(Enumeration<T>[] enumerationArray) {
            this.enumerations = enumerationArray;
        }

        @Override
        public boolean hasMoreElements() {
            for (Enumeration<T> enumeration : this.enumerations) {
                if (!enumeration.hasMoreElements()) continue;
                return true;
            }
            return false;
        }

        @Override
        public T nextElement() {
            for (Enumeration<T> enumeration : this.enumerations) {
                if (!enumeration.hasMoreElements()) continue;
                return enumeration.nextElement();
            }
            return null;
        }
    }
}

