/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.WritePendingException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteBufferUtils;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.Nio2Endpoint;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.net.TLSClientHelloExtractor;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;
import org.apache.tomcat.util.res.StringManager;

public class SecureNio2Channel
extends Nio2Channel {
    private static final Log log = LogFactory.getLog(SecureNio2Channel.class);
    private static final StringManager sm = StringManager.getManager(SecureNio2Channel.class);
    private static final int DEFAULT_NET_BUFFER_SIZE = 16921;
    protected ByteBuffer netInBuffer;
    protected ByteBuffer netOutBuffer;
    protected SSLEngine sslEngine;
    protected final Nio2Endpoint endpoint;
    protected boolean sniComplete = false;
    private volatile boolean handshakeComplete;
    private volatile SSLEngineResult.HandshakeStatus handshakeStatus;
    private volatile boolean unwrapBeforeRead;
    protected boolean closed;
    protected boolean closing;
    private final CompletionHandler<Integer, SocketWrapperBase<Nio2Channel>> handshakeReadCompletionHandler;
    private final CompletionHandler<Integer, SocketWrapperBase<Nio2Channel>> handshakeWriteCompletionHandler;

    public SecureNio2Channel(SocketBufferHandler socketBufferHandler, Nio2Endpoint nio2Endpoint) {
        super(socketBufferHandler);
        this.endpoint = nio2Endpoint;
        if (nio2Endpoint.getSocketProperties().getDirectSslBuffer()) {
            this.netInBuffer = ByteBuffer.allocateDirect(16921);
            this.netOutBuffer = ByteBuffer.allocateDirect(16921);
        } else {
            this.netInBuffer = ByteBuffer.allocate(16921);
            this.netOutBuffer = ByteBuffer.allocate(16921);
        }
        this.handshakeReadCompletionHandler = new HandshakeReadCompletionHandler();
        this.handshakeWriteCompletionHandler = new HandshakeWriteCompletionHandler();
    }

    @Override
    public void reset(AsynchronousSocketChannel asynchronousSocketChannel, SocketWrapperBase<Nio2Channel> socketWrapperBase) throws IOException {
        super.reset(asynchronousSocketChannel, socketWrapperBase);
        this.sslEngine = null;
        this.sniComplete = false;
        this.handshakeComplete = false;
        this.unwrapBeforeRead = true;
        this.closed = false;
        this.closing = false;
        this.netInBuffer.clear();
    }

    @Override
    public void free() {
        super.free();
        if (this.endpoint.getSocketProperties().getDirectSslBuffer()) {
            ByteBufferUtils.cleanDirectBuffer((ByteBuffer)this.netInBuffer);
            ByteBufferUtils.cleanDirectBuffer((ByteBuffer)this.netOutBuffer);
        }
    }

    @Override
    public Future<Boolean> flush() {
        return new FutureFlush();
    }

    @Override
    public int handshake() throws IOException {
        return this.handshakeInternal(true);
    }

    protected int handshakeInternal(boolean bl) throws IOException {
        if (this.handshakeComplete) {
            return 0;
        }
        if (!this.sniComplete) {
            int n = this.processSNI();
            if (n == 0) {
                this.sniComplete = true;
            } else {
                return n;
            }
        }
        SSLEngineResult sSLEngineResult = null;
        long l = this.endpoint.getConnectionTimeout();
        block15: while (!this.handshakeComplete) {
            switch (this.handshakeStatus) {
                case NOT_HANDSHAKING: {
                    throw new IOException(sm.getString("channel.nio.ssl.notHandshaking"));
                }
                case FINISHED: {
                    if (this.endpoint.hasNegotiableProtocols()) {
                        if (this.sslEngine instanceof SSLUtil.ProtocolInfo) {
                            this.socket.setNegotiatedProtocol(((SSLUtil.ProtocolInfo)((Object)this.sslEngine)).getNegotiatedProtocol());
                        } else if (JreCompat.isAlpnSupported()) {
                            this.socket.setNegotiatedProtocol(JreCompat.getInstance().getApplicationProtocol(this.sslEngine));
                        }
                    }
                    boolean bl2 = this.handshakeComplete = !this.netOutBuffer.hasRemaining();
                    if (this.handshakeComplete) {
                        return 0;
                    }
                    if (bl) {
                        this.sc.write(this.netOutBuffer, AbstractEndpoint.toTimeout(l), TimeUnit.MILLISECONDS, this.socket, this.handshakeWriteCompletionHandler);
                    } else {
                        try {
                            if (l > 0L) {
                                this.sc.write(this.netOutBuffer).get(l, TimeUnit.MILLISECONDS);
                            } else {
                                this.sc.write(this.netOutBuffer).get();
                            }
                        }
                        catch (InterruptedException | ExecutionException | TimeoutException exception) {
                            throw new IOException(sm.getString("channel.nio.ssl.handshakeError"));
                        }
                    }
                    return 1;
                }
                case NEED_WRAP: {
                    try {
                        sSLEngineResult = this.handshakeWrap();
                    }
                    catch (SSLException sSLException) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("channel.nio.ssl.wrapException"), (Throwable)sSLException);
                        }
                        sSLEngineResult = this.handshakeWrap();
                    }
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
                        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            this.handshakeStatus = this.tasks();
                        }
                    } else {
                        if (sSLEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                            return -1;
                        }
                        throw new IOException(sm.getString("channel.nio.ssl.unexpectedStatusDuringWrap", new Object[]{sSLEngineResult.getStatus()}));
                    }
                    if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || this.netOutBuffer.remaining() > 0) {
                        if (bl) {
                            this.sc.write(this.netOutBuffer, AbstractEndpoint.toTimeout(l), TimeUnit.MILLISECONDS, this.socket, this.handshakeWriteCompletionHandler);
                        } else {
                            try {
                                if (l > 0L) {
                                    this.sc.write(this.netOutBuffer).get(l, TimeUnit.MILLISECONDS);
                                } else {
                                    this.sc.write(this.netOutBuffer).get();
                                }
                            }
                            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                                throw new IOException(sm.getString("channel.nio.ssl.handshakeError"));
                            }
                        }
                        return 1;
                    }
                }
                case NEED_UNWRAP: {
                    sSLEngineResult = this.handshakeUnwrap();
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
                        if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) continue block15;
                        this.handshakeStatus = this.tasks();
                        continue block15;
                    }
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        if (this.netInBuffer.position() == this.netInBuffer.limit()) {
                            this.netInBuffer.clear();
                        }
                        if (bl) {
                            this.sc.read(this.netInBuffer, AbstractEndpoint.toTimeout(l), TimeUnit.MILLISECONDS, this.socket, this.handshakeReadCompletionHandler);
                        } else {
                            try {
                                int n = l > 0L ? this.sc.read(this.netInBuffer).get(l, TimeUnit.MILLISECONDS).intValue() : this.sc.read(this.netInBuffer).get().intValue();
                                if (n == -1) {
                                    throw new EOFException();
                                }
                            }
                            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                                throw new IOException(sm.getString("channel.nio.ssl.handshakeError"));
                            }
                        }
                        return 1;
                    }
                    throw new IOException(sm.getString("channel.nio.ssl.unexpectedStatusDuringUnwrap", new Object[]{sSLEngineResult.getStatus()}));
                }
                case NEED_TASK: {
                    this.handshakeStatus = this.tasks();
                    continue block15;
                }
            }
            throw new IllegalStateException(sm.getString("channel.nio.ssl.invalidStatus", new Object[]{this.handshakeStatus}));
        }
        return this.handshakeComplete ? 0 : this.handshakeInternal(bl);
    }

    private int processSNI() throws IOException {
        if (this.netInBuffer.position() == 0) {
            this.sc.read(this.netInBuffer, AbstractEndpoint.toTimeout(this.endpoint.getConnectionTimeout()), TimeUnit.MILLISECONDS, this.socket, this.handshakeReadCompletionHandler);
            return 1;
        }
        TLSClientHelloExtractor tLSClientHelloExtractor = new TLSClientHelloExtractor(this.netInBuffer);
        if (tLSClientHelloExtractor.getResult() == TLSClientHelloExtractor.ExtractorResult.UNDERFLOW && this.netInBuffer.capacity() < this.endpoint.getSniParseLimit()) {
            int n = Math.min(this.netInBuffer.capacity() * 2, this.endpoint.getSniParseLimit());
            log.info((Object)sm.getString("channel.nio.ssl.expandNetInBuffer", new Object[]{Integer.toString(n)}));
            this.netInBuffer = ByteBufferUtils.expand((ByteBuffer)this.netInBuffer, (int)n);
            this.sc.read(this.netInBuffer, AbstractEndpoint.toTimeout(this.endpoint.getConnectionTimeout()), TimeUnit.MILLISECONDS, this.socket, this.handshakeReadCompletionHandler);
            return 1;
        }
        String string = null;
        List<Cipher> list = null;
        List<String> list2 = null;
        switch (tLSClientHelloExtractor.getResult()) {
            case COMPLETE: {
                string = tLSClientHelloExtractor.getSNIValue();
                list2 = tLSClientHelloExtractor.getClientRequestedApplicationProtocols();
            }
            case NOT_PRESENT: {
                list = tLSClientHelloExtractor.getClientRequestedCiphers();
                break;
            }
            case NEED_READ: {
                this.sc.read(this.netInBuffer, AbstractEndpoint.toTimeout(this.endpoint.getConnectionTimeout()), TimeUnit.MILLISECONDS, this.socket, this.handshakeReadCompletionHandler);
                return 1;
            }
            case UNDERFLOW: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("channel.nio.ssl.sniDefault"));
                }
                string = this.endpoint.getDefaultSSLHostConfigName();
                list = Collections.emptyList();
                break;
            }
            case NON_SECURE: {
                this.netOutBuffer.clear();
                this.netOutBuffer.put(TLSClientHelloExtractor.USE_TLS_RESPONSE);
                this.netOutBuffer.flip();
                this.flush();
                throw new IOException(sm.getString("channel.nio.ssl.foundHttp"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("channel.nio.ssl.sniHostName", new Object[]{this.sc, string}));
        }
        this.sslEngine = this.endpoint.createSSLEngine(string, list, list2);
        this.getBufHandler().expand(this.sslEngine.getSession().getApplicationBufferSize());
        if (this.netOutBuffer.capacity() < this.sslEngine.getSession().getApplicationBufferSize()) {
            log.info((Object)sm.getString("channel.nio.ssl.expandNetOutBuffer", new Object[]{Integer.toString(this.sslEngine.getSession().getApplicationBufferSize())}));
        }
        this.netInBuffer = ByteBufferUtils.expand((ByteBuffer)this.netInBuffer, (int)this.sslEngine.getSession().getPacketBufferSize());
        this.netOutBuffer = ByteBufferUtils.expand((ByteBuffer)this.netOutBuffer, (int)this.sslEngine.getSession().getPacketBufferSize());
        this.netOutBuffer.position(0);
        this.netOutBuffer.limit(0);
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        return 0;
    }

    public void rehandshake() throws IOException {
        if (this.netInBuffer.position() > 0 && this.netInBuffer.position() < this.netInBuffer.limit()) {
            throw new IOException(sm.getString("channel.nio.ssl.netInputNotEmpty"));
        }
        if (this.netOutBuffer.position() > 0 && this.netOutBuffer.position() < this.netOutBuffer.limit()) {
            throw new IOException(sm.getString("channel.nio.ssl.netOutputNotEmpty"));
        }
        if (!this.getBufHandler().isReadBufferEmpty()) {
            throw new IOException(sm.getString("channel.nio.ssl.appInputNotEmpty"));
        }
        if (!this.getBufHandler().isWriteBufferEmpty()) {
            throw new IOException(sm.getString("channel.nio.ssl.appOutputNotEmpty"));
        }
        this.netOutBuffer.position(0);
        this.netOutBuffer.limit(0);
        this.netInBuffer.position(0);
        this.netInBuffer.limit(0);
        this.getBufHandler().reset();
        this.handshakeComplete = false;
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        boolean bl = true;
        try {
            while (bl) {
                int n = this.handshakeInternal(false);
                switch (n) {
                    case -1: {
                        throw new EOFException(sm.getString("channel.nio.ssl.eofDuringHandshake"));
                    }
                    case 0: {
                        bl = false;
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.closeSilently();
            throw iOException;
        }
        catch (Exception exception) {
            this.closeSilently();
            IOException iOException = new IOException(exception);
            throw iOException;
        }
    }

    protected SSLEngineResult.HandshakeStatus tasks() {
        Runnable runnable = null;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    protected SSLEngineResult handshakeWrap() throws IOException {
        this.netOutBuffer.clear();
        this.getBufHandler().configureWriteBufferForRead();
        SSLEngineResult sSLEngineResult = this.sslEngine.wrap(this.getBufHandler().getWriteBuffer(), this.netOutBuffer);
        this.netOutBuffer.flip();
        this.handshakeStatus = sSLEngineResult.getHandshakeStatus();
        return sSLEngineResult;
    }

    protected SSLEngineResult handshakeUnwrap() throws IOException {
        SSLEngineResult sSLEngineResult;
        boolean bl = false;
        do {
            this.netInBuffer.flip();
            this.getBufHandler().configureReadBufferForWrite();
            sSLEngineResult = this.sslEngine.unwrap(this.netInBuffer, this.getBufHandler().getReadBuffer());
            this.netInBuffer.compact();
            this.handshakeStatus = sSLEngineResult.getHandshakeStatus();
            if (sSLEngineResult.getStatus() != SSLEngineResult.Status.OK || sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
            this.handshakeStatus = this.tasks();
        } while (bl = sSLEngineResult.getStatus() == SSLEngineResult.Status.OK && this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
        return sSLEngineResult;
    }

    @Override
    public void close() throws IOException {
        if (this.closing) {
            return;
        }
        this.closing = true;
        this.sslEngine.closeOutbound();
        long l = this.endpoint.getConnectionTimeout();
        try {
            if (l > 0L) {
                if (!this.flush().get(l, TimeUnit.MILLISECONDS).booleanValue()) {
                    this.closeSilently();
                    throw new IOException(sm.getString("channel.nio.ssl.remainingDataDuringClose"));
                }
            } else if (!this.flush().get().booleanValue()) {
                this.closeSilently();
                throw new IOException(sm.getString("channel.nio.ssl.remainingDataDuringClose"));
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.closeSilently();
            throw new IOException(sm.getString("channel.nio.ssl.remainingDataDuringClose"), exception);
        }
        catch (WritePendingException writePendingException) {
            this.closeSilently();
            throw new IOException(sm.getString("channel.nio.ssl.pendingWriteDuringClose"), writePendingException);
        }
        this.netOutBuffer.clear();
        SSLEngineResult sSLEngineResult = this.sslEngine.wrap(this.getEmptyBuf(), this.netOutBuffer);
        if (sSLEngineResult.getStatus() != SSLEngineResult.Status.CLOSED) {
            throw new IOException(sm.getString("channel.nio.ssl.invalidCloseState"));
        }
        this.netOutBuffer.flip();
        try {
            if (l > 0L) {
                if (!this.flush().get(l, TimeUnit.MILLISECONDS).booleanValue()) {
                    this.closeSilently();
                    throw new IOException(sm.getString("channel.nio.ssl.remainingDataDuringClose"));
                }
            } else if (!this.flush().get().booleanValue()) {
                this.closeSilently();
                throw new IOException(sm.getString("channel.nio.ssl.remainingDataDuringClose"));
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.closeSilently();
            throw new IOException(sm.getString("channel.nio.ssl.remainingDataDuringClose"), exception);
        }
        catch (WritePendingException writePendingException) {
            this.closeSilently();
            throw new IOException(sm.getString("channel.nio.ssl.pendingWriteDuringClose"), writePendingException);
        }
        this.closed = !this.netOutBuffer.hasRemaining() && sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP;
    }

    @Override
    public void close(boolean bl) throws IOException {
        try {
            this.close();
        }
        finally {
            if (bl || this.closed) {
                this.closed = true;
                this.sc.close();
            }
        }
    }

    private void closeSilently() {
        try {
            this.close(true);
        }
        catch (IOException iOException) {
            log.debug((Object)sm.getString("channel.nio.ssl.closeSilentError"), (Throwable)iOException);
        }
    }

    @Override
    public Future<Integer> read(ByteBuffer byteBuffer) {
        if (!this.handshakeComplete) {
            throw new IllegalStateException(sm.getString("channel.nio.ssl.incompleteHandshake"));
        }
        return new FutureRead(byteBuffer);
    }

    @Override
    public Future<Integer> write(ByteBuffer byteBuffer) {
        return new FutureWrite(byteBuffer);
    }

    @Override
    public <A> void read(final ByteBuffer byteBuffer, final long l, final TimeUnit timeUnit, final A a, final CompletionHandler<Integer, ? super A> completionHandler) {
        if (this.closing || this.closed) {
            completionHandler.completed(-1, a);
            return;
        }
        if (!this.handshakeComplete) {
            throw new IllegalStateException(sm.getString("channel.nio.ssl.incompleteHandshake"));
        }
        CompletionHandler completionHandler2 = new CompletionHandler<Integer, A>(){

            @Override
            public void completed(Integer n, A a2) {
                if (n < 0) {
                    this.failed(new EOFException(), a2);
                } else {
                    try {
                        ByteBuffer byteBuffer2 = byteBuffer;
                        int n2 = 0;
                        do {
                            SecureNio2Channel.this.netInBuffer.flip();
                            SSLEngineResult sSLEngineResult = SecureNio2Channel.this.sslEngine.unwrap(SecureNio2Channel.this.netInBuffer, byteBuffer2);
                            SecureNio2Channel.this.netInBuffer.compact();
                            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK || sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                                n2 += sSLEngineResult.bytesProduced();
                                if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                                    SecureNio2Channel.this.tasks();
                                }
                                if (sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                                if (n2 != 0) break;
                                SecureNio2Channel.this.sc.read(SecureNio2Channel.this.netInBuffer, l, timeUnit, a, this);
                                return;
                            }
                            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                                if (n2 > 0) break;
                                if (byteBuffer2 == SecureNio2Channel.this.getBufHandler().getReadBuffer()) {
                                    SecureNio2Channel.this.getBufHandler().expand(SecureNio2Channel.this.sslEngine.getSession().getApplicationBufferSize());
                                    byteBuffer2 = SecureNio2Channel.this.getBufHandler().getReadBuffer();
                                    continue;
                                }
                                if (byteBuffer2 == SecureNio2Channel.this.getAppReadBufHandler().getByteBuffer()) {
                                    SecureNio2Channel.this.getAppReadBufHandler().expand(SecureNio2Channel.this.sslEngine.getSession().getApplicationBufferSize());
                                    byteBuffer2 = SecureNio2Channel.this.getAppReadBufHandler().getByteBuffer();
                                    continue;
                                }
                                throw new IOException(sm.getString("channel.nio.ssl.unwrapFailResize", new Object[]{sSLEngineResult.getStatus()}));
                            }
                            throw new IOException(sm.getString("channel.nio.ssl.unwrapFail", new Object[]{sSLEngineResult.getStatus()}));
                        } while (SecureNio2Channel.this.netInBuffer.position() != 0);
                        if (!byteBuffer2.hasRemaining()) {
                            SecureNio2Channel.this.unwrapBeforeRead = true;
                        } else {
                            SecureNio2Channel.this.unwrapBeforeRead = false;
                        }
                        completionHandler.completed(n2, a2);
                    }
                    catch (Exception exception) {
                        this.failed(exception, a2);
                    }
                }
            }

            @Override
            public void failed(Throwable throwable, A a2) {
                completionHandler.failed(throwable, a2);
            }
        };
        if (this.unwrapBeforeRead || this.netInBuffer.position() > 0) {
            completionHandler2.completed(this.netInBuffer.position(), a);
        } else {
            this.sc.read(this.netInBuffer, l, timeUnit, a, completionHandler2);
        }
    }

    @Override
    public <A> void read(final ByteBuffer[] byteBufferArray, final int n, final int n2, final long l, final TimeUnit timeUnit, final A a, final CompletionHandler<Long, ? super A> completionHandler) {
        if (n < 0 || byteBufferArray == null || n + n2 > byteBufferArray.length) {
            throw new IllegalArgumentException();
        }
        if (this.closing || this.closed) {
            completionHandler.completed(-1L, a);
            return;
        }
        if (!this.handshakeComplete) {
            throw new IllegalStateException(sm.getString("channel.nio.ssl.incompleteHandshake"));
        }
        CompletionHandler completionHandler2 = new CompletionHandler<Integer, A>(){

            @Override
            public void completed(Integer n6, A a2) {
                if (n6 < 0) {
                    this.failed(new EOFException(), a2);
                } else {
                    try {
                        int n22;
                        int n3;
                        long l2 = 0L;
                        ByteBuffer[] byteBufferArray2 = byteBufferArray;
                        int n4 = n2;
                        boolean bl = false;
                        do {
                            n3 = 0;
                            if (bl) {
                                n3 = 1;
                            }
                            bl = false;
                            SecureNio2Channel.this.netInBuffer.flip();
                            SSLEngineResult sSLEngineResult = SecureNio2Channel.this.sslEngine.unwrap(SecureNio2Channel.this.netInBuffer, byteBufferArray2, n, n4);
                            SecureNio2Channel.this.netInBuffer.compact();
                            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK || sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                                l2 += (long)sSLEngineResult.bytesProduced();
                                if (n3 != 0) {
                                    l2 -= (long)byteBufferArray2[byteBufferArray.length].position();
                                }
                                if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                                    SecureNio2Channel.this.tasks();
                                }
                                if (sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                                if (l2 != 0L) break;
                                SecureNio2Channel.this.sc.read(SecureNio2Channel.this.netInBuffer, l, timeUnit, a, this);
                                return;
                            }
                            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW && l2 > 0L) break;
                            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                                ByteBuffer byteBuffer = SecureNio2Channel.this.getBufHandler().getReadBuffer();
                                n22 = 0;
                                for (ByteBuffer byteBuffer2 : byteBufferArray2) {
                                    if (byteBuffer2 != byteBuffer) continue;
                                    n22 = 1;
                                }
                                if (n22 != 0) {
                                    throw new IOException(sm.getString("channel.nio.ssl.unwrapFail", new Object[]{sSLEngineResult.getStatus()}));
                                }
                                byteBufferArray2 = new ByteBuffer[byteBufferArray.length + 1];
                                for (int i = 0; i < byteBufferArray.length; ++i) {
                                    byteBufferArray2[i] = byteBufferArray[i];
                                }
                                byteBufferArray2[byteBufferArray.length] = byteBuffer;
                                n4 = n2 + 1;
                                SecureNio2Channel.this.getBufHandler().configureReadBufferForWrite();
                                bl = true;
                                continue;
                            }
                            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) break;
                            throw new IOException(sm.getString("channel.nio.ssl.unwrapFail", new Object[]{sSLEngineResult.getStatus()}));
                        } while (SecureNio2Channel.this.netInBuffer.position() != 0 || bl);
                        n3 = 0;
                        int n5 = n + n2;
                        for (n22 = n; n22 < n5; ++n22) {
                            n3 += byteBufferArray[n22].remaining();
                        }
                        if (n3 == 0) {
                            SecureNio2Channel.this.unwrapBeforeRead = true;
                        } else {
                            SecureNio2Channel.this.unwrapBeforeRead = false;
                        }
                        completionHandler.completed(l2, a2);
                    }
                    catch (Exception exception) {
                        this.failed(exception, a2);
                    }
                }
            }

            @Override
            public void failed(Throwable throwable, A a2) {
                completionHandler.failed(throwable, a2);
            }
        };
        if (this.unwrapBeforeRead || this.netInBuffer.position() > 0) {
            completionHandler2.completed(this.netInBuffer.position(), a);
        } else {
            this.sc.read(this.netInBuffer, l, timeUnit, a, completionHandler2);
        }
    }

    @Override
    public <A> void write(final ByteBuffer byteBuffer, final long l, final TimeUnit timeUnit, final A a, final CompletionHandler<Integer, ? super A> completionHandler) {
        if (this.closing || this.closed) {
            completionHandler.failed(new IOException(sm.getString("channel.nio.ssl.closing")), a);
            return;
        }
        try {
            this.netOutBuffer.clear();
            SSLEngineResult sSLEngineResult = this.sslEngine.wrap(byteBuffer, this.netOutBuffer);
            final int n = sSLEngineResult.bytesConsumed();
            this.netOutBuffer.flip();
            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
                if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.tasks();
                }
            } else {
                throw new IOException(sm.getString("channel.nio.ssl.wrapFail", new Object[]{sSLEngineResult.getStatus()}));
            }
            this.sc.write(this.netOutBuffer, l, timeUnit, a, new CompletionHandler<Integer, A>(){

                @Override
                public void completed(Integer n2, A a2) {
                    if (n2 < 0) {
                        this.failed(new EOFException(), a2);
                    } else if (SecureNio2Channel.this.netOutBuffer.hasRemaining()) {
                        SecureNio2Channel.this.sc.write(SecureNio2Channel.this.netOutBuffer, l, timeUnit, a, this);
                    } else if (n == 0) {
                        SecureNio2Channel.this.write(byteBuffer, l, timeUnit, a, completionHandler);
                    } else {
                        completionHandler.completed(n, a2);
                    }
                }

                @Override
                public void failed(Throwable throwable, A a2) {
                    completionHandler.failed(throwable, a2);
                }
            });
        }
        catch (Exception exception) {
            completionHandler.failed(exception, a);
        }
    }

    @Override
    public <A> void write(final ByteBuffer[] byteBufferArray, final int n, final int n2, final long l, final TimeUnit timeUnit, final A a, final CompletionHandler<Long, ? super A> completionHandler) {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (this.closing || this.closed) {
            completionHandler.failed(new IOException(sm.getString("channel.nio.ssl.closing")), a);
            return;
        }
        try {
            this.netOutBuffer.clear();
            SSLEngineResult sSLEngineResult = this.sslEngine.wrap(byteBufferArray, n, n2, this.netOutBuffer);
            final int n3 = sSLEngineResult.bytesConsumed();
            this.netOutBuffer.flip();
            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
                if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.tasks();
                }
            } else {
                throw new IOException(sm.getString("channel.nio.ssl.wrapFail", new Object[]{sSLEngineResult.getStatus()}));
            }
            this.sc.write(this.netOutBuffer, l, timeUnit, a, new CompletionHandler<Integer, A>(){

                @Override
                public void completed(Integer n4, A a2) {
                    if (n4 < 0) {
                        this.failed(new EOFException(), a2);
                    } else if (SecureNio2Channel.this.netOutBuffer.hasRemaining()) {
                        SecureNio2Channel.this.sc.write(SecureNio2Channel.this.netOutBuffer, l, timeUnit, a, this);
                    } else if (n3 == 0) {
                        SecureNio2Channel.this.write(byteBufferArray, n, n2, l, timeUnit, a, completionHandler);
                    } else {
                        completionHandler.completed(Long.valueOf(n3), a2);
                    }
                }

                @Override
                public void failed(Throwable throwable, A a2) {
                    completionHandler.failed(throwable, a2);
                }
            });
        }
        catch (Exception exception) {
            completionHandler.failed(exception, a);
        }
    }

    @Override
    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public ByteBuffer getEmptyBuf() {
        return emptyBuf;
    }

    private class HandshakeReadCompletionHandler
    implements CompletionHandler<Integer, SocketWrapperBase<Nio2Channel>> {
        private HandshakeReadCompletionHandler() {
        }

        @Override
        public void completed(Integer n, SocketWrapperBase<Nio2Channel> socketWrapperBase) {
            if (n < 0) {
                this.failed((Throwable)new EOFException(), socketWrapperBase);
            } else {
                SecureNio2Channel.this.endpoint.processSocket(socketWrapperBase, SocketEvent.OPEN_READ, false);
            }
        }

        @Override
        public void failed(Throwable throwable, SocketWrapperBase<Nio2Channel> socketWrapperBase) {
            SecureNio2Channel.this.endpoint.processSocket(socketWrapperBase, SocketEvent.ERROR, false);
        }
    }

    private class HandshakeWriteCompletionHandler
    implements CompletionHandler<Integer, SocketWrapperBase<Nio2Channel>> {
        private HandshakeWriteCompletionHandler() {
        }

        @Override
        public void completed(Integer n, SocketWrapperBase<Nio2Channel> socketWrapperBase) {
            if (n < 0) {
                this.failed((Throwable)new EOFException(), socketWrapperBase);
            } else {
                SecureNio2Channel.this.endpoint.processSocket(socketWrapperBase, SocketEvent.OPEN_WRITE, false);
            }
        }

        @Override
        public void failed(Throwable throwable, SocketWrapperBase<Nio2Channel> socketWrapperBase) {
            SecureNio2Channel.this.endpoint.processSocket(socketWrapperBase, SocketEvent.ERROR, false);
        }
    }

    private class FutureFlush
    implements Future<Boolean> {
        private Future<Integer> integer;
        private Exception e = null;

        protected FutureFlush() {
            try {
                this.integer = SecureNio2Channel.this.sc.write(SecureNio2Channel.this.netOutBuffer);
            }
            catch (IllegalStateException illegalStateException) {
                this.e = illegalStateException;
            }
        }

        @Override
        public boolean cancel(boolean bl) {
            return this.e != null ? true : this.integer.cancel(bl);
        }

        @Override
        public boolean isCancelled() {
            return this.e != null ? true : this.integer.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.e != null ? true : this.integer.isDone();
        }

        @Override
        public Boolean get() throws InterruptedException, ExecutionException {
            if (this.e != null) {
                throw new ExecutionException(this.e);
            }
            return this.integer.get() >= 0;
        }

        @Override
        public Boolean get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.e != null) {
                throw new ExecutionException(this.e);
            }
            return this.integer.get(l, timeUnit) >= 0;
        }
    }

    private class FutureRead
    implements Future<Integer> {
        private ByteBuffer dst;
        private Future<Integer> integer;

        private FutureRead(ByteBuffer byteBuffer) {
            this.dst = byteBuffer;
            this.integer = SecureNio2Channel.this.unwrapBeforeRead || SecureNio2Channel.this.netInBuffer.position() > 0 ? null : SecureNio2Channel.this.sc.read(SecureNio2Channel.this.netInBuffer);
        }

        @Override
        public boolean cancel(boolean bl) {
            return this.integer == null ? false : this.integer.cancel(bl);
        }

        @Override
        public boolean isCancelled() {
            return this.integer == null ? false : this.integer.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.integer == null ? true : this.integer.isDone();
        }

        @Override
        public Integer get() throws InterruptedException, ExecutionException {
            try {
                return this.integer == null ? this.unwrap(SecureNio2Channel.this.netInBuffer.position(), -1L, TimeUnit.MILLISECONDS) : this.unwrap(this.integer.get(), -1L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                throw new ExecutionException(timeoutException);
            }
        }

        @Override
        public Integer get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.integer == null ? this.unwrap(SecureNio2Channel.this.netInBuffer.position(), l, timeUnit) : this.unwrap(this.integer.get(l, timeUnit), l, timeUnit);
        }

        private Integer unwrap(int n, long l, TimeUnit timeUnit) throws ExecutionException, TimeoutException, InterruptedException {
            if (SecureNio2Channel.this.closing || SecureNio2Channel.this.closed) {
                return -1;
            }
            if (n < 0) {
                return -1;
            }
            int n2 = 0;
            do {
                SSLEngineResult sSLEngineResult;
                SecureNio2Channel.this.netInBuffer.flip();
                try {
                    sSLEngineResult = SecureNio2Channel.this.sslEngine.unwrap(SecureNio2Channel.this.netInBuffer, this.dst);
                }
                catch (SSLException sSLException) {
                    throw new ExecutionException(sSLException);
                }
                SecureNio2Channel.this.netInBuffer.compact();
                if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK || sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    n2 += sSLEngineResult.bytesProduced();
                    if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        SecureNio2Channel.this.tasks();
                    }
                    if (sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                    if (n2 != 0) break;
                    this.integer = SecureNio2Channel.this.sc.read(SecureNio2Channel.this.netInBuffer);
                    if (l > 0L) {
                        return this.unwrap(this.integer.get(l, timeUnit), l, timeUnit);
                    }
                    return this.unwrap(this.integer.get(), -1L, TimeUnit.MILLISECONDS);
                }
                if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    if (n2 > 0) break;
                    if (this.dst == SecureNio2Channel.this.getBufHandler().getReadBuffer()) {
                        SecureNio2Channel.this.getBufHandler().expand(SecureNio2Channel.this.sslEngine.getSession().getApplicationBufferSize());
                        this.dst = SecureNio2Channel.this.getBufHandler().getReadBuffer();
                        continue;
                    }
                    if (this.dst == SecureNio2Channel.this.getAppReadBufHandler().getByteBuffer()) {
                        SecureNio2Channel.this.getAppReadBufHandler().expand(SecureNio2Channel.this.sslEngine.getSession().getApplicationBufferSize());
                        this.dst = SecureNio2Channel.this.getAppReadBufHandler().getByteBuffer();
                        continue;
                    }
                    throw new ExecutionException(new IOException(sm.getString("channel.nio.ssl.unwrapFailResize", new Object[]{sSLEngineResult.getStatus()})));
                }
                throw new ExecutionException(new IOException(sm.getString("channel.nio.ssl.unwrapFail", new Object[]{sSLEngineResult.getStatus()})));
            } while (SecureNio2Channel.this.netInBuffer.position() != 0);
            if (!this.dst.hasRemaining()) {
                SecureNio2Channel.this.unwrapBeforeRead = true;
            } else {
                SecureNio2Channel.this.unwrapBeforeRead = false;
            }
            return n2;
        }
    }

    private class FutureWrite
    implements Future<Integer> {
        private final ByteBuffer src;
        private Future<Integer> integer = null;
        private int written = 0;
        private Throwable t = null;

        private FutureWrite(ByteBuffer byteBuffer) {
            this.src = byteBuffer;
            if (SecureNio2Channel.this.closing || SecureNio2Channel.this.closed) {
                this.t = new IOException(sm.getString("channel.nio.ssl.closing"));
            } else {
                this.wrap();
            }
        }

        @Override
        public boolean cancel(boolean bl) {
            return this.integer.cancel(bl);
        }

        @Override
        public boolean isCancelled() {
            return this.integer.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.integer.isDone();
        }

        @Override
        public Integer get() throws InterruptedException, ExecutionException {
            if (this.t != null) {
                throw new ExecutionException(this.t);
            }
            if (this.integer.get() > 0 && this.written == 0) {
                this.wrap();
                return this.get();
            }
            if (SecureNio2Channel.this.netOutBuffer.hasRemaining()) {
                this.integer = SecureNio2Channel.this.sc.write(SecureNio2Channel.this.netOutBuffer);
                return this.get();
            }
            return this.written;
        }

        @Override
        public Integer get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.t != null) {
                throw new ExecutionException(this.t);
            }
            if (this.integer.get(l, timeUnit) > 0 && this.written == 0) {
                this.wrap();
                return this.get(l, timeUnit);
            }
            if (SecureNio2Channel.this.netOutBuffer.hasRemaining()) {
                this.integer = SecureNio2Channel.this.sc.write(SecureNio2Channel.this.netOutBuffer);
                return this.get(l, timeUnit);
            }
            return this.written;
        }

        protected void wrap() {
            try {
                if (!SecureNio2Channel.this.netOutBuffer.hasRemaining()) {
                    SecureNio2Channel.this.netOutBuffer.clear();
                    SSLEngineResult sSLEngineResult = SecureNio2Channel.this.sslEngine.wrap(this.src, SecureNio2Channel.this.netOutBuffer);
                    this.written = sSLEngineResult.bytesConsumed();
                    SecureNio2Channel.this.netOutBuffer.flip();
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
                        if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            SecureNio2Channel.this.tasks();
                        }
                    } else {
                        this.t = new IOException(sm.getString("channel.nio.ssl.wrapFail", new Object[]{sSLEngineResult.getStatus()}));
                    }
                }
                this.integer = SecureNio2Channel.this.sc.write(SecureNio2Channel.this.netOutBuffer);
            }
            catch (SSLException sSLException) {
                this.t = sSLException;
            }
        }
    }
}

