/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.ThreadLocalLeakPreventionListener;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.storeconfig.StoreFactoryBase;
import org.apache.catalina.storeconfig.StoreFileMover;
import org.apache.catalina.util.ContextName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.http.CookieProcessor;

public class StandardContextSF
extends StoreFactoryBase {
    private static Log log = LogFactory.getLog(StandardContextSF.class);

    @Override
    public void store(PrintWriter printWriter, int n, Object object) throws Exception {
        StoreDescription storeDescription;
        if (object instanceof StandardContext && (storeDescription = this.getRegistry().findDescription(object.getClass())).isStoreSeparate()) {
            URL uRL = ((StandardContext)object).getConfigFile();
            if (uRL != null) {
                if (storeDescription.isExternalAllowed()) {
                    if (storeDescription.isBackup()) {
                        this.storeWithBackup((StandardContext)object);
                    } else {
                        this.storeContextSeparate(printWriter, n, (StandardContext)object);
                    }
                    return;
                }
            } else if (storeDescription.isExternalOnly()) {
                StandardContext standardContext = (StandardContext)object;
                Host host = (Host)standardContext.getParent();
                File file = host.getConfigBaseFile();
                ContextName contextName = new ContextName(standardContext.getName(), false);
                String string = contextName.getBaseName();
                File file2 = new File(file, string + ".xml");
                standardContext.setConfigFile(file2.toURI().toURL());
                if (storeDescription.isBackup()) {
                    this.storeWithBackup((StandardContext)object);
                } else {
                    this.storeContextSeparate(printWriter, n, (StandardContext)object);
                }
                return;
            }
        }
        super.store(printWriter, n, object);
    }

    protected void storeContextSeparate(PrintWriter printWriter, int n, StandardContext standardContext) throws Exception {
        block14: {
            URL uRL = standardContext.getConfigFile();
            if (uRL != null) {
                File file = new File(uRL.toURI());
                if (!file.isAbsolute()) {
                    file = new File(System.getProperty("catalina.base"), file.getPath());
                }
                if (!file.isFile() || !file.canWrite()) {
                    log.error((Object)("Cannot write context output file at " + uRL + ", not saving."));
                    throw new IOException("Context save file at " + uRL + " not a file, or not writable.");
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Store Context " + standardContext.getPath() + " separate at file " + file));
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);
                     PrintWriter printWriter2 = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, this.getRegistry().getEncoding()));){
                    this.storeXMLHead(printWriter2);
                    super.store(printWriter2, -2, standardContext);
                    break block14;
                }
            }
            super.store(printWriter, n, standardContext);
        }
    }

    protected void storeWithBackup(StandardContext standardContext) throws Exception {
        StoreFileMover storeFileMover = this.getConfigFileWriter((Context)standardContext);
        if (storeFileMover != null) {
            if (storeFileMover.getConfigOld() == null || storeFileMover.getConfigOld().isDirectory() || storeFileMover.getConfigOld().exists() && !storeFileMover.getConfigOld().canWrite()) {
                log.error((Object)("Cannot move orignal context output file at " + storeFileMover.getConfigOld()));
                throw new IOException("Context original file at " + storeFileMover.getConfigOld() + " is null, not a file or not writable.");
            }
            File file = storeFileMover.getConfigSave().getParentFile();
            if (file != null && file.isDirectory() && !file.canWrite()) {
                log.error((Object)("Cannot save context output file at " + storeFileMover.getConfigSave()));
                throw new IOException("Context save file at " + storeFileMover.getConfigSave() + " is not writable.");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Store Context " + standardContext.getPath() + " separate with backup (at file " + storeFileMover.getConfigSave() + " )"));
            }
            try (PrintWriter printWriter = storeFileMover.getWriter();){
                this.storeXMLHead(printWriter);
                super.store(printWriter, -2, standardContext);
            }
            storeFileMover.move();
        }
    }

    protected StoreFileMover getConfigFileWriter(Context context) throws Exception {
        URL uRL = context.getConfigFile();
        StoreFileMover storeFileMover = null;
        if (uRL != null) {
            File file = new File(uRL.toURI());
            if (!file.isAbsolute()) {
                file = new File(System.getProperty("catalina.base"), file.getPath());
            }
            storeFileMover = new StoreFileMover("", file.getCanonicalPath(), this.getRegistry().getEncoding());
        }
        return storeFileMover;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void storeChildren(PrintWriter printWriter, int n, Object object, StoreDescription storeDescription) throws Exception {
        if (object instanceof StandardContext) {
            Realm realm;
            StandardContext standardContext = (StandardContext)object;
            Object[] objectArray = standardContext.findLifecycleListeners();
            ArrayList<LifecycleListener> arrayList = new ArrayList<LifecycleListener>();
            for (LifecycleListener lifecycleListener2 : objectArray) {
                if (lifecycleListener2 instanceof ThreadLocalLeakPreventionListener) continue;
                arrayList.add(lifecycleListener2);
            }
            this.storeElementArray(printWriter, n, arrayList.toArray());
            Object[] objectArray2 = standardContext.getPipeline().getValves();
            this.storeElementArray(printWriter, n, objectArray2);
            Loader loader = standardContext.getLoader();
            this.storeElement(printWriter, n, loader);
            if (standardContext.getCluster() == null || !standardContext.getDistributable()) {
                Manager manager = standardContext.getManager();
                this.storeElement(printWriter, n, manager);
            }
            if ((realm = standardContext.getRealm()) != null) {
                void var11_17;
                Object var11_15 = null;
                if (standardContext.getParent() != null) {
                    Realm realm2 = standardContext.getParent().getRealm();
                }
                if (realm != var11_17) {
                    this.storeElement(printWriter, n, realm);
                }
            }
            WebResourceRoot webResourceRoot = standardContext.getResources();
            this.storeElement(printWriter, n, webResourceRoot);
            String[] stringArray = standardContext.findWrapperLifecycles();
            this.getStoreAppender().printTagArray(printWriter, "WrapperListener", n + 2, stringArray);
            String[] stringArray2 = standardContext.findWrapperListeners();
            this.getStoreAppender().printTagArray(printWriter, "WrapperLifecycle", n + 2, stringArray2);
            Object[] objectArray3 = standardContext.findApplicationParameters();
            this.storeElementArray(printWriter, n, objectArray3);
            NamingResourcesImpl namingResourcesImpl = standardContext.getNamingResources();
            this.storeElement(printWriter, n, namingResourcesImpl);
            String[] stringArray3 = standardContext.findWatchedResources();
            stringArray3 = this.filterWatchedResources(standardContext, stringArray3);
            this.getStoreAppender().printTagArray(printWriter, "WatchedResource", n + 2, stringArray3);
            JarScanner jarScanner = standardContext.getJarScanner();
            this.storeElement(printWriter, n, jarScanner);
            CookieProcessor cookieProcessor = standardContext.getCookieProcessor();
            this.storeElement(printWriter, n, cookieProcessor);
        }
    }

    protected File configBase(Context context) {
        File file = new File(System.getProperty("catalina.base"), "conf");
        Container container = context.getParent();
        if (container instanceof Host) {
            Container container2 = container.getParent();
            if (container2 instanceof Engine) {
                file = new File(file, container2.getName());
            }
            file = new File(file, container.getName());
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                log.error((Object)iOException);
            }
        }
        return file;
    }

    protected String[] filterWatchedResources(StandardContext standardContext, String[] stringArray) throws Exception {
        File file = this.configBase((Context)standardContext);
        String string = new File(System.getProperty("catalina.base"), "conf/context.xml").getCanonicalPath();
        String string2 = new File(System.getProperty("catalina.base"), "conf/web.xml").getCanonicalPath();
        String string3 = new File(file, "context.xml.default").getCanonicalPath();
        String string4 = standardContext.getConfigFile() != null ? new File(standardContext.getConfigFile().toURI()).getCanonicalPath() : null;
        String string5 = "WEB-INF/web.xml";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string6 : stringArray) {
            if (string6.equals(string) || string6.equals(string2) || string6.equals(string3) || string6.equals(string4) || string6.equals(string5)) continue;
            arrayList.add(string6);
        }
        return arrayList.toArray(new String[0]);
    }
}

