/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.slides.SlideOperation;
import org.netbeans.core.windows.view.ui.slides.SlidingFx;
import org.openide.windows.TopComponent;

class SlideOperationImpl
implements SlideOperation,
ChangeListener {
    private final int type;
    private final Component component;
    private final SlidingFx effect;
    private final boolean requestsActivation;
    private final String side;
    protected Rectangle startBounds;
    protected Rectangle finishBounds;
    private JLayeredPane pane;
    private Integer layer;

    SlideOperationImpl(int n, Component component, int n2, SlidingFx slidingFx, boolean bl) {
        this(n, component, SlideOperationImpl.orientation2Side(n2), slidingFx, bl);
    }

    SlideOperationImpl(int n, Component component, String string, SlidingFx slidingFx, boolean bl) {
        this.type = n;
        this.component = component;
        this.effect = slidingFx;
        this.requestsActivation = bl;
        this.side = string;
    }

    @Override
    public void run(JLayeredPane jLayeredPane, Integer n) {
        if (this.effect != null && this.effect.shouldOperationWait()) {
            this.pane = jLayeredPane;
            this.layer = n;
            this.effect.setFinishListener(this);
            this.effect.showEffect(jLayeredPane, n, this);
        } else {
            if (this.effect != null) {
                this.effect.showEffect(jLayeredPane, n, this);
            }
            this.performOperation(jLayeredPane, n);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.performOperation(this.pane, this.layer);
        this.pane = null;
        this.layer = null;
    }

    private void performOperation(JLayeredPane jLayeredPane, Integer n) {
        switch (this.type) {
            case 0: {
                this.component.setBounds(this.finishBounds);
                jLayeredPane.add(this.component, n);
                if (!this.isHeavyWeightShowing()) break;
                this.repaintLayeredPane();
                break;
            }
            case 1: {
                jLayeredPane.remove(this.component);
                break;
            }
            case 4: {
                this.component.setBounds(this.finishBounds);
                ((JComponent)this.component).revalidate();
                if (!this.isHeavyWeightShowing()) break;
                this.repaintLayeredPane();
            }
        }
    }

    @Override
    public void setFinishBounds(Rectangle rectangle) {
        this.finishBounds = rectangle;
    }

    @Override
    public void setStartBounds(Rectangle rectangle) {
        this.startBounds = rectangle;
    }

    @Override
    public String getSide() {
        return this.side;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public Rectangle getFinishBounds() {
        return this.finishBounds;
    }

    @Override
    public Rectangle getStartBounds() {
        return this.startBounds;
    }

    @Override
    public boolean requestsActivation() {
        return this.requestsActivation;
    }

    protected static String orientation2Side(int n) {
        String string = "left";
        if (n == 2) {
            string = "left";
        } else if (n == 1) {
            string = "right";
        } else if (n == 3) {
            string = "bottom";
        } else if (n == 4) {
            string = "top";
        }
        return string;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void prepareEffect() {
        if (this.effect != null) {
            this.effect.prepareEffect(this);
        }
    }

    static int side2Orientation(String string) {
        int n = 2;
        if ("left".equals(string)) {
            n = 2;
        } else if ("right".equals(string)) {
            n = 1;
        } else if ("bottom".equals(string)) {
            n = 3;
        } else if ("top".equals(string)) {
            n = 4;
        }
        return n;
    }

    private void repaintLayeredPane() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JLayeredPane jLayeredPane;
                Frame frame = WindowManagerImpl.getInstance().getMainWindow();
                if (frame instanceof JFrame && null != (jLayeredPane = ((JFrame)frame).getLayeredPane())) {
                    jLayeredPane.invalidate();
                    jLayeredPane.revalidate();
                    jLayeredPane.repaint();
                }
            }
        });
    }

    private boolean isHeavyWeightShowing() {
        for (TopComponent topComponent : TopComponent.getRegistry().getOpened()) {
            if (!topComponent.isShowing() || !this.containsHeavyWeightChild((Container)topComponent)) continue;
            return true;
        }
        return false;
    }

    private boolean containsHeavyWeightChild(Container container) {
        if (!container.isLightweight()) {
            return true;
        }
        for (Component component : container.getComponents()) {
            if (null != component && !component.isLightweight()) {
                return true;
            }
            if (!(component instanceof Container) || !this.containsHeavyWeightChild((Container)component)) continue;
            return true;
        }
        return false;
    }
}

