/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.jfreechart;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.GroupingList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.Comparator;
import java.util.List;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.PieDataset;

public class EventListPieDataset<E, K>
extends AbstractDataset
implements PieDataset {
    private final DatasetChangeEvent immutableChangeEvent = new DatasetChangeEvent((Object)this, (Dataset)this);
    private final EventList sourceList;
    private final GroupingList groupingList;
    private final FunctionList<List, Comparable> keyList;
    private final FunctionList<List, Number> valueList;
    private final ListEventListener datasetEventListener = new DatasetEventListener();

    public EventListPieDataset(EventList<E> source2, FunctionList.Function<E, Comparable<K>> keyFunction, FunctionList.Function<E, Number> valueFunction) {
        this.groupingList = null;
        this.sourceList = source2;
        this.keyList = new FunctionList<E, Comparable<K>>(source2, keyFunction);
        this.valueList = new FunctionList<E, Number>(source2, valueFunction);
        source2.addListEventListener(this.datasetEventListener);
    }

    public EventListPieDataset(EventList<E> source2, Comparator<E> groupingComparator, FunctionList.Function<List<E>, Comparable<K>> keyFunction, FunctionList.Function<List<E>, Number> valueFunction) {
        this.groupingList = new GroupingList<E>(source2, groupingComparator);
        this.sourceList = this.groupingList;
        this.keyList = new FunctionList<List<Comparable>, Comparable<K>>(this.groupingList, keyFunction);
        this.valueList = new FunctionList<List<Number>, Number>(this.groupingList, valueFunction);
        this.groupingList.addListEventListener(this.datasetEventListener);
    }

    public Comparable getKey(int index) {
        return this.keyList.get(index);
    }

    public int getIndex(Comparable key) {
        return this.keyList.indexOf(key);
    }

    public List getKeys() {
        return this.keyList;
    }

    public Number getValue(Comparable key) {
        return this.getValue(this.getIndex(key));
    }

    public int getItemCount() {
        return this.keyList.size();
    }

    public Number getValue(int index) {
        return this.valueList.get(index);
    }

    public void dispose() {
        this.keyList.dispose();
        this.valueList.dispose();
        this.sourceList.removeListEventListener(this.datasetEventListener);
        if (this.groupingList != null) {
            this.groupingList.dispose();
        }
    }

    protected void fireDatasetChanged() {
        this.notifyListeners(this.immutableChangeEvent);
    }

    private class DatasetEventListener
    implements ListEventListener {
        private DatasetEventListener() {
        }

        public void listChanged(ListEvent listChanges) {
            EventListPieDataset.this.fireDatasetChanged();
        }
    }
}

