/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class FtileBlackBlock
extends AbstractFtile {
    private final double labelMargin = 5.0;
    private double width;
    private double height;
    private TextBlock label = TextBlockUtils.empty(0.0, 0.0);
    private final HColor colorBar;
    private final Swimlane swimlane;

    public FtileBlackBlock(ISkinParam skinParam, HColor colorBar, Swimlane swimlane) {
        super(skinParam);
        this.colorBar = colorBar;
        this.swimlane = swimlane;
    }

    public void setBlackBlockDimension(double width, double height) {
        this.height = height;
        this.width = width;
    }

    public void setLabel(TextBlock label) {
        if (label == null) {
            throw new IllegalArgumentException();
        }
        this.label = label;
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        double supp = this.label.calculateDimension(stringBounder).getWidth();
        if (supp > 0.0) {
            supp += 5.0;
        }
        return new FtileGeometry(this.width + supp, this.height, this.width / 2.0, 0.0, this.height);
    }

    @Override
    public void drawU(UGraphic ug) {
        URectangle rect = new URectangle(this.width, this.height).rounded(5.0).ignoreForCompressionOnX();
        if (this.skinParam().shadowing(null)) {
            rect.setDeltaShadow(3.0);
        }
        ug.apply(this.colorBar).apply(this.colorBar.bg()).draw(rect);
        Dimension2D dimLabel = this.label.calculateDimension(ug.getStringBounder());
        this.label.drawU(ug.apply(new UTranslate(this.width + 5.0, -dimLabel.getHeight() / 2.0)));
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }
}

