/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class TextBlockArrow
extends AbstractTextBlock
implements TextBlock {
    private final double size;
    private final Direction arrow;
    private final HColor color;

    public TextBlockArrow(Direction arrow, FontConfiguration fontConfiguration) {
        if (arrow == null) {
            throw new IllegalArgumentException();
        }
        this.arrow = arrow;
        this.size = fontConfiguration.getFont().getSize2D();
        this.color = fontConfiguration.getColor();
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(this.color.bg());
        ug = ug.apply(this.color);
        int triSize = (int)(this.size * 0.8 - 3.0);
        if (triSize % 2 == 1) {
            --triSize;
        }
        UPolygon triangle = this.getTriangle(triSize);
        ug.apply(new UTranslate(2.0, this.size - (double)triSize - 2.0)).draw(triangle);
    }

    private UPolygon getTriangle(int triSize) {
        UPolygon triangle = new UPolygon();
        if (this.arrow == Direction.RIGHT) {
            triangle.addPoint(0.0, 0.0);
            triangle.addPoint(triSize, triSize / 2);
            triangle.addPoint(0.0, triSize);
            triangle.addPoint(0.0, 0.0);
        } else if (this.arrow == Direction.LEFT) {
            triangle.addPoint(triSize, 0.0);
            triangle.addPoint(0.0, triSize / 2);
            triangle.addPoint(triSize, triSize);
            triangle.addPoint(triSize, 0.0);
        } else if (this.arrow == Direction.UP) {
            triangle.addPoint(0.0, triSize);
            triangle.addPoint(triSize / 2, 0.0);
            triangle.addPoint(triSize, triSize);
            triangle.addPoint(0.0, triSize);
        } else if (this.arrow == Direction.DOWN) {
            triangle.addPoint(0.0, 0.0);
            triangle.addPoint(triSize / 2, triSize);
            triangle.addPoint(triSize, 0.0);
            triangle.addPoint(0.0, 0.0);
        } else {
            throw new IllegalStateException();
        }
        return triangle;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.size, this.size);
    }
}

