/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.timescale;

import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.project.timescale.TimeScaleDaily;

public class TimeScaleCompressed
implements TimeScale {
    private final int compress;
    private final TimeScale daily;

    public TimeScaleCompressed(Day calendar, int compress) {
        this.daily = new TimeScaleDaily(calendar, null);
        this.compress = compress;
    }

    @Override
    public double getStartingPosition(Day instant) {
        return this.daily.getStartingPosition(instant) / (double)this.compress;
    }

    @Override
    public double getEndingPosition(Day instant) {
        return this.daily.getEndingPosition(instant) / (double)this.compress;
    }

    @Override
    public double getWidth(Day instant) {
        return this.daily.getWidth(instant) / (double)this.compress;
    }

    @Override
    public boolean isBreaking(Day instant) {
        return instant.getDayOfWeek() == DayOfWeek.SUNDAY;
    }
}

