# -*- coding: utf-8 -*-
info = {
    "name": "tr",
    "date_order": "DMY",
    "january": [
        "ocak",
        "oca",
        "Oc"
    ],
    "february": [
        "şubat",
        "şub",
        "Şu"
    ],
    "march": [
        "mart",
        "mar"
    ],
    "april": [
        "nisan",
        "nis",
        "Ni"
    ],
    "may": [
        "mayıs",
        "may"
    ],
    "june": [
        "haziran",
        "haz",
        "Ha"
    ],
    "july": [
        "temmuz",
        "tem",
        "Te"
    ],
    "august": [
        "ağustos",
        "ağu",
        "Ağ"
    ],
    "september": [
        "eylül",
        "eyl",
        "Ey"
    ],
    "october": [
        "ekim",
        "eki",
        "Ek"
    ],
    "november": [
        "kasım",
        "kas",
        "Ka"
    ],
    "december": [
        "aralık",
        "ara",
        "Ar"
    ],
    "monday": [
        "pazartesi",
        "pzt"
    ],
    "tuesday": [
        "salı",
        "sal"
    ],
    "wednesday": [
        "çarşamba",
        "çar",
        "Çrs"
    ],
    "thursday": [
        "perşembe",
        "per",
        "Prs"
    ],
    "friday": [
        "cuma",
        "cum"
    ],
    "saturday": [
        "cumartesi",
        "cmt"
    ],
    "sunday": [
        "pazar",
        "paz"
    ],
    "am": [
        "öö"
    ],
    "pm": [
        "ös"
    ],
    "year": [
        "yıl",
        "sene"
    ],
    "month": [
        "ay"
    ],
    "week": [
        "hafta",
        "hf"
    ],
    "day": [
        "gün"
    ],
    "hour": [
        "saat",
        "sa"
    ],
    "minute": [
        "dakika",
        "dk"
    ],
    "second": [
        "saniye",
        "sn"
    ],
    "relative-type": {
        "1 year ago": [
            "geçen yıl"
        ],
        "0 year ago": [
            "bu yıl"
        ],
        "in 1 year": [
            "gelecek yıl",
            "önümüzdeki yıl"
        ],
        "1 month ago": [
            "geçen ay"
        ],
        "0 month ago": [
            "bu ay"
        ],
        "in 1 month": [
            "gelecek ay",
            "önümüzdeki ay"
        ],
        "1 week ago": [
            "geçen hafta"
        ],
        "0 week ago": [
            "bu hafta"
        ],
        "in 1 week": [
            "gelecek hafta",
            "haftaya",
            "önümüzdeki hafta"
        ],
        "1 day ago": [
            "dün",
            "geçen gün"
        ],
        "0 day ago": [
            "bugün"
        ],
        "in 1 day": [
            "yarın",
            "önümüzdeki gün"
        ],
        "0 hour ago": [
            "bu saat"
        ],
        "0 minute ago": [
            "bu dakika"
        ],
        "0 second ago": [
            "şimdi"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "(\\d+) yıl sonra"
        ],
        "\\1 year ago": [
            "(\\d+) yıl önce"
        ],
        "in \\1 month": [
            "(\\d+) ay sonra"
        ],
        "\\1 month ago": [
            "(\\d+) ay önce"
        ],
        "in \\1 week": [
            "(\\d+) hafta sonra",
            "(\\d+) hf sonra"
        ],
        "\\1 week ago": [
            "(\\d+) hafta önce",
            "(\\d+) hf önce"
        ],
        "in \\1 day": [
            "(\\d+) gün sonra"
        ],
        "\\1 day ago": [
            "(\\d+) gün önce"
        ],
        "in \\1 hour": [
            "(\\d+) saat sonra",
            "(\\d+) sa sonra"
        ],
        "\\1 hour ago": [
            "(\\d+) saat önce",
            "(\\d+) sa önce"
        ],
        "in \\1 minute": [
            "(\\d+) dakika sonra",
            "(\\d+) dk sonra"
        ],
        "\\1 minute ago": [
            "(\\d+) dakika önce",
            "(\\d+) dk önce"
        ],
        "in \\1 second": [
            "(\\d+) saniye sonra",
            "(\\d+) sn sonra"
        ],
        "\\1 second ago": [
            "(\\d+) saniye önce",
            "(\\d+) sn önce"
        ]
    },
    "locale_specific": {
        "tr-CY": {
            "name": "tr-CY"
        }
    },
    "skip": [
        "yaklaşık",
        "ve",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "önce"
    ],
    "in": [
        "içerisinde",
        "içinde",
        "sonra"
    ]
}
