/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class TrainUnitInEuropeMessage
extends DOMMessage {
    private final String typeId;

    public TrainUnitInEuropeMessage(UnitType type) {
        super(TrainUnitInEuropeMessage.getXMLElementTagName());
        this.typeId = type.getId();
    }

    public TrainUnitInEuropeMessage(Game game, Element element) {
        super(TrainUnitInEuropeMessage.getXMLElementTagName());
        this.typeId = element.getAttribute("unitType");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        ServerPlayer serverPlayer = server.getPlayer(connection);
        UnitType type = server.getSpecification().getUnitType(this.typeId);
        if (type == null) {
            return DOMMessage.clientError("Not a unit type: " + this.typeId);
        }
        return server.getInGameController().trainUnitInEurope(serverPlayer, type);
    }

    @Override
    public Element toXMLElement() {
        return TrainUnitInEuropeMessage.createMessage(TrainUnitInEuropeMessage.getXMLElementTagName(), "unitType", this.typeId);
    }

    public static String getXMLElementTagName() {
        return "trainUnitInEurope";
    }
}

