/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.spi.AbstractRegistryEntry;
import org.apache.batik.ext.awt.image.spi.StreamRegistryEntry;
import org.apache.batik.util.ParsedURL;

public abstract class MagicNumberRegistryEntry
extends AbstractRegistryEntry
implements StreamRegistryEntry {
    public static final float PRIORITY = 1000.0f;
    MagicNumber[] magicNumbers;

    public MagicNumberRegistryEntry(String name, float priority, String ext, String mimeType, int offset, byte[] magicNumber) {
        super(name, priority, ext, mimeType);
        this.magicNumbers = new MagicNumber[1];
        this.magicNumbers[0] = new MagicNumber(offset, magicNumber);
    }

    public MagicNumberRegistryEntry(String name, String ext, String mimeType, int offset, byte[] magicNumber) {
        this(name, 1000.0f, ext, mimeType, offset, magicNumber);
    }

    public MagicNumberRegistryEntry(String name, float priority, String ext, String mimeType, MagicNumber[] magicNumbers) {
        super(name, priority, ext, mimeType);
        this.magicNumbers = magicNumbers;
    }

    public MagicNumberRegistryEntry(String name, String ext, String mimeType, MagicNumber[] magicNumbers) {
        this(name, 1000.0f, ext, mimeType, magicNumbers);
    }

    public MagicNumberRegistryEntry(String name, float priority, String[] exts, String[] mimeTypes, int offset, byte[] magicNumber) {
        super(name, priority, exts, mimeTypes);
        this.magicNumbers = new MagicNumber[1];
        this.magicNumbers[0] = new MagicNumber(offset, magicNumber);
    }

    public MagicNumberRegistryEntry(String name, String[] exts, String[] mimeTypes, int offset, byte[] magicNumbers) {
        this(name, 1000.0f, exts, mimeTypes, offset, magicNumbers);
    }

    public MagicNumberRegistryEntry(String name, float priority, String[] exts, String[] mimeTypes, MagicNumber[] magicNumbers) {
        super(name, priority, exts, mimeTypes);
        this.magicNumbers = magicNumbers;
    }

    public MagicNumberRegistryEntry(String name, String[] exts, String[] mimeTypes, MagicNumber[] magicNumbers) {
        this(name, 1000.0f, exts, mimeTypes, magicNumbers);
    }

    public MagicNumberRegistryEntry(String name, String[] exts, String[] mimeTypes, MagicNumber[] magicNumbers, float priority) {
        super(name, priority, exts, mimeTypes);
        this.magicNumbers = magicNumbers;
    }

    public int getReadlimit() {
        int maxbuf = 0;
        int i = 0;
        while (i < this.magicNumbers.length) {
            int req = this.magicNumbers[i].getReadlimit();
            if (req > maxbuf) {
                maxbuf = req;
            }
            ++i;
        }
        return maxbuf;
    }

    public boolean isCompatibleStream(InputStream is) throws StreamCorruptedException {
        int i = 0;
        while (i < this.magicNumbers.length) {
            if (this.magicNumbers[i].isMatch(is)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract Filter handleStream(InputStream var1, ParsedURL var2, boolean var3);

    public static class MagicNumber {
        int offset;
        byte[] magicNumber;
        byte[] buffer;

        public MagicNumber(int offset, byte[] magicNumber) {
            this.offset = offset;
            this.magicNumber = (byte[])magicNumber.clone();
            this.buffer = new byte[magicNumber.length];
        }

        int getReadlimit() {
            return this.offset + this.magicNumber.length;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean isMatch(InputStream is) throws StreamCorruptedException {
            boolean bl;
            block18: {
                int idx = 0;
                is.mark(this.getReadlimit());
                try {
                    try {
                        int i;
                        int rn;
                        while (true) {
                            if (idx >= this.offset) break;
                            rn = (int)is.skip(this.offset - idx);
                            if (rn == -1) {
                                bl = false;
                                Object var6_9 = null;
                                break block18;
                            }
                            idx += rn;
                        }
                        idx = 0;
                        while (true) {
                            if (idx >= this.buffer.length) {
                                i = 0;
                                break;
                            }
                            rn = is.read(this.buffer, idx, this.buffer.length - idx);
                            if (rn == -1) {
                                boolean bl2 = false;
                                Object var6_10 = null;
                                try {
                                    is.reset();
                                    return bl2;
                                }
                                catch (IOException ioe2) {
                                    throw new StreamCorruptedException(ioe2.getMessage());
                                }
                            }
                            idx += rn;
                        }
                        while (i < this.magicNumber.length) {
                            if (this.magicNumber[i] != this.buffer[i]) {
                                boolean bl3 = false;
                                Object var6_11 = null;
                                try {}
                                catch (IOException ioe2) {
                                    throw new StreamCorruptedException(ioe2.getMessage());
                                }
                                is.reset();
                                return bl3;
                            }
                            ++i;
                        }
                    }
                    catch (IOException ioe) {
                        boolean bl4 = false;
                        Object var6_13 = null;
                        try {}
                        catch (IOException ioe2) {
                            throw new StreamCorruptedException(ioe2.getMessage());
                        }
                        is.reset();
                        return bl4;
                    }
                    Object var6_12 = null;
                    try {}
                    catch (IOException ioe2) {
                        throw new StreamCorruptedException(ioe2.getMessage());
                    }
                    is.reset();
                    return true;
                }
                catch (Throwable throwable) {
                    Object var6_14 = null;
                    try {}
                    catch (IOException ioe2) {
                        throw new StreamCorruptedException(ioe2.getMessage());
                    }
                    is.reset();
                    throw throwable;
                }
            }
            try {}
            catch (IOException ioe2) {
                throw new StreamCorruptedException(ioe2.getMessage());
            }
            is.reset();
            return bl;
        }
    }
}

