/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.tools.plugin;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.tools.spi.MouseClickEventListener;
import org.gephi.tools.spi.Tool;
import org.gephi.tools.spi.ToolEventListener;
import org.gephi.tools.spi.ToolSelectionType;
import org.gephi.tools.spi.ToolUI;
import org.gephi.ui.tools.plugin.NodePencilPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class NodePencil
implements Tool {
    private ToolEventListener[] listeners;
    private NodePencilPanel nodePencilPanel;
    private Color color = new Color(153, 153, 153);
    private float size = 10.0f;

    public void select() {
    }

    public void unselect() {
        this.listeners = null;
        this.nodePencilPanel = null;
    }

    public ToolEventListener[] getListeners() {
        this.listeners = new ToolEventListener[1];
        this.listeners[0] = new MouseClickEventListener(){

            public void mouseClick(int[] positionViewport, float[] position3d) {
                NodePencil.this.color = NodePencil.this.nodePencilPanel.getColor();
                NodePencil.this.size = NodePencil.this.nodePencilPanel.getNodeSize();
                GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
                GraphModel gm = gc.getGraphModel();
                Graph graph = gm.getGraph();
                Node node = gm.factory().newNode();
                node.setX(position3d[0]);
                node.setY(position3d[1]);
                node.setSize(NodePencil.this.size);
                node.setColor(NodePencil.this.color);
                graph.addNode(node);
            }
        };
        return this.listeners;
    }

    public ToolUI getUI() {
        return new ToolUI(){

            public JPanel getPropertiesBar(Tool tool) {
                NodePencil.this.nodePencilPanel = new NodePencilPanel();
                NodePencil.this.nodePencilPanel.setColor(NodePencil.this.color);
                NodePencil.this.nodePencilPanel.setNodeSize(NodePencil.this.size);
                return NodePencil.this.nodePencilPanel;
            }

            public String getName() {
                return NbBundle.getMessage(NodePencil.class, (String)"NodePencil.name");
            }

            public Icon getIcon() {
                return new ImageIcon(this.getClass().getResource("/org/gephi/tools/plugin/resources/nodepencil.png"));
            }

            public String getDescription() {
                return NbBundle.getMessage(NodePencil.class, (String)"NodePencil.description");
            }

            public int getPosition() {
                return 120;
            }
        };
    }

    public ToolSelectionType getSelectionType() {
        return ToolSelectionType.NONE;
    }
}

