/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.function.SingleNumericParameterFunction;
import tim.prune.undo.UndoInterpolate;
import tim.prune.undo.UndoOperation;

public class InterpolateFunction
extends SingleNumericParameterFunction {
    public InterpolateFunction(App app) {
        super(app, 1, 1000);
    }

    @Override
    public String getNameKey() {
        return "function.interpolate";
    }

    @Override
    public String getDescriptionKey() {
        return "dialog.interpolate.parameter.text";
    }

    @Override
    public int getCurrentParamValue() {
        return 0;
    }

    @Override
    public void begin() {
    }

    @Override
    public void completeFunction(int n) {
        Object object;
        int n2;
        int n3 = this._app.getTrackInfo().getSelection().getStart();
        int n4 = this._app.getTrackInfo().getSelection().getEnd();
        boolean bl = false;
        if (!InterpolateFunction.selectedRangeHasTrackpoints(this._app.getTrackInfo().getTrack(), n3, n4)) {
            n2 = JOptionPane.showConfirmDialog(this._parentFrame, I18nManager.getText("dialog.interpolate.betweenwaypoints"), I18nManager.getText(this.getNameKey()), 0);
            if (n2 == 1) {
                return;
            }
            bl = true;
        }
        if (n3 < 0 || n4 < 0 || n4 <= n3) {
            return;
        }
        n2 = n;
        Track track = this._app.getTrackInfo().getTrack();
        int n5 = (n4 - n3) * n2;
        int n6 = track.getNumPoints() + n5;
        DataPoint[] dataPointArray = track.cloneContents();
        DataPoint[] dataPointArray2 = new DataPoint[n6];
        System.arraycopy(dataPointArray, 0, dataPointArray2, 0, n3);
        int n7 = n3;
        DataPoint dataPoint = null;
        int n8 = n3;
        while (n8 <= n4) {
            DataPoint dataPoint2 = this._app.getTrackInfo().getTrack().getPoint(n8);
            if (dataPoint != null && (dataPoint2.isWaypoint() && bl || !dataPoint2.isWaypoint() && !dataPoint2.getSegmentStart())) {
                object = dataPoint.interpolate(dataPoint2, n2);
                System.arraycopy(object, 0, dataPointArray2, n7, n2);
                n7 += n2;
            }
            dataPointArray2[n7] = dataPoint2;
            ++n7;
            if (!dataPoint2.isWaypoint() || bl) {
                dataPoint = dataPoint2;
            } else if (!dataPoint2.isWaypoint()) {
                dataPoint = null;
            }
            ++n8;
        }
        n8 = n7 - n4 - 1;
        System.arraycopy(dataPointArray, n4, dataPointArray2, n7 - 1, track.getNumPoints() - n4);
        int n9 = track.getNumPoints() + n8;
        if (n9 != dataPointArray2.length) {
            object = new DataPoint[n9];
            System.arraycopy(dataPointArray2, 0, object, 0, n9);
            dataPointArray2 = object;
        }
        object = new UndoInterpolate(this._app.getTrackInfo(), n8);
        if (track.replaceContents(dataPointArray2)) {
            String string = I18nManager.getTextWithNumber("confirm.pointsadded", n8);
            this._app.completeFunction((UndoOperation)object, string);
            this._app.getTrackInfo().getSelection().selectRange(n3, n4 + n8);
        }
    }

    private static boolean selectedRangeHasTrackpoints(Track track, int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            DataPoint dataPoint = track.getPoint(n3);
            if (dataPoint != null && !dataPoint.isWaypoint()) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

