/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.function.search.SearchResult;

public class SearchOsmPoisXmlHandler
extends DefaultHandler {
    private ArrayList<SearchResult> _pointList = null;
    private SearchResult _currPoint = null;
    private String _errorMessage = null;

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("osm")) {
            this._pointList = new ArrayList();
        } else if (string3.equals("node")) {
            this._currPoint = new SearchResult();
            this._currPoint.setLatitude(attributes.getValue("lat"));
            this._currPoint.setLongitude(attributes.getValue("lon"));
        } else if (string3.equals("tag") && this._currPoint != null) {
            this.processTag(attributes);
        }
        super.startElement(string, string2, string3, attributes);
    }

    private void processTag(Attributes attributes) {
        String string = attributes.getValue("k");
        if (string != null) {
            String string2 = attributes.getValue("v");
            if (string.equals("name")) {
                this._currPoint.setTrackName(string2);
            } else if (string.equals("amenity") || string.equals("highway") || string.equals("railway")) {
                this._currPoint.setPointType(string2);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("node") && this._currPoint.getTrackName() != null && !this._currPoint.getTrackName().equals("")) {
            this._pointList.add(this._currPoint);
        }
        super.endElement(string, string2, string3);
    }

    public ArrayList<SearchResult> getPointList() {
        return this._pointList;
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }
}

