/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.autoplay;

import tim.prune.data.DataPoint;
import tim.prune.data.Timestamp;

public class PointInfo
implements Comparable<PointInfo> {
    private Timestamp _timestamp = null;
    private int _pointIndex = 0;
    private boolean _segmentFlag = false;

    public PointInfo(DataPoint dataPoint, int n) {
        if (dataPoint.hasTimestamp()) {
            this._timestamp = dataPoint.getTimestamp();
        } else if (dataPoint.getPhoto() != null && dataPoint.getPhoto().hasTimestamp()) {
            this._timestamp = dataPoint.getPhoto().getTimestamp();
        }
        this._pointIndex = n;
        this._segmentFlag = dataPoint.getSegmentStart();
    }

    public Timestamp getTimestamp() {
        return this._timestamp;
    }

    public int getIndex() {
        return this._pointIndex;
    }

    public boolean getSegmentFlag() {
        return this._segmentFlag;
    }

    @Override
    public int compareTo(PointInfo pointInfo) {
        boolean bl;
        long l = 0L;
        boolean bl2 = this._timestamp != null;
        boolean bl3 = bl = pointInfo._timestamp != null;
        if (bl2 && bl) {
            l = this._timestamp.getMillisecondsSince(pointInfo._timestamp);
        } else if (bl2) {
            l = -1L;
        } else if (bl) {
            l = 1L;
        }
        if (l == 0L) {
            return this._pointIndex - pointInfo._pointIndex;
        }
        return l < 0L ? -1 : 1;
    }

    public boolean equals(Object object) {
        PointInfo pointInfo;
        block8: {
            boolean bl;
            boolean bl2;
            block7: {
                block6: {
                    if (object == null) {
                        return false;
                    }
                    try {
                        pointInfo = (PointInfo)object;
                        if (this._pointIndex == pointInfo._pointIndex) break block6;
                        return false;
                    }
                    catch (ClassCastException classCastException) {
                        return false;
                    }
                }
                bl2 = this._timestamp != null;
                boolean bl3 = bl = pointInfo._timestamp != null;
                if (bl2 == bl) break block7;
                return false;
            }
            if (bl2 || bl) break block8;
            return true;
        }
        return this._timestamp.isEqual(pointInfo._timestamp);
    }
}

