/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.colour;

import java.awt.Color;
import tim.prune.gui.colour.PointColourer;

public abstract class DiscretePointColourer
extends PointColourer {
    private Color[] _discreteColours = null;
    private int[] _colourIndexes = null;

    public DiscretePointColourer(Color color, Color color2, int n) {
        super(color, color2, n);
    }

    public static boolean isMaxColoursRequired() {
        return true;
    }

    protected void init(int n) {
        if (this._colourIndexes == null || this._colourIndexes.length != n) {
            this._colourIndexes = (int[])(n > 0 ? new int[n] : null);
        }
    }

    protected void setColour(int n, int n2) {
        if (this._colourIndexes != null && this._colourIndexes.length > n && n >= 0) {
            this._colourIndexes[n] = n2;
        }
    }

    @Override
    public Color getColour(int n) {
        int n2;
        if (this._colourIndexes != null && this._colourIndexes.length > n && n >= 0 && this.getMaxColours() > 0 && (n2 = this._colourIndexes[n] % this.getMaxColours()) >= 0 && this._discreteColours != null && n2 < this._discreteColours.length) {
            return this._discreteColours[n2];
        }
        return super.getDefaultColour();
    }

    protected void generateDiscreteColours(int n) {
        int n2 = this.getMaxColours();
        if (n2 <= 1) {
            n2 = 2;
        }
        if (n < 1) {
            n = 1;
        } else if (n > n2) {
            n = n2;
        }
        this._discreteColours = new Color[n];
        int n3 = 0;
        while (n3 < n) {
            this._discreteColours[n3] = this.mixColour(n3, n);
            ++n3;
        }
    }

    private Color mixColour(int n, int n2) {
        float f = n2 < 2 ? 0.0f : (float)n / (float)(n2 - 1);
        return this.mixColour(f);
    }

    protected Color getDiscreteColour(int n) {
        if (this._discreteColours == null || n < 0 || this.getMaxColours() <= 1) {
            return this.getDefaultColour();
        }
        return this._discreteColours[n % this.getMaxColours()];
    }
}

