/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.field;

import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.solr.analytics.function.field.AnalyticsField;
import org.apache.solr.analytics.value.StringValueStream;

public class StringMultiField
extends AnalyticsField
implements StringValueStream.CastingStringValueStream {
    private SortedSetDocValues docValues;
    private ArrayList<String> values = new ArrayList(20);

    public StringMultiField(String fieldName) {
        super(fieldName);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = DocValues.getSortedSet((LeafReader)context.reader(), (String)this.fieldName);
    }

    @Override
    public void collect(int doc) throws IOException {
        this.values.clear();
        if (this.docValues.advanceExact(doc)) {
            int term;
            while ((long)(term = (int)this.docValues.nextOrd()) != -1L) {
                this.values.add(this.docValues.lookupOrd((long)term).utf8ToString());
            }
        }
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        this.values.forEach(value -> cons.accept((String)value));
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        this.values.forEach(value -> cons.accept(value));
    }
}

