/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.List;
import org.apache.lucene.util.PriorityQueue;
import org.apache.solr.cloud.DistributedMap;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class SizeLimitedDistributedMap
extends DistributedMap {
    private final int maxSize;
    private final OnOverflowObserver onOverflowObserver;

    public SizeLimitedDistributedMap(SolrZkClient zookeeper, String dir, int maxSize) {
        this(zookeeper, dir, maxSize, null);
    }

    public SizeLimitedDistributedMap(SolrZkClient zookeeper, String dir, int maxSize, OnOverflowObserver onOverflowObserver) {
        super(zookeeper, dir);
        this.maxSize = maxSize;
        this.onOverflowObserver = onOverflowObserver;
    }

    @Override
    public void put(String trackingId, byte[] data) throws KeeperException, InterruptedException {
        if (this.size() >= this.maxSize) {
            List children = this.zookeeper.getChildren(this.dir, null, true);
            int cleanupSize = this.maxSize / 10;
            PriorityQueue<Long> priorityQueue = new PriorityQueue<Long>(cleanupSize){

                protected boolean lessThan(Long a, Long b) {
                    return a > b;
                }
            };
            for (String child : children) {
                Stat stat = this.zookeeper.exists(this.dir + "/" + child, null, true);
                priorityQueue.insertWithOverflow((Object)stat.getMzxid());
            }
            long topElementMzxId = (Long)priorityQueue.top();
            for (String child : children) {
                Stat stat = this.zookeeper.exists(this.dir + "/" + child, null, true);
                if (stat.getMzxid() > topElementMzxId) continue;
                this.zookeeper.delete(this.dir + "/" + child, -1, true);
                if (this.onOverflowObserver == null) continue;
                this.onOverflowObserver.onChildDelete(child.substring("mn-".length()));
            }
        }
        super.put(trackingId, data);
    }

    static interface OnOverflowObserver {
        public void onChildDelete(String var1) throws KeeperException, InterruptedException;
    }
}

