/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.FilenameUtils;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.ScriptEngineCustomizer;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessScriptUpdateProcessorFactory
extends UpdateRequestProcessorFactory
implements SolrCoreAware {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SCRIPT_ARG = "script";
    private static final String PARAMS_ARG = "params";
    private static final String ENGINE_NAME_ARG = "engine";
    private List<ScriptFile> scriptFiles;
    private String engineName = null;
    private Object params = null;
    private SolrResourceLoader resourceLoader;
    private ScriptEngineCustomizer scriptEngineCustomizer;
    private static final AccessControlContext SCRIPT_SANDBOX = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)});

    @Override
    public void init(NamedList args) {
        Collection scripts = args.removeConfigArgs(SCRIPT_ARG);
        if (scripts.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "StatelessScriptUpdateProcessorFactory must be initialized with at least one script");
        }
        this.scriptFiles = new ArrayList<ScriptFile>();
        for (String script : scripts) {
            this.scriptFiles.add(new ScriptFile(script));
        }
        this.params = args.remove(PARAMS_ARG);
        Object engine = args.remove(ENGINE_NAME_ARG);
        if (engine != null) {
            if (engine instanceof String) {
                this.engineName = (String)engine;
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'engine' init param must be a String (found: " + engine.getClass() + ")");
            }
        }
        super.init(args);
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        List<EngineInfo> scriptEngines = null;
        scriptEngines = this.initEngines(req, rsp);
        return new ScriptUpdateProcessor(req, rsp, scriptEngines, next);
    }

    void setScriptEngineCustomizer(ScriptEngineCustomizer scriptEngineCustomizer) {
        this.scriptEngineCustomizer = scriptEngineCustomizer;
    }

    @Override
    public void inform(SolrCore core) {
        if (!core.getCoreDescriptor().isConfigSetTrusted()) {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "The configset for this collection was uploaded without any authentication in place, and this operation is not available for collections with untrusted configsets. To use this component, re-upload the configset after enabling authentication and authorization.");
        }
        this.resourceLoader = core.getResourceLoader();
        SolrQueryResponse rsp = new SolrQueryResponse();
        try (LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());){
            this.initEngines(req, rsp);
        }
    }

    private List<EngineInfo> initEngines(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        ArrayList<EngineInfo> scriptEngines = new ArrayList<EngineInfo>();
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager(this.resourceLoader.getClassLoader());
        scriptEngineManager.put("logger", log);
        scriptEngineManager.put("req", req);
        scriptEngineManager.put("rsp", rsp);
        if (this.params != null) {
            scriptEngineManager.put(PARAMS_ARG, this.params);
        }
        for (ScriptFile scriptFile : this.scriptFiles) {
            String details;
            ScriptEngine engine;
            if (null != this.engineName) {
                engine = scriptEngineManager.getEngineByName(this.engineName);
                if (engine == null) {
                    details = StatelessScriptUpdateProcessorFactory.getSupportedEngines(scriptEngineManager, false);
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No ScriptEngine found by name: " + this.engineName + (null != details ? " -- supported names: " + details : ""));
                }
            } else {
                engine = scriptEngineManager.getEngineByExtension(scriptFile.getExtension());
                if (engine == null) {
                    details = StatelessScriptUpdateProcessorFactory.getSupportedEngines(scriptEngineManager, true);
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No ScriptEngine found by file extension: " + scriptFile.getFileName() + (null != details ? " -- supported extensions: " + details : ""));
                }
            }
            if (!(engine instanceof Invocable)) {
                String msg = "Engine " + (null != this.engineName ? this.engineName : "for script " + scriptFile.getFileName()) + " does not support function invocation (via Invocable): " + engine.getClass().toString() + " (" + engine.getFactory().getEngineName() + ")";
                log.error(msg);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
            }
            if (this.scriptEngineCustomizer != null) {
                this.scriptEngineCustomizer.customize(engine);
            }
            scriptEngines.add(new EngineInfo((Invocable)((Object)engine), scriptFile));
            try {
                final Reader scriptSrc = scriptFile.openReader(this.resourceLoader);
                try {
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws ScriptException {
                                engine.eval(scriptSrc);
                                return null;
                            }
                        }, SCRIPT_SANDBOX);
                    }
                    catch (PrivilegedActionException e) {
                        throw (ScriptException)e.getException();
                    }
                }
                catch (ScriptException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to evaluate script: " + scriptFile.getFileName(), (Throwable)e);
                }
                finally {
                    org.apache.commons.io.IOUtils.closeQuietly((Reader)scriptSrc);
                }
            }
            catch (IOException ioe) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to evaluate script: " + scriptFile.getFileName(), (Throwable)ioe);
            }
        }
        return scriptEngines;
    }

    private static String getSupportedEngines(ScriptEngineManager mgr, boolean ext) {
        String result = null;
        try {
            List<ScriptEngineFactory> factories = mgr.getEngineFactories();
            if (null == factories) {
                return result;
            }
            LinkedHashSet<String> engines = new LinkedHashSet<String>(factories.size());
            for (ScriptEngineFactory f : factories) {
                if (ext) {
                    engines.addAll(f.getExtensions());
                    continue;
                }
                engines.addAll(f.getNames());
            }
            result = String.join((CharSequence)", ", engines);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return result;
    }

    private static class ScriptFile {
        private final String fileName;
        private final String extension;

        private ScriptFile(String fileName) {
            this.fileName = fileName;
            this.extension = FilenameUtils.getExtension((String)fileName);
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getExtension() {
            return this.extension;
        }

        public Reader openReader(SolrResourceLoader resourceLoader) throws IOException {
            InputStream input = resourceLoader.openResource(this.fileName);
            return IOUtils.getDecodingReader((InputStream)input, (Charset)StandardCharsets.UTF_8);
        }
    }

    private static class ScriptUpdateProcessor
    extends UpdateRequestProcessor {
        private List<EngineInfo> engines;

        private ScriptUpdateProcessor(SolrQueryRequest req, SolrQueryResponse res, List<EngineInfo> engines, UpdateRequestProcessor next) {
            super(next);
            this.engines = engines;
        }

        @Override
        public void processAdd(AddUpdateCommand cmd) throws IOException {
            if (this.invokeFunction("processAdd", cmd)) {
                super.processAdd(cmd);
            }
        }

        @Override
        public void processDelete(DeleteUpdateCommand cmd) throws IOException {
            if (this.invokeFunction("processDelete", cmd)) {
                super.processDelete(cmd);
            }
        }

        @Override
        public void processMergeIndexes(MergeIndexesCommand cmd) throws IOException {
            if (this.invokeFunction("processMergeIndexes", cmd)) {
                super.processMergeIndexes(cmd);
            }
        }

        @Override
        public void processCommit(CommitUpdateCommand cmd) throws IOException {
            if (this.invokeFunction("processCommit", cmd)) {
                super.processCommit(cmd);
            }
        }

        @Override
        public void processRollback(RollbackUpdateCommand cmd) throws IOException {
            if (this.invokeFunction("processRollback", cmd)) {
                super.processRollback(cmd);
            }
        }

        @Override
        public void finish() throws IOException {
            if (this.invokeFunction("finish", new Object[0])) {
                super.finish();
            }
        }

        private boolean invokeFunction(final String name, final Object ... cmd) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return this.invokeFunctionUnsafe(name, cmd);
                }
            }, SCRIPT_SANDBOX);
        }

        private boolean invokeFunctionUnsafe(String name, Object ... cmd) {
            for (EngineInfo engine : this.engines) {
                try {
                    Object result = engine.getEngine().invokeFunction(name, cmd);
                    if (null == result || !(result instanceof Boolean) || ((Boolean)result).booleanValue()) continue;
                    return false;
                }
                catch (NoSuchMethodException | ScriptException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to invoke function " + name + " in script: " + engine.getScriptFile().getFileName() + ": " + e.getMessage(), (Throwable)e);
                }
            }
            return true;
        }
    }

    private static class EngineInfo {
        private final Invocable engine;
        private final ScriptFile scriptFile;

        private EngineInfo(Invocable engine, ScriptFile scriptFile) {
            this.engine = engine;
            this.scriptFile = scriptFile;
        }

        public Invocable getEngine() {
            return this.engine;
        }

        public ScriptFile getScriptFile() {
            return this.scriptFile;
        }
    }
}

