/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Bounds;
import javax.media.j3d.NodeComponentRetained;
import javax.vecmath.Point2f;

class AuralAttributesRetained
extends NodeComponentRetained {
    float attributeGain = 1.0f;
    float rolloff = 1.0f;
    static final float SPEED_OF_SOUND = 0.344f;
    float reflectionCoefficient = 0.0f;
    float reverbCoefficient = 1.0f;
    float reflectionDelay = 20.0f;
    float reverbDelay = 40.0f;
    Bounds reverbBounds = null;
    float decayTime = 1000.0f;
    float decayFilter = 5000.0f;
    float diffusion = 1.0f;
    float density = 1.0f;
    int reverbOrder = 0;
    static final int NO_FILTERING = -1;
    static final int LOW_PASS = 1;
    int filterType = -1;
    float[] distance = null;
    float[] frequencyCutoff = null;
    float frequencyScaleFactor = 1.0f;
    float velocityScaleFactor = 0.0f;
    boolean aaDirty = true;
    AuralAttributesRetained mirrorAa = null;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    AuralAttributesRetained() {
    }

    void debugPrint(String string) {
    }

    void setAttributeGain(float f) {
        this.attributeGain = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getAttributeGain() {
        return this.attributeGain;
    }

    void setRolloff(float f) {
        this.rolloff = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getRolloff() {
        return this.rolloff;
    }

    void setReflectionCoefficient(float f) {
        this.reflectionCoefficient = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getReflectionCoefficient() {
        return this.reflectionCoefficient;
    }

    void setReflectionDelay(float f) {
        this.reflectionDelay = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getReflectionDelay() {
        return this.reflectionDelay;
    }

    void setReverbCoefficient(float f) {
        this.reverbCoefficient = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getReverbCoefficient() {
        return this.reverbCoefficient;
    }

    void setReverbDelay(float f) {
        this.reverbDelay = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getReverbDelay() {
        return this.reverbDelay;
    }

    void setDecayTime(float f) {
        this.decayTime = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getDecayTime() {
        return this.decayTime;
    }

    void setDecayFilter(float f) {
        this.decayFilter = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getDecayFilter() {
        return this.decayFilter;
    }

    void setDiffusion(float f) {
        this.diffusion = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getDiffusion() {
        return this.diffusion;
    }

    void setDensity(float f) {
        this.density = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getDensity() {
        return this.density;
    }

    synchronized void setReverbBounds(Bounds bounds) {
        this.reverbBounds = bounds;
        this.aaDirty = true;
        this.notifyUsers();
    }

    Bounds getReverbBounds() {
        return this.reverbBounds;
    }

    void setReverbOrder(int n) {
        this.reverbOrder = n;
        this.aaDirty = true;
        this.notifyUsers();
    }

    int getReverbOrder() {
        return this.reverbOrder;
    }

    synchronized void setDistanceFilter(Point2f[] point2fArray) {
        if (point2fArray == null) {
            this.filterType = -1;
            return;
        }
        int n = point2fArray.length;
        if (n == 0) {
            this.filterType = -1;
            return;
        }
        this.filterType = 1;
        if (this.distance == null || this.distance != null && this.distance.length != n) {
            this.distance = new float[n];
            this.frequencyCutoff = new float[n];
        }
        for (int i = 0; i < n; ++i) {
            this.distance[i] = point2fArray[i].x;
            this.frequencyCutoff[i] = point2fArray[i].y;
        }
        this.aaDirty = true;
        this.notifyUsers();
    }

    synchronized void setDistanceFilter(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            this.filterType = -1;
            return;
        }
        int n = fArray.length;
        int n2 = fArray2.length;
        if (n == 0 || n2 == 0) {
            this.filterType = -1;
            return;
        }
        if (this.distance == null || this.distance != null && this.distance.length != n2) {
            this.distance = new float[n];
            this.frequencyCutoff = new float[n];
        }
        this.filterType = 1;
        System.arraycopy(fArray, 0, this.distance, 0, n);
        if (n <= n2) {
            System.arraycopy(fArray2, 0, this.frequencyCutoff, 0, n);
        } else {
            System.arraycopy(fArray2, 0, this.frequencyCutoff, 0, n2);
            for (int i = n2; i < n; ++i) {
                this.frequencyCutoff[i] = fArray2[n2 - 1];
            }
        }
        this.aaDirty = true;
        this.notifyUsers();
    }

    int getDistanceFilterLength() {
        if (this.distance == null) {
            return 0;
        }
        return this.distance.length;
    }

    void getDistanceFilter(Point2f[] point2fArray) {
        if (point2fArray == null) {
            return;
        }
        if (this.distance == null || this.frequencyCutoff == null) {
            return;
        }
        int n = this.distance.length;
        if (n > point2fArray.length) {
            n = point2fArray.length;
        }
        for (int i = 0; i < n; ++i) {
            point2fArray[i].x = this.distance[i];
            if (this.filterType == -1) {
                point2fArray[i].y = -1.0f;
                continue;
            }
            if (this.filterType != 1) continue;
            point2fArray[i].y = this.frequencyCutoff[i];
        }
    }

    void getDistanceFilter(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            return;
        }
        if (this.distance == null || this.frequencyCutoff == null) {
            return;
        }
        int n = this.distance.length;
        if (fArray.length < n) {
            n = fArray.length;
        }
        System.arraycopy(this.distance, 0, fArray, 0, n);
        int n2 = this.frequencyCutoff.length;
        if (fArray2.length < n2) {
            n2 = fArray2.length;
        }
        if (this.filterType == -1) {
            for (int i = 0; i < n2; ++i) {
                fArray2[i] = -1.0f;
            }
        }
        if (this.filterType == 1) {
            System.arraycopy(this.frequencyCutoff, 0, fArray2, 0, n2);
        }
    }

    void setFrequencyScaleFactor(float f) {
        this.frequencyScaleFactor = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getFrequencyScaleFactor() {
        return this.frequencyScaleFactor;
    }

    void setVelocityScaleFactor(float f) {
        this.velocityScaleFactor = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getVelocityScaleFactor() {
        return this.velocityScaleFactor;
    }

    synchronized void reset(AuralAttributesRetained auralAttributesRetained) {
        this.attributeGain = auralAttributesRetained.attributeGain;
        this.rolloff = auralAttributesRetained.rolloff;
        this.reflectionCoefficient = auralAttributesRetained.reflectionCoefficient;
        this.reverbCoefficient = auralAttributesRetained.reverbCoefficient;
        this.reflectionDelay = auralAttributesRetained.reflectionDelay;
        this.reverbDelay = auralAttributesRetained.reverbDelay;
        this.reverbBounds = auralAttributesRetained.reverbBounds;
        this.reverbOrder = auralAttributesRetained.reverbOrder;
        this.decayTime = auralAttributesRetained.decayTime;
        this.decayFilter = auralAttributesRetained.decayFilter;
        this.diffusion = auralAttributesRetained.diffusion;
        this.density = auralAttributesRetained.density;
        this.frequencyScaleFactor = auralAttributesRetained.frequencyScaleFactor;
        this.velocityScaleFactor = auralAttributesRetained.velocityScaleFactor;
        if (auralAttributesRetained.distance != null) {
            this.distance = new float[auralAttributesRetained.distance.length];
            System.arraycopy(auralAttributesRetained.distance, 0, this.distance, 0, this.distance.length);
        }
        if (auralAttributesRetained.frequencyCutoff != null) {
            this.frequencyCutoff = new float[auralAttributesRetained.frequencyCutoff.length];
            System.arraycopy(auralAttributesRetained.frequencyCutoff, 0, this.frequencyCutoff, 0, this.frequencyCutoff.length);
        }
        this.aaDirty = false;
        auralAttributesRetained.aaDirty = false;
    }

    void update(AuralAttributesRetained auralAttributesRetained) {
        this.reset(auralAttributesRetained);
    }
}

