/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Geometry;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.Modifier;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.RenderObject;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.MovingMatrix4;
import org.sunflow.system.UI;

public class Instance
implements RenderObject {
    private MovingMatrix4 o2w = new MovingMatrix4(null);
    private MovingMatrix4 w2o = new MovingMatrix4(null);
    private BoundingBox bounds = null;
    private Geometry geometry = null;
    private Shader[] shaders = null;
    private Modifier[] modifiers = null;

    public static Instance createTemporary(PrimitiveList primitiveList, Matrix4 matrix4, Shader shader) {
        Instance instance = new Instance();
        instance.o2w = new MovingMatrix4(matrix4);
        instance.w2o = instance.o2w.inverse();
        if (instance.w2o == null) {
            UI.printError(UI.Module.GEOM, "Unable to compute transform inverse", new Object[0]);
            return null;
        }
        instance.geometry = new Geometry(primitiveList);
        instance.shaders = new Shader[]{shader};
        instance.updateBounds();
        return instance;
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        String[] stringArray;
        String[] stringArray2;
        String string = parameterList.getString("geometry", null);
        if (this.geometry == null || string != null) {
            if (string == null) {
                UI.printError(UI.Module.GEOM, "geometry parameter missing - unable to create instance", new Object[0]);
                return false;
            }
            this.geometry = sunflowAPI.lookupGeometry(string);
            if (this.geometry == null) {
                UI.printError(UI.Module.GEOM, "Geometry \"%s\" was not declared yet - instance is invalid", string);
                return false;
            }
        }
        if ((stringArray2 = parameterList.getStringArray("shaders", null)) != null) {
            this.shaders = new Shader[stringArray2.length];
            for (int i = 0; i < this.shaders.length; ++i) {
                this.shaders[i] = sunflowAPI.lookupShader(stringArray2[i]);
                if (this.shaders[i] != null) continue;
                UI.printWarning(UI.Module.GEOM, "Shader \"%s\" was not declared yet - ignoring", stringArray2[i]);
            }
        }
        if ((stringArray = parameterList.getStringArray("modifiers", null)) != null) {
            this.modifiers = new Modifier[stringArray.length];
            for (int i = 0; i < this.modifiers.length; ++i) {
                this.modifiers[i] = sunflowAPI.lookupModifier(stringArray[i]);
                if (this.modifiers[i] != null) continue;
                UI.printWarning(UI.Module.GEOM, "Modifier \"%s\" was not declared yet - ignoring", stringArray[i]);
            }
        }
        this.o2w = parameterList.getMovingMatrix("transform", this.o2w);
        this.w2o = this.o2w.inverse();
        if (this.w2o == null) {
            UI.printError(UI.Module.GEOM, "Unable to compute transform inverse", new Object[0]);
            return false;
        }
        return true;
    }

    public void updateBounds() {
        this.bounds = this.geometry.getWorldBounds(this.o2w.getData(0));
        for (int i = 1; i < this.o2w.numSegments(); ++i) {
            this.bounds.include(this.geometry.getWorldBounds(this.o2w.getData(i)));
        }
    }

    public boolean hasGeometry(Geometry geometry) {
        return this.geometry == geometry;
    }

    public void removeShader(Shader shader) {
        if (this.shaders != null) {
            for (int i = 0; i < this.shaders.length; ++i) {
                if (this.shaders[i] != shader) continue;
                this.shaders[i] = null;
            }
        }
    }

    public void removeModifier(Modifier modifier) {
        if (this.modifiers != null) {
            for (int i = 0; i < this.modifiers.length; ++i) {
                if (this.modifiers[i] != modifier) continue;
                this.modifiers[i] = null;
            }
        }
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    int getNumPrimitives() {
        return this.geometry.getNumPrimitives();
    }

    void intersect(Ray ray, IntersectionState intersectionState) {
        Ray ray2 = ray.transform(this.w2o.sample(intersectionState.time));
        intersectionState.current = this;
        this.geometry.intersect(ray2, intersectionState);
        ray.setMax(ray2.getMax());
    }

    public void prepareShadingState(ShadingState shadingState) {
        this.geometry.prepareShadingState(shadingState);
        if (shadingState.getNormal() != null && shadingState.getGeoNormal() != null) {
            shadingState.correctShadingNormal();
        }
        if (shadingState.getModifier() != null) {
            shadingState.getModifier().modify(shadingState);
        }
    }

    public Shader getShader(int n) {
        if (this.shaders == null || n < 0 || n >= this.shaders.length) {
            return null;
        }
        return this.shaders[n];
    }

    public Modifier getModifier(int n) {
        if (this.modifiers == null || n < 0 || n >= this.modifiers.length) {
            return null;
        }
        return this.modifiers[n];
    }

    Matrix4 getObjectToWorld(float f) {
        return this.o2w.sample(f);
    }

    Matrix4 getWorldToObject(float f) {
        return this.w2o.sample(f);
    }

    PrimitiveList getBakingPrimitives() {
        return this.geometry.getBakingPrimitives();
    }

    Geometry getGeometry() {
        return this.geometry;
    }
}

