/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.math;

import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;

public class BoundingBox {
    private Point3 minimum;
    private Point3 maximum;

    public BoundingBox() {
        this.minimum = new Point3(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        this.maximum = new Point3(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
    }

    public BoundingBox(BoundingBox boundingBox) {
        this.minimum = new Point3(boundingBox.minimum);
        this.maximum = new Point3(boundingBox.maximum);
    }

    public BoundingBox(Point3 point3) {
        this(point3.x, point3.y, point3.z);
    }

    public BoundingBox(float f, float f2, float f3) {
        this.minimum = new Point3(f, f2, f3);
        this.maximum = new Point3(f, f2, f3);
    }

    public BoundingBox(float f) {
        this.minimum = new Point3(-f, -f, -f);
        this.maximum = new Point3(f, f, f);
    }

    public final Point3 getMinimum() {
        return this.minimum;
    }

    public final Point3 getMaximum() {
        return this.maximum;
    }

    public final Point3 getCenter() {
        return Point3.mid(this.minimum, this.maximum, new Point3());
    }

    public final Point3 getCorner(int n) {
        float f = (n & 1) == 0 ? this.minimum.x : this.maximum.x;
        float f2 = (n & 2) == 0 ? this.minimum.y : this.maximum.y;
        float f3 = (n & 4) == 0 ? this.minimum.z : this.maximum.z;
        return new Point3(f, f2, f3);
    }

    public final float getBound(int n) {
        switch (n) {
            case 0: {
                return this.minimum.x;
            }
            case 1: {
                return this.maximum.x;
            }
            case 2: {
                return this.minimum.y;
            }
            case 3: {
                return this.maximum.y;
            }
            case 4: {
                return this.minimum.z;
            }
            case 5: {
                return this.maximum.z;
            }
        }
        return 0.0f;
    }

    public final Vector3 getExtents() {
        return Point3.sub(this.maximum, this.minimum, new Vector3());
    }

    public final float getArea() {
        Vector3 vector3 = this.getExtents();
        float f = Math.max(vector3.x, 0.0f);
        float f2 = Math.max(vector3.y, 0.0f);
        float f3 = Math.max(vector3.z, 0.0f);
        return 2.0f * (f * f2 + f2 * f3 + f3 * f);
    }

    public final float getVolume() {
        Vector3 vector3 = this.getExtents();
        float f = Math.max(vector3.x, 0.0f);
        float f2 = Math.max(vector3.y, 0.0f);
        float f3 = Math.max(vector3.z, 0.0f);
        return f * f2 * f3;
    }

    public final void enlargeUlps() {
        this.minimum.x -= Math.max(1.0E-4f, Math.ulp(this.minimum.x));
        this.minimum.y -= Math.max(1.0E-4f, Math.ulp(this.minimum.y));
        this.minimum.z -= Math.max(1.0E-4f, Math.ulp(this.minimum.z));
        this.maximum.x += Math.max(1.0E-4f, Math.ulp(this.maximum.x));
        this.maximum.y += Math.max(1.0E-4f, Math.ulp(this.maximum.y));
        this.maximum.z += Math.max(1.0E-4f, Math.ulp(this.maximum.z));
    }

    public final boolean isEmpty() {
        return this.maximum.x < this.minimum.x || this.maximum.y < this.minimum.y || this.maximum.z < this.minimum.z;
    }

    public final boolean intersects(BoundingBox boundingBox) {
        return boundingBox != null && this.minimum.x <= boundingBox.maximum.x && this.maximum.x >= boundingBox.minimum.x && this.minimum.y <= boundingBox.maximum.y && this.maximum.y >= boundingBox.minimum.y && this.minimum.z <= boundingBox.maximum.z && this.maximum.z >= boundingBox.minimum.z;
    }

    public final boolean contains(Point3 point3) {
        return point3 != null && point3.x >= this.minimum.x && point3.x <= this.maximum.x && point3.y >= this.minimum.y && point3.y <= this.maximum.y && point3.z >= this.minimum.z && point3.z <= this.maximum.z;
    }

    public final boolean contains(float f, float f2, float f3) {
        return f >= this.minimum.x && f <= this.maximum.x && f2 >= this.minimum.y && f2 <= this.maximum.y && f3 >= this.minimum.z && f3 <= this.maximum.z;
    }

    public final void include(Point3 point3) {
        if (point3 != null) {
            if (point3.x < this.minimum.x) {
                this.minimum.x = point3.x;
            }
            if (point3.x > this.maximum.x) {
                this.maximum.x = point3.x;
            }
            if (point3.y < this.minimum.y) {
                this.minimum.y = point3.y;
            }
            if (point3.y > this.maximum.y) {
                this.maximum.y = point3.y;
            }
            if (point3.z < this.minimum.z) {
                this.minimum.z = point3.z;
            }
            if (point3.z > this.maximum.z) {
                this.maximum.z = point3.z;
            }
        }
    }

    public final void include(float f, float f2, float f3) {
        if (f < this.minimum.x) {
            this.minimum.x = f;
        }
        if (f > this.maximum.x) {
            this.maximum.x = f;
        }
        if (f2 < this.minimum.y) {
            this.minimum.y = f2;
        }
        if (f2 > this.maximum.y) {
            this.maximum.y = f2;
        }
        if (f3 < this.minimum.z) {
            this.minimum.z = f3;
        }
        if (f3 > this.maximum.z) {
            this.maximum.z = f3;
        }
    }

    public final void include(BoundingBox boundingBox) {
        if (boundingBox != null) {
            if (boundingBox.minimum.x < this.minimum.x) {
                this.minimum.x = boundingBox.minimum.x;
            }
            if (boundingBox.maximum.x > this.maximum.x) {
                this.maximum.x = boundingBox.maximum.x;
            }
            if (boundingBox.minimum.y < this.minimum.y) {
                this.minimum.y = boundingBox.minimum.y;
            }
            if (boundingBox.maximum.y > this.maximum.y) {
                this.maximum.y = boundingBox.maximum.y;
            }
            if (boundingBox.minimum.z < this.minimum.z) {
                this.minimum.z = boundingBox.minimum.z;
            }
            if (boundingBox.maximum.z > this.maximum.z) {
                this.maximum.z = boundingBox.maximum.z;
            }
        }
    }

    public final String toString() {
        return String.format("(%.2f, %.2f, %.2f) to (%.2f, %.2f, %.2f)", Float.valueOf(this.minimum.x), Float.valueOf(this.minimum.y), Float.valueOf(this.minimum.z), Float.valueOf(this.maximum.x), Float.valueOf(this.maximum.y), Float.valueOf(this.maximum.z));
    }
}

