/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_eu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "gujaratera";
        final String metaValue_he = "hebreera";
        final String metaValue_la = "latina";
        final String metaValue_ml = "malayalamera";
        final String metaValue_si = "sinhala";
        final Object[][] data = new Object[][] {
            { "sbp", "sanguera" },
            { "nyn", "ankolera" },
            { "key.colStrength", "Ordenaren sendotasuna" },
            { "luo", "luoera" },
            { "Zsym", "ikurrak" },
            { "fil", "tagaloga" },
            { "luy", "luhyera" },
            { "es_ES", "espainiera (Europa)" },
            { "teo", "tesoera" },
            { "ab", "abkhazera" },
            { "AC", "Ascension uhartea" },
            { "tet", "tetuma" },
            { "key.colCaseFirst", "Maiuskula/Minuskula ordena" },
            { "AD", "Andorra" },
            { "AE", "Arabiar Emirerri Batuak" },
            { "nl_BE", "flandriera" },
            { "AF", "Afganistan" },
            { "af", "afrikaansa" },
            { "AG", "Antigua eta Barbuda" },
            { "type.ca.ethiopic", "Egutegi etiopiarra" },
            { "AI", "Angila" },
            { "key.tz", "Ordu-zona" },
            { "ak", "akanera" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "am", "amharera" },
            { "Arab", "arabiarra" },
            { "AO", "Angola" },
            { "AQ", "Antartika" },
            { "Jpan", "japoniarra" },
            { "AR", "Argentina" },
            { "ar", "arabiera" },
            { "AS", "Amerikar Samoa" },
            { "as", "assamera" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "ingelesa (AEB)" },
            { "AX", "Aland uharteak" },
            { "key.colNormalization", "Araututako ordena" },
            { "ay", "aimara" },
            { "AZ", "Azerbaijan" },
            { "az", "azerbaijanera" },
            { "BA", "Bosnia-Herzegovina" },
            { "ba", "bashkirrera" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "type.co.unihan", "Radical trazuen hurrenkera" },
            { "BE", "Belgika" },
            { "be", "bielorrusiera" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "bg", "bulgariera" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "bm", "bambarera" },
            { "BN", "Brunei" },
            { "bn", "bengalera" },
            { "BO", "Bolivia" },
            { "bo", "tibetera" },
            { "BQ", "Karibeko Herbehereak" },
            { "BR", "Brasil" },
            { "br", "bretoiera" },
            { "BS", "Bahamak" },
            { "bs", "bosniera" },
            { "xog", "sogera" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet uhartea" },
            { "BW", "Botswana" },
            { "Mymr", "birmaniarra" },
            { "type.nu.laoo", "Digitu laostarrak" },
            { "BY", "Bielorrusia" },
            { "seh", "senera" },
            { "BZ", "Belize" },
            { "type.ca.persian", "Egutegi persiarra" },
            { "type.nu.hebr", "Zenbaki hebrearrak" },
            { "CA", "Kanada" },
            { "ca", "katalana" },
            { "CC", "Cocos uharteak" },
            { "ses", "koyraboro sennia" },
            { "CD", "Kongoko Errepublika Demokratikoa" },
            { "CF", "Afrika Erdiko Errepublika" },
            { "CG", "Kongo (Brazzaville)" },
            { "CH", "Suitza" },
            { "CI", "Boli Kosta" },
            { "%%REVISED", "BERRIKUSIA" },
            { "CK", "Cook uharteak" },
            { "CL", "Txile" },
            { "CM", "Kamerun" },
            { "CN", "Txina" },
            { "CO", "Kolonbia" },
            { "co", "korsikera" },
            { "CP", "Clipperton uhartea" },
            { "Orya", "oriyarra" },
            { "CR", "Costa Rica" },
            { "cs", "txekiera" },
            { "CU", "Kuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas uhartea" },
            { "CY", "Zipre" },
            { "cy", "galesera" },
            { "CZ", "Txekiar Errepublika" },
            { "type.nu.ethi", "Zenbaki etiopiarrak" },
            { "da", "daniera" },
            { "pt_PT", "portugesa (Europa)" },
            { "DE", "Alemania" },
            { "de", "alemana" },
            { "cgg", "chigera" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "Digitu devanagariak" },
            { "DJ", "Djibuti" },
            { "type.colNumeric.no", "Ordenatu digituak banaka" },
            { "DK", "Danimarka" },
            { "ach", "Acholiera" },
            { "Brai", "braillea" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "Zenbaki armeniarrak minuskulaz" },
            { "DO", "Dominikar Errepublika" },
            { "bem", "bembera" },
            { "type.nu.mong", "Digitu mongoliarrak" },
            { "key.variableTop", "Ordenatu ikur gisa" },
            { "dv", "divehiera" },
            { "DZ", "Aljeria" },
            { "dz", "dzongkha" },
            { "bez", "benera" },
            { "type.ca.chinese", "Txinatar egutegia" },
            { "EA", "Ceuta eta Melilla" },
            { "EC", "Ekuador" },
            { "dje", "zarmera" },
            { "type.nu.grek", "Zenbaki grekoak" },
            { "EE", "Estonia" },
            { "ee", "eweera" },
            { "EG", "Egipto" },
            { "EH", "Mendebaldeko Sahara" },
            { "type.colNormalization.yes", "Ordenatu Unicode arauen arabera" },
            { "el", "greziera" },
            { "en", "ingelesa" },
            { "eo", "esperantoa" },
            { "chr", "txerokiera" },
            { "ER", "Eritrea" },
            { "type.co.big5han", "Txinera tradizionalaren alfabetoa-Big5" },
            { "ES", "Espainia" },
            { "es", "espainiera" },
            { "ET", "Etiopia" },
            { "et", "estoniera" },
            { "EU", "Europar Batasuna" },
            { "eu", "euskara" },
            { "Hang", "hangula" },
            { "type.ca.gregorian", "Egutegi gregoriarra" },
            { "shi", "tachelhita" },
            { "type.nu.gujr", "Digitu gujaratarrak" },
            { "hsb", "goi-sorabiera" },
            { "Hani", "idazkera txinatarra" },
            { "fa", "persiera" },
            { "Hans", "sinplifikatua" },
            { "type.nu.latn", "Digitu mendebaldarrak" },
            { "Hant", "tradizionala" },
            { "FI", "Finlandia" },
            { "fi", "finlandiera" },
            { "FJ", "Fiji" },
            { "fj", "fijiera" },
            { "FK", "Malvinak" },
            { "FM", "Mikronesia" },
            { "key.va", "Eskualdeko ezarpenen aldaera" },
            { "FO", "Faroe uharteak" },
            { "fo", "faroera" },
            { "Taml", "tamilarra" },
            { "FR", "Frantzia" },
            { "fr", "frantsesa" },
            { "fy", "frisiera" },
            { "type.ca.indian", "Indiar egutegia" },
            { "GA", "Gabon" },
            { "ga", "gaelikoa" },
            { "GB", "Erresuma Batua" },
            { "GD", "Grenada" },
            { "gd", "eskoziako gaelikoa" },
            { "GE", "Georgia" },
            { "GF", "Guyana Frantsesa" },
            { "GG", "Guernesey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "key.colCaseLevel", "Maiuskulak eta minuskulak bereizten dituen ordena" },
            { "GL", "Groenlandia" },
            { "gl", "galiziera" },
            { "GM", "Gambia" },
            { "GN", "Ginea" },
            { "gn", "guaraniera" },
            { "GP", "Guadalupe" },
            { "GQ", "Ekuatore Ginea" },
            { "und", "hizkuntza ezezaguna" },
            { "GR", "Grezia" },
            { "type.ca.ethiopic-amete-alem", "Amete Alem egutegi etiopiarra" },
            { "GS", "Hegoaldeko Georgia eta Hegoaldeko Sandwich uharteak" },
            { "GT", "Guatemala" },
            { "gu", metaValue_gu },
            { "GU", "Guam" },
            { "gv", "manxera" },
            { "GW", "Ginea-Bissau" },
            { "tlh", "Klingonera" },
            { "GY", "Guyana" },
            { "ha", "hausa" },
            { "ckb", "soraniera" },
            { "zxx", "ez dago eduki linguistikorik" },
            { "he", metaValue_he },
            { "hi", "hindia" },
            { "HK", "Hong Kong AEB Txina" },
            { "HM", "Heard eta McDonald uharteak" },
            { "HN", "Honduras" },
            { "HR", "Kroazia" },
            { "hr", "kroaziera" },
            { "agq", "aghemera" },
            { "gsw", "alemana (Suitza)" },
            { "HT", "Haiti" },
            { "ht", "haitiera" },
            { "HU", "Hungaria" },
            { "hu", "hungariera" },
            { "hy", "armeniera" },
            { "ia", "Interlingua" },
            { "IC", "Kanariak" },
            { "ID", "Indonesia" },
            { "id", "indonesiera" },
            { "type.nu.tibt", "Digitu tibetarrak" },
            { "IE", "Irlanda" },
            { "ie", "interlingue" },
            { "ig", "igboera" },
            { "naq", "namera" },
            { "ii", "sichuan yia" },
            { "IL", "Israel" },
            { "IM", "Man uhartea" },
            { "IN", "India" },
            { "IO", "Indiako Ozeanoko lurralde britainiarra" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islandia" },
            { "is", "islandiera" },
            { "IT", "Italia" },
            { "it", "italiera" },
            { "iu", "inuitera" },
            { "type.nu.thai", "Digitu thailandiarrak" },
            { "type.nu.beng", "Digitu bengalarrak" },
            { "Mlym", metaValue_ml },
            { "ja", "japoniera" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Islamiar egutegia" },
            { "JM", "Jamaika" },
            { "Beng", "bengaliarra" },
            { "JO", "Jordania" },
            { "JP", "Japonia" },
            { "sma", "hegoaldeko samiera" },
            { "jv", "javera" },
            { "guz", "gusiiera" },
            { "type.nu.knda", "Digitu kannadarrak" },
            { "smj", "Lule samiera" },
            { "de_CH", "aleman garaia (Suitza)" },
            { "smn", "Inari samiera" },
            { "type.co.phonetic", "Ordenatzeko irizpide fonetikoa" },
            { "ka", "georgiera" },
            { "type.ca.buddhist", "Egutegi budista" },
            { "sms", "Skolt samiera" },
            { "KE", "Kenya" },
            { "419", "Latinoamerika" },
            { "KG", "Kirgizistan" },
            { "kg", "Kikongoa" },
            { "KH", "Kanbodia" },
            { "KI", "Kiribati" },
            { "ki", "kikuyuera" },
            { "mas", "masaiera" },
            { "kk", "kazakhera" },
            { "kl", "kalaallisutera" },
            { "KM", "Komoreak" },
            { "km", "khemerera" },
            { "KN", "Saint Kitts eta Nevis" },
            { "kn", "kannadera" },
            { "Knda", "kanadarra" },
            { "type.colStrength.identical", "Ordenatu guztiak" },
            { "ko", "koreera" },
            { "KP", "Ipar Korea" },
            { "KR", "Hego Korea" },
            { "ks", "kashmirera" },
            { "ku", "kurduera" },
            { "KW", "Kuwait" },
            { "kw", "kornubiera" },
            { "tpi", "tok pisina" },
            { "KY", "Kaiman uharteak" },
            { "ky", "kirgizera" },
            { "KZ", "Kazakhstan" },
            { "Cyrl", "zirilikoa" },
            { "type.colStrength.primary", "Ordenatu oinarrizko hizkiak soilik" },
            { "la", metaValue_la },
            { "LA", "Laos" },
            { "LB", "Libano" },
            { "lb", "luxenburgera" },
            { "LC", "Santa Luzia" },
            { "type.nu.mlym", "Digitu malayalamarrak" },
            { "lg", "gandera" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "Tibt", "tibetarra" },
            { "ln", "lingala" },
            { "type.colCaseLevel.no", "Ordenatu maiuskulak eta minuskulak bereizi gabe" },
            { "lo", "laosera" },
            { "type.colStrength.tertiary", "Ordenatu azentuak / maiuskula eta minuskulak / zabalera" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "lt", "lituaniera" },
            { "LU", "Luxenburgo" },
            { "lu", "luba-katangera" },
            { "LV", "Letonia" },
            { "lv", "letoniera" },
            { "Kana", "katakana" },
            { "LY", "Libia" },
            { "vun", "vunjoa" },
            { "lag", "langiera" },
            { "Thaa", "thaana" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "mg", "malagasyera" },
            { "MH", "Marshall uharteak" },
            { "Thai", "thailandiarra" },
            { "type.co.ducet", "Unicode hurrenkera lehenetsia" },
            { "mi", "maoriera" },
            { "type.nu.vaii", "Vai digituak" },
            { "MK", "Mazedonia" },
            { "mk", "mazedoniera" },
            { "ml", metaValue_ml },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongolia" },
            { "mn", "mongoliera" },
            { "MO", "Macau AEB Txina" },
            { "MP", "Iparraldeko Mariana uharteak" },
            { "MQ", "Martinika" },
            { "MR", "Mauritania" },
            { "mr", "marathera" },
            { "MS", "Montserrat" },
            { "ms", "malaysiera" },
            { "type.colAlternate.non-ignorable", "Ordenatu ikurrak" },
            { "MT", "Malta" },
            { "mt", "maltera" },
            { "MU", "Maurizio" },
            { "MV", "Maldivak" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "type.ca.japanese", "Japoniar egutegia" },
            { "MY", "Malaysia" },
            { "my", "burmatarra" },
            { "MZ", "Mozambike" },
            { "Armn", "armeniarra" },
            { "dsb", "behe-sorabiera" },
            { "NA", "Namibia" },
            { "type.co.search", "Bilaketa orokorra" },
            { "nb", "bokmala (Norvegia)" },
            { "type.ca.hebrew", "Hebrear egutegia" },
            { "type.co.dictionary", "Hurrenkera alfabetikoa" },
            { "NC", "Kaledonia Berria" },
            { "nd", "iparraldeko ndebeleera" },
            { "NE", "Niger" },
            { "ne", "nepalera" },
            { "NF", "Norfolk uhartea" },
            { "NG", "Nigeria" },
            { "NI", "Nikaragua" },
            { "NL", "Herbehereak" },
            { "nl", "nederlandera" },
            { "nn", "nynorsk norvegiera" },
            { "NO", "Norvegia" },
            { "no", "norvegiera" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "romboera" },
            { "ny", "nyanja" },
            { "NZ", "Zeelanda Berria" },
            { "kab", "kabilera" },
            { "%%POLYTON", "POLITON" },
            { "type.colCaseFirst.lower", "Ordenatu minuskulak lehenik" },
            { "oc", "Okzitaniera" },
            { "kam", "kambera" },
            { "type.colAlternate.shifted", "Ordenatu ikurrei ez ikusi eginda" },
            { "mer", "meruera" },
            { "type.nu.armn", "Zenbaki armeniarrak" },
            { "OM", "Oman" },
            { "om", "oromoera" },
            { "or", "oriyera" },
            { "os", "osetiera" },
            { "mfe", "Mauritaniako kreolera" },
            { "PA", "Panama" },
            { "pa", "punjabera" },
            { "dua", "dualera" },
            { "type.ca.islamic-civil", "Islamiar egutegi zibila" },
            { "PE", "Peru" },
            { "PF", "Polinesia Frantsesa" },
            { "PG", "Papua Ginea Berria" },
            { "PH", "Filipinak" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "pl", "poloniera" },
            { "PM", "Saint-Pierre eta Mikelune" },
            { "PN", "Pitcairn uharteak" },
            { "type.ca.dangi", "Dangi egutegia" },
            { "type.colBackwards.yes", "Ordenatu azentuak alderantziz" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinako Lurraldeak" },
            { "ps", "paxtuera" },
            { "PT", "Portugal" },
            { "pt", "portugesa" },
            { "key.co", "Ordenatzeko irizpidea" },
            { "PW", "Palau" },
            { "type.nu.greklow", "Zenbaki grekoak minuskulaz" },
            { "PY", "Paraguai" },
            { "tum", "Tumbukera" },
            { "Hebr", metaValue_he },
            { "mgh", "makhuwa-meettoera" },
            { "QA", "Qatar" },
            { "key.ca", "Egutegia" },
            { "Laoo", "laosarra" },
            { "mgo", "metera" },
            { "%%SCOTLAND", "ESKOZIAR INGELESA" },
            { "type.nu.mymr", "Digitu birmaniarrak" },
            { "QO", "Mugaz kanpoko Ozeania" },
            { "qu", "quechuera" },
            { "brx", "bodoera" },
            { "kde", "makondera" },
            { "001", "Mundua" },
            { "Ethi", "etiopiarra" },
            { "002", "Afrika" },
            { "003", "Ipar Amerika" },
            { "RE", "Reunion" },
            { "type.colNormalization.no", "Ordenatu arauak kontuan hartu gabe" },
            { "005", "Hego Amerika" },
            { "009", "Ozeania" },
            { "rm", "erromantxera" },
            { "rn", "rundiera" },
            { "key.cu", "Moneta" },
            { "RO", "Errumania" },
            { "ro", "errumaniera" },
            { "%%SAAHO", "SAHO" },
            { "RS", "Serbia" },
            { "type.nu.orya", "Digitu oriyarrak" },
            { "type.nu.hanidec", "Zenbaki hamartar txinatarrak" },
            { "RU", "Errusia" },
            { "ru", "errusiera" },
            { "RW", "Ruanda" },
            { "rw", "kinyaruanda" },
            { "kea", "Cabo Verdeko kreola" },
            { "key.colAlternate", "Egin ez ikusi ikurren ordenari" },
            { "SA", "Saudi Arabia" },
            { "sa", "sanskritoa" },
            { "SB", "Salomon uharteak" },
            { "twq", "tasawaqa" },
            { "011", "Afrika mendebaldea" },
            { "SC", "Seychelleak" },
            { "SD", "Sudan" },
            { "sd", "sindhia" },
            { "013", "Erdialdeko Amerika" },
            { "SE", "Suedia" },
            { "se", "iparraldeko samiera" },
            { "014", "Afrika ekialdea" },
            { "015", "Afrika iparraldea" },
            { "SG", "Singapur" },
            { "sg", "sangoera" },
            { "SH", "Saint Helena" },
            { "sh", "serbokroaziera" },
            { "si", metaValue_si },
            { "017", "Erdialdeko Afrika" },
            { "SI", "Eslovenia" },
            { "018", "Afrika hegoaldea" },
            { "SJ", "Svalbard eta Jan Mayen uharteak" },
            { "019", "Amerika" },
            { "SK", "Eslovakia" },
            { "sk", "eslovakiera" },
            { "SL", "Sierra Leona" },
            { "sl", "esloveniera" },
            { "SM", "San Marino" },
            { "sm", "samoera" },
            { "SN", "Senegal" },
            { "sn", "shonera" },
            { "SO", "Somalia" },
            { "so", "somaliera" },
            { "arn", "maputxea" },
            { "type.nu.arab", "Digitu arabiar-hindikoak" },
            { "sq", "albaniera" },
            { "type.nu.taml", "Zenbaki tamilar tradizionalak" },
            { "SR", "Surinam" },
            { "sr", "serbiera" },
            { "SS", "Hego Sudan" },
            { "ss", "swatiera" },
            { "ST", "Sao Tome eta Principe" },
            { "st", "hegoaldeko sothoera" },
            { "su", "sundanera" },
            { "SV", "El Salvador" },
            { "sv", "suediera" },
            { "sw", "swahili" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "type.nu.hantfin", "Finantzetarako zenbaki txinatar tradizionalak" },
            { "SZ", "Swazilandia" },
            { "TA", "Tristan da Cunha" },
            { "ta", "tamilera" },
            { "asa", "asua" },
            { "021", "Amerika iparraldea" },
            { "142", "Asia" },
            { "TC", "Turk eta Caicos uharteak" },
            { "143", "Asia erdialdea" },
            { "TD", "Txad" },
            { "te", "teluguera" },
            { "145", "Asia mendebaldea" },
            { "TF", "Hegoaldeko lurralde frantsesak" },
            { "TG", "Togo" },
            { "tg", "tajikistanera" },
            { "TH", "Thailandia" },
            { "th", "thailandiera" },
            { "ti", "tigri\u00f1era" },
            { "type.colNumeric.yes", "Ordenatu digituak zenbakien arabera" },
            { "TJ", "Tajikistan" },
            { "029", "Karibea" },
            { "TK", "Tokelau" },
            { "tk", "turkmeniera" },
            { "TL", "Ekialdeko Timor" },
            { "tl", "tagalog" },
            { "type.co.searchjl", "Bilatu hangularen lehen kontsonantearen arabera" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "tn", "tswanera" },
            { "TO", "Tonga" },
            { "to", "tongera" },
            { "dyo", "fonyi jolera" },
            { "type.nu.jpan", "Zenbaki japoniarrak" },
            { "TR", "Turkia" },
            { "tr", "turkiera" },
            { "ts", "tsongera" },
            { "TT", "Trinidad eta Tobago" },
            { "tt", "tatarera" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "tw", "twia" },
            { "ty", "tahitiera" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasiera" },
            { "Zzzz", "idazkera ezezaguna" },
            { "150", "Europa" },
            { "UA", "Ukraina" },
            { "key.colHiraganaQuaternary", "Kana ordena" },
            { "030", "Asia ekialdea" },
            { "151", "Europa ekialdea" },
            { "154", "Europa iparraldea" },
            { "sw_CD", "Kongoko swahilia" },
            { "034", "Asia hegoaldea" },
            { "155", "Europa mendebaldea" },
            { "035", "Asia hego-ekialdea" },
            { "UG", "Uganda" },
            { "ug", "uigurrera" },
            { "type.co.pinyin", "Pinyin hurrenkera" },
            { "Kore", "korearra" },
            { "Zyyy", "ohikoa" },
            { "type.colHiraganaQuaternary.yes", "Ordenatu kanak desberdin" },
            { "039", "Europa hegoaldea" },
            { "uk", "ukrainera" },
            { "Sinh", metaValue_si },
            { "type.colCaseFirst.no", "Ordenatu maiuskulak modu normalean" },
            { "UM", "Ameriketako Estatu Batuetako Kanpoaldeko Uharte Txikiak" },
            { "type.colStrength.quaternary", "Ordenatu azentuak / maiuskula eta minuskulak / zabalera / kanak" },
            { "type.ca.coptic", "Egutegi coptiarra" },
            { "ur", "urdua" },
            { "US", "Ameriketako Estatu Batuak" },
            { "haw", "hawaiiera" },
            { "type.co.gb2312han", "Txinera sinplifikatuaren alfabetoa -GB2312" },
            { "UY", "Uruguai" },
            { "UZ", "Uzbekistan" },
            { "uz", "uzbekera" },
            { "tzm", "Maroko erdialdeko tamazighta" },
            { "type.co.stroke", "Tarteen araberako hurrenkera" },
            { "VA", "Vatikano Hiria" },
            { "VC", "Saint Vincent eta Grenadinak" },
            { "VE", "Venezuela" },
            { "ve", "vendera" },
            { "type.ca.roc", "Txinako Errepublikako egutegia" },
            { "VG", "Birjina uharte britainiarrak" },
            { "VI", "Birjina uharte amerikarrak" },
            { "vi", "vietnamera" },
            { "khq", "koyra chiiniera" },
            { "VN", "Vietnam" },
            { "type.colBackwards.no", "Ordenatu azentuak modu normalean" },
            { "key.x", "Erabilera pribatua" },
            { "quc", "k\u2019iche\u2019ra" },
            { "VU", "Vanuatu" },
            { "gaa", "Ga" },
            { "rwk", "rwaera" },
            { "gag", "gagauzera" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis eta Futuna" },
            { "Grek", "greziarra" },
            { "type.co.traditional", "Tradizionala" },
            { "057", "Mikronesia eskualdea" },
            { "jgo", "ngomba" },
            { "lkt", "lakotera" },
            { "type.nu.finance", "Finantza-zenbakiak" },
            { "wo", "wolofera" },
            { "zgh", "tamazight estandarra" },
            { "ar_001", "arabiera moderno estandarra" },
            { "WS", "Samoa" },
            { "key.colNumeric", "Zenbakizko ordena" },
            { "Mong", "mongoliarra" },
            { "Latn", metaValue_la },
            { "061", "Polinesia" },
            { "type.nu.hans", "Zenbaki txinatar sinplifikatuak" },
            { "type.nu.hant", "Zenbaki txinatar tradizionalak" },
            { "xh", "xhosera" },
            { "XK", "Kosovo" },
            { "type.nu.romanlow", "Zenbaki erromatarrak minuskulaz" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "idatzi gabea" },
            { "moh", "mohawkera" },
            { "YE", "Yemen" },
            { "nqo", "n\u2019koera" },
            { "type.co.standard", "Ordenatzeko irizpide estandarra" },
            { "yi", "Jiddisha" },
            { "yo", "yorubera" },
            { "type.nu.traditional", "Zenbaki tradizionalak" },
            { "YT", "Mayotte" },
            { "vai", "vaiera" },
            { "ZA", "Hegoafrika" },
            { "kln", "kalenjinera" },
            { "Deva", "devanagaria" },
            { "zh", "txinera" },
            { "type.nu.geor", "Zenbaki georgiarrak" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "Bopo", "bopomofoa" },
            { "zu", "zuluera" },
            { "ZW", "Zimbabwe" },
            { "type.co.phonebook", "Telefonoen zerrenda" },
            { "ZZ", "Eskualde ezezaguna" },
            { "Geor", "georgiarra" },
            { "type.colCaseLevel.yes", "Ordenatu maiuskulak eta minuskulak bereizita" },
            { "type.ca.iso8601", "ISO-8601 egutegia" },
            { "nso", "pediera" },
            { "type.nu.telu", "Digitu teluguarrak" },
            { "type.nu.jpanfin", "Finantzetarako zenbaki japoniarrak" },
            { "loz", "Loziera" },
            { "type.co.reformed", "Erreformaren araberako hurrenkera" },
            { "key.colBackwards", "Azentuen alderantzizko ordena" },
            { "type.colHiraganaQuaternary.no", "Ordenatu kanak bereizita" },
            { "ebu", "embua" },
            { "jmc", "machamera" },
            { "zh_Hans", "txinera soildua" },
            { "koi", "komi-permyakera" },
            { "type.nu.hansfin", "Finantzetarako zenbaki txinatar sinplifikatuak" },
            { "type.colStrength.secondary", "Ordenatu azentuak" },
            { "kok", "konkaniera" },
            { "type.nu.arabext", "Digitu arabiar-hindiko hedatuak" },
            { "nus", "nuerera" },
            { "type.nu.fullwide", "Zabalera osoko digituak" },
            { "dav", "taitera" },
            { "zh_Hant", "txinera tradizionala" },
            { "type.nu.khmr", "Digitu khmerarrak" },
            { "%%VALENCIA", "VALENTZIERA" },
            { "mua", "mudangera" },
            { "type.nu.guru", "Digitu gurmukhiak" },
            { "Khmr", "khemerarra" },
            { "mul", "hizkuntza anitzak" },
            { "type.nu.roman", "Zenbaki erromatarrak" },
            { "type.nu.tamldec", "Digitu tamilarrak" },
            { "saq", "samburuera" },
            { "efi", "efikera" },
            { "key.nu", "Zenbakiak" },
            { "type.nu.native", "Zenbaki-sistema" },
            { "Guru", "gurmukhia" },
            { "lua", "Luba-lulua" },
            { "ksb", "shambalera" },
            { "type.colCaseFirst.upper", "Ordenatu maiuskulak lehenik" },
            { "Telu", "teluguarra" },
            { "ksf", "bafiera" },
        };
        return data;
    }
}
